/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPagesRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecordsFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;

public class OWriteAheadLog {
    private static final long ONE_KB = 1024L;
    private OLogSequenceNumber lastCheckpoint;
    private final Object syncObject = new Object();
    private final List<LogSegment> logSegments = new ArrayList<LogSegment>();
    private boolean useFirstMasterRecord = true;
    private final int maxPagesCacheSize;
    private final int commitDelay;
    private final long maxSegmentSize;
    private final long maxLogSize;
    private long logSize;
    private final File walLocation;
    private File masterRecordFile;
    private final RandomAccessFile masterRecordLSNHolder;
    private OLogSequenceNumber firstMasterRecord;
    private OLogSequenceNumber secondMasterRecord;
    private volatile OLogSequenceNumber flushedLsn;
    private final OLocalPaginatedStorage paginatedStorage;
    private boolean closed;

    private static String calculateWalPath(OLocalPaginatedStorage storage) {
        String walPath = OGlobalConfiguration.WAL_LOCATION.getValueAsString();
        if (walPath == null) {
            walPath = storage.getStoragePath();
        }
        return walPath;
    }

    public OWriteAheadLog(OLocalPaginatedStorage storage) throws IOException {
        this(OGlobalConfiguration.WAL_CACHE_SIZE.getValueAsInteger(), OGlobalConfiguration.WAL_COMMIT_TIMEOUT.getValueAsInteger(), (long)OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsInteger() * 1024L * 1024L, (long)OGlobalConfiguration.WAL_MAX_SIZE.getValueAsInteger() * 1024L * 1024L, storage);
    }

    public OWriteAheadLog(int maxPagesCacheSize, int commitDelay, long maxSegmentSize, long maxLogSize, OLocalPaginatedStorage storage) throws IOException {
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.commitDelay = commitDelay;
        this.maxSegmentSize = maxSegmentSize;
        this.maxLogSize = maxLogSize;
        this.paginatedStorage = storage;
        try {
            this.walLocation = new File(OWriteAheadLog.calculateWalPath(this.paginatedStorage));
            File[] walFiles = this.walLocation.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return OWriteAheadLog.validateName(name);
                }
            });
            if (walFiles.length == 0) {
                LogSegment logSegment = new LogSegment(new File(this.walLocation, this.getSegmentName(0)), maxPagesCacheSize);
                logSegment.init();
                logSegment.startFlush();
                this.logSegments.add(logSegment);
                this.logSize = 0L;
                this.flushedLsn = null;
            } else {
                File[] fileArray = walFiles;
                int n = walFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File walFile = fileArray[n2];
                    LogSegment logSegment = new LogSegment(walFile, maxPagesCacheSize);
                    logSegment.init();
                    this.logSegments.add(logSegment);
                    this.logSize += logSegment.filledUpTo();
                    ++n2;
                }
                Collections.sort(this.logSegments);
                this.logSegments.get(this.logSegments.size() - 1).startFlush();
                this.flushedLsn = this.readFlushedLSN();
            }
            this.masterRecordFile = new File(this.walLocation, String.valueOf(this.paginatedStorage.getName()) + ".wmr");
            this.masterRecordLSNHolder = new RandomAccessFile(this.masterRecordFile, "rws");
            if (this.masterRecordLSNHolder.length() > 0L) {
                this.firstMasterRecord = this.readMasterRecord(this.paginatedStorage.getName(), 0);
                this.secondMasterRecord = this.readMasterRecord(this.paginatedStorage.getName(), 1);
                if (this.firstMasterRecord == null) {
                    this.useFirstMasterRecord = true;
                    this.lastCheckpoint = this.secondMasterRecord;
                } else if (this.secondMasterRecord == null) {
                    this.useFirstMasterRecord = false;
                    this.lastCheckpoint = this.firstMasterRecord;
                } else if (this.firstMasterRecord.compareTo(this.secondMasterRecord) >= 0) {
                    this.lastCheckpoint = this.firstMasterRecord;
                    this.useFirstMasterRecord = false;
                } else {
                    this.lastCheckpoint = this.secondMasterRecord;
                    this.useFirstMasterRecord = true;
                }
            }
            this.fixMasterRecords();
        }
        catch (FileNotFoundException e) {
            OLogManager.instance().error((Object)this, "Error during file initialization for storage %s", (Throwable)e, new Object[]{this.paginatedStorage.getName()});
            throw new IllegalStateException("Error during file initialization for storage " + this.paginatedStorage.getName(), e);
        }
    }

    public File getWalLocation() {
        return this.walLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber begin() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            LogSegment first;
            block4: {
                this.checkForClose();
                first = this.logSegments.get(0);
                if (first.filledUpTo() != 0L) break block4;
                return null;
            }
            return first.begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OLogSequenceNumber end() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            int lastIndex = this.logSegments.size() - 1;
            LogSegment last = this.logSegments.get(lastIndex);
            while (true) {
                if (last.filledUpTo != 0L) {
                    return last.end();
                }
                if (--lastIndex < 0) {
                    return null;
                }
                last = this.logSegments.get(lastIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            LogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            last.flush();
        }
    }

    private void fixMasterRecords() throws IOException {
        int index;
        if (this.firstMasterRecord != null) {
            index = this.firstMasterRecord.getSegment() - this.logSegments.get(0).getOrder();
            if (this.logSegments.size() <= index || index < 0) {
                this.firstMasterRecord = null;
            } else {
                LogSegment firstMasterRecordSegment = this.logSegments.get(index);
                if (firstMasterRecordSegment.filledUpTo() <= this.firstMasterRecord.getPosition()) {
                    this.firstMasterRecord = null;
                }
            }
        }
        if (this.secondMasterRecord != null) {
            index = this.secondMasterRecord.getSegment() - this.logSegments.get(0).getOrder();
            if (this.logSegments.size() <= index || index < 0) {
                this.secondMasterRecord = null;
            } else {
                LogSegment secondMasterRecordSegment = this.logSegments.get(index);
                if (secondMasterRecordSegment.filledUpTo() <= this.secondMasterRecord.getPosition()) {
                    this.secondMasterRecord = null;
                }
            }
        }
        if (this.firstMasterRecord != null && this.secondMasterRecord != null) {
            return;
        }
        if (this.firstMasterRecord == null && this.secondMasterRecord == null) {
            this.masterRecordLSNHolder.setLength(0L);
            this.masterRecordLSNHolder.getFD().sync();
            this.lastCheckpoint = null;
        } else {
            if (this.secondMasterRecord == null) {
                this.secondMasterRecord = this.firstMasterRecord;
            } else {
                this.firstMasterRecord = this.secondMasterRecord;
            }
            this.lastCheckpoint = this.firstMasterRecord;
            this.writeMasterRecord(0, this.firstMasterRecord);
            this.writeMasterRecord(1, this.secondMasterRecord);
        }
    }

    private OLogSequenceNumber readMasterRecord(String storageName, int index) throws IOException {
        long position;
        int segment;
        block3: {
            CRC32 crc32 = new CRC32();
            try {
                this.masterRecordLSNHolder.seek(index * 16);
                int firstCRC = this.masterRecordLSNHolder.readInt();
                segment = this.masterRecordLSNHolder.readInt();
                position = this.masterRecordLSNHolder.readLong();
                byte[] serializedLSN = new byte[12];
                OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(segment), serializedLSN, 0);
                OLongSerializer.INSTANCE.serialize(Long.valueOf(position), serializedLSN, 4);
                crc32.update(serializedLSN);
                if (firstCRC == (int)crc32.getValue()) break block3;
                OLogManager.instance().error((Object)this, "Can not restore %d WAL master record for storage %s crc check is failed", new Object[]{index, storageName});
                return null;
            }
            catch (EOFException eofException) {
                OLogManager.instance().warn((Object)this, "Can not restore %d WAL master record for storage %s", new Object[]{index, storageName});
                return null;
            }
        }
        return new OLogSequenceNumber(segment, position);
    }

    private void writeMasterRecord(int index, OLogSequenceNumber masterRecord) throws IOException {
        this.masterRecordLSNHolder.seek(index * 16);
        CRC32 crc32 = new CRC32();
        byte[] serializedLSN = new byte[12];
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(masterRecord.getSegment()), serializedLSN, 0);
        OLongSerializer.INSTANCE.serialize(Long.valueOf(masterRecord.getPosition()), serializedLSN, 4);
        crc32.update(serializedLSN);
        this.masterRecordLSNHolder.writeInt((int)crc32.getValue());
        this.masterRecordLSNHolder.writeInt(masterRecord.getSegment());
        this.masterRecordLSNHolder.writeLong(masterRecord.getPosition());
    }

    private String getSegmentName(int order) {
        return String.valueOf(this.paginatedStorage.getName()) + "." + order + ".wal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber logFuzzyCheckPointStart() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            OFuzzyCheckpointStartRecord record = new OFuzzyCheckpointStartRecord(this.lastCheckpoint);
            this.log(record);
            return record.getLsn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber logFuzzyCheckPointEnd() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            OFuzzyCheckpointEndRecord record = new OFuzzyCheckpointEndRecord();
            this.log(record);
            return record.getLsn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber log(OWALRecord record) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            byte[] serializedForm = OWALRecordsFactory.INSTANCE.toStream(record);
            LogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            long lastSize = last.filledUpTo();
            OLogSequenceNumber lsn = last.logRecord(serializedForm);
            record.setLsn(lsn);
            if (record.isUpdateMasterRecord()) {
                this.lastCheckpoint = lsn;
                if (this.useFirstMasterRecord) {
                    this.firstMasterRecord = lsn;
                    this.writeMasterRecord(0, this.firstMasterRecord);
                    this.useFirstMasterRecord = false;
                } else {
                    this.secondMasterRecord = lsn;
                    this.writeMasterRecord(1, this.secondMasterRecord);
                    this.useFirstMasterRecord = true;
                }
            }
            long sizeDiff = last.filledUpTo() - lastSize;
            this.logSize += sizeDiff;
            if (this.logSize >= this.maxLogSize) {
                LogSegment first = this.logSegments.get(0);
                first.stopFlush(false);
                this.logSize -= first.filledUpTo();
                if (!first.delete(false)) {
                    OLogManager.instance().error((Object)this, "Log segment %s can not be removed from WAL", new Object[]{first.getPath()});
                }
                this.logSegments.remove(0);
                this.fixMasterRecords();
            }
            if (last.filledUpTo() >= this.maxSegmentSize) {
                last.stopFlush(true);
                last = new LogSegment(new File(this.walLocation, this.getSegmentName(last.getOrder() + 1)), this.maxPagesCacheSize);
                last.init();
                last.startFlush();
                this.logSegments.add(last);
            }
            return lsn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.logSize;
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (LogSegment logSegment : this.logSegments) {
                logSegment.close(flush);
            }
            this.masterRecordLSNHolder.close();
        }
    }

    private void checkForClose() {
        if (this.closed) {
            throw new OStorageException("WAL log " + this.walLocation + " has been closed");
        }
    }

    public void delete() throws IOException {
        this.delete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.close(flush);
            for (LogSegment logSegment : this.logSegments) {
                if (logSegment.delete(false)) continue;
                OLogManager.instance().error((Object)this, "Can not delete WAL segment %s for storage %s", new Object[]{logSegment.getPath(), this.paginatedStorage.getName()});
            }
            if (!this.masterRecordFile.delete()) {
                OLogManager.instance().error((Object)this, "Can not delete WAL state file for %s storage", new Object[]{this.paginatedStorage.getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDirtyPages(Set<ODirtyPage> dirtyPages) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            this.log(new ODirtyPagesRecord(dirtyPages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber getLastCheckpoint() {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            return this.lastCheckpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWALRecord read(OLogSequenceNumber lsn) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            byte[] recordEntry;
            block6: {
                int index;
                block5: {
                    this.checkForClose();
                    int segment = lsn.getSegment();
                    index = segment - this.logSegments.get(0).getOrder();
                    if (index >= 0 && index < this.logSegments.size()) break block5;
                    return null;
                }
                LogSegment logSegment = this.logSegments.get(index);
                recordEntry = logSegment.readRecord(lsn);
                if (recordEntry != null) break block6;
                return null;
            }
            OWALRecord record = OWALRecordsFactory.INSTANCE.fromStream(recordEntry);
            record.setLsn(lsn);
            return record;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OLogSequenceNumber next(OLogSequenceNumber lsn) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            LogSegment nextSegment;
            block8: {
                int index;
                block7: {
                    block6: {
                        this.checkForClose();
                        int order = lsn.getSegment();
                        index = order - this.logSegments.get(0).getOrder();
                        if (index < 0) return null;
                        if (index < this.logSegments.size()) break block6;
                        return null;
                    }
                    LogSegment logSegment = this.logSegments.get(index);
                    OLogSequenceNumber nextLSN = logSegment.getNextLSN(lsn);
                    if (nextLSN != null) return nextLSN;
                    if (++index < this.logSegments.size()) break block7;
                    return null;
                }
                nextSegment = this.logSegments.get(index);
                if (nextSegment.filledUpTo() != 0L) break block8;
                return null;
            }
            return nextSegment.begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber getFlushedLSN() {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            return this.flushedLsn;
        }
    }

    private OLogSequenceNumber readFlushedLSN() throws IOException {
        for (int segment = this.logSegments.size() - 1; segment >= 0; --segment) {
            LogSegment logSegment = this.logSegments.get(segment);
            OLogSequenceNumber flushedLSN = logSegment.readFlushedLSN();
            if (flushedLSN == null) {
                continue;
            }
            return flushedLSN;
        }
        return null;
    }

    public static boolean validateName(String name) {
        if (!name.toLowerCase().endsWith(".wal")) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public OLogSequenceNumber logFullCheckpointStart() throws IOException {
        return this.log(new OFullCheckpointStartRecord(this.lastCheckpoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFullCheckpointEnd() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            this.log(new OCheckpointEndRecord());
        }
    }

    private final class LogSegment
    implements Comparable<LogSegment> {
        private final RandomAccessFile rndFile;
        private final File file;
        private long filledUpTo;
        private final int order;
        private final int maxPagesCacheSize;
        private boolean closed;
        private OWALPage currentPage;
        private final ConcurrentLinkedQueue<OWALPage> pagesCache = new ConcurrentLinkedQueue();
        private ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
        private long nextPositionToFlush;
        private long flushId;
        private final ScheduledExecutorService commitExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("WAL Flush Task");
                return thread;
            }
        });
        private OLogSequenceNumber last = null;
        private volatile boolean flushNewData = true;

        private LogSegment(File file, int maxPagesCacheSize) throws IOException {
            this.file = file;
            this.maxPagesCacheSize = maxPagesCacheSize;
            this.order = this.extractOrder(file.getName());
            this.closed = false;
            this.rndFile = new RandomAccessFile(file, "rw");
        }

        public void startFlush() {
            if (OWriteAheadLog.this.commitDelay > 0) {
                this.commitExecutor.scheduleAtFixedRate(new FlushTask(), OWriteAheadLog.this.commitDelay, OWriteAheadLog.this.commitDelay, TimeUnit.MILLISECONDS);
            }
        }

        public void stopFlush(boolean flush) {
            if (flush) {
                this.flush();
            }
            if (!this.commitExecutor.isShutdown()) {
                this.commitExecutor.shutdown();
                try {
                    if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL flush task for " + this.getPath() + " segment can not be stopped.");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error((Object)this, "Can not shutdown background WAL commit thread.", new Object[0]);
                }
            }
        }

        public int getOrder() {
            return this.order;
        }

        public void init() throws IOException {
            this.selfCheck();
            this.initPageCache();
            this.initLastPage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initLastPage() throws IOException {
            RandomAccessFile randomAccessFile = this.rndFile;
            synchronized (randomAccessFile) {
                long pagesCount = this.rndFile.length() / 65536L;
                long currentPage = pagesCount - 1L;
                if (currentPage < 0L) {
                    return;
                }
                do {
                    this.rndFile.seek(currentPage * 65536L);
                    byte[] content = new byte[65536];
                    this.rndFile.readFully(content);
                    long pointer = this.directMemory.allocate(content);
                    try {
                        OWALPage page = new OWALPage(pointer, false);
                        int lastPosition = this.findLastRecord(page, true);
                        if (lastPosition > -1) {
                            this.last = new OLogSequenceNumber(this.order, currentPage * 65536L + (long)lastPosition);
                            return;
                        }
                    }
                    finally {
                        this.directMemory.free(pointer);
                    }
                } while (--currentPage >= 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initPageCache() throws IOException {
            RandomAccessFile randomAccessFile = this.rndFile;
            synchronized (randomAccessFile) {
                long pagesCount = this.rndFile.length() / 65536L;
                if (pagesCount == 0L) {
                    return;
                }
                this.rndFile.seek((pagesCount - 1L) * 65536L);
                byte[] content = new byte[65536];
                this.rndFile.readFully(content);
                this.flushId = OLongSerializer.INSTANCE.deserializeNative(content, 4);
                long pointer = this.directMemory.allocate(content);
                this.currentPage = new OWALPage(pointer, false);
                this.filledUpTo = (pagesCount - 1L) * 65536L + (long)this.currentPage.getFilledUpTo();
                this.nextPositionToFlush = (pagesCount - 1L) * 65536L;
                this.pagesCache.add(this.currentPage);
            }
        }

        private int extractOrder(String name) {
            int walOrderStartIndex = name.indexOf(46) + 1;
            int walOrderEndIndex = name.indexOf(46, walOrderStartIndex);
            String walOrder = name.substring(walOrderStartIndex, walOrderEndIndex);
            try {
                return Integer.parseInt(walOrder);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int compareTo(LogSegment other) {
            int otherOrder = other.order;
            if (this.order > otherOrder) {
                return 1;
            }
            if (this.order < otherOrder) {
                return -1;
            }
            return 0;
        }

        public long filledUpTo() throws IOException {
            return this.filledUpTo;
        }

        public OLogSequenceNumber begin() throws IOException {
            if (!this.pagesCache.isEmpty()) {
                return new OLogSequenceNumber(this.order, 20L);
            }
            if (this.rndFile.length() > 0L) {
                return new OLogSequenceNumber(this.order, 20L);
            }
            return null;
        }

        public OLogSequenceNumber end() {
            return this.last;
        }

        private int findLastRecord(OWALPage page, boolean skipTailRecords) {
            int prevOffset = 20;
            int pageOffset = 20;
            int maxOffset = page.getFilledUpTo();
            while (pageOffset < maxOffset) {
                prevOffset = pageOffset;
                pageOffset += page.getSerializedRecordSize(pageOffset);
            }
            if (skipTailRecords && page.recordTail(prevOffset)) {
                return -1;
            }
            return prevOffset;
        }

        public boolean delete(boolean flush) throws IOException {
            this.close(flush);
            return this.file.delete();
        }

        public String getPath() {
            return this.file.getAbsolutePath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OLogSequenceNumber logRecord(byte[] record) throws IOException {
            this.flushNewData = true;
            int pageOffset = (int)(this.filledUpTo % 65536L);
            long pageIndex = this.filledUpTo / 65536L;
            if (pageOffset == 0 && pageIndex > 0L) {
                --pageIndex;
            }
            int pos = 0;
            boolean firstChunk = true;
            OLogSequenceNumber lsn = null;
            while (pos < record.length) {
                OWALPage walPage;
                int freeSpace;
                if (this.currentPage == null) {
                    long pointer = this.directMemory.allocate(65536L);
                    this.currentPage = new OWALPage(pointer, true);
                    this.pagesCache.add(this.currentPage);
                    this.filledUpTo += 20L;
                }
                if ((freeSpace = this.currentPage.getFreeSpace()) < 7) {
                    this.filledUpTo += (long)(freeSpace + 20);
                    long pointer = this.directMemory.allocate(65536L);
                    this.currentPage = new OWALPage(pointer, true);
                    this.pagesCache.add(this.currentPage);
                    ++pageIndex;
                    freeSpace = this.currentPage.getFreeSpace();
                }
                OWALPage oWALPage = walPage = this.currentPage;
                synchronized (oWALPage) {
                    int addedChunkOffset;
                    int entrySize = OWALPage.calculateSerializedSize(record.length - pos);
                    if (entrySize <= freeSpace) {
                        addedChunkOffset = pos == 0 ? walPage.appendRecord(record, false, !firstChunk) : walPage.appendRecord(Arrays.copyOfRange(record, pos, record.length), false, !firstChunk);
                        pos = record.length;
                    } else {
                        int chunkSize = OWALPage.calculateRecordSize(freeSpace);
                        if (chunkSize > record.length - pos) {
                            chunkSize = record.length - pos;
                        }
                        addedChunkOffset = walPage.appendRecord(Arrays.copyOfRange(record, pos, pos + chunkSize), true, !firstChunk);
                        pos += chunkSize;
                    }
                    if (firstChunk) {
                        lsn = new OLogSequenceNumber(this.order, pageIndex * 65536L + (long)addedChunkOffset);
                    }
                    int spaceDiff = freeSpace - walPage.getFreeSpace();
                    this.filledUpTo += (long)spaceDiff;
                    firstChunk = false;
                }
            }
            if (this.pagesCache.size() > this.maxPagesCacheSize) {
                OLogManager.instance().info((Object)this, "Max cache limit is reached (%d vs. %d), sync flush is performed.", new Object[]{this.maxPagesCacheSize, this.pagesCache.size()});
                this.flush();
            }
            this.last = lsn;
            return this.last;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readRecord(OLogSequenceNumber lsn) throws IOException {
            assert (lsn.getSegment() == this.order);
            if (lsn.getPosition() >= this.filledUpTo) {
                return null;
            }
            if (OWriteAheadLog.this.flushedLsn == null || OWriteAheadLog.this.flushedLsn.compareTo(lsn) < 0) {
                this.flush();
            }
            byte[] record = null;
            int pageOffset = (int)(lsn.getPosition() % 65536L);
            long pageCount = (this.filledUpTo + 65536L - 1L) / 65536L;
            for (long pageIndex = lsn.getPosition() / 65536L; pageIndex < pageCount; ++pageIndex) {
                RandomAccessFile randomAccessFile = this.rndFile;
                synchronized (randomAccessFile) {
                    block13: {
                        byte[] pageContent = new byte[65536];
                        this.rndFile.seek(pageIndex * 65536L);
                        this.rndFile.readFully(pageContent);
                        long pointer = this.directMemory.allocate(pageContent);
                        try {
                            OWALPage page = new OWALPage(pointer, false);
                            byte[] content = page.getRecord(pageOffset);
                            if (record == null) {
                                record = content;
                            } else {
                                byte[] oldRecord = record;
                                record = new byte[record.length + content.length];
                                System.arraycopy(oldRecord, 0, record, 0, oldRecord.length);
                                System.arraycopy(content, 0, record, oldRecord.length, record.length - oldRecord.length);
                            }
                            if (page.mergeWithNextPage(pageOffset)) {
                                pageOffset = 20;
                                break block13;
                            }
                            break;
                        }
                        finally {
                            this.directMemory.free(pointer);
                        }
                    }
                    continue;
                }
            }
            return record;
        }

        public OLogSequenceNumber getNextLSN(OLogSequenceNumber lsn) throws IOException {
            byte[] record = this.readRecord(lsn);
            if (record == null) {
                return null;
            }
            long pos = lsn.getPosition();
            long pageIndex = pos / 65536L;
            int pageOffset = (int)(pos - pageIndex * 65536L);
            int restOfRecord = record.length;
            while (restOfRecord > 0) {
                int entrySize = OWALPage.calculateSerializedSize(restOfRecord);
                if (entrySize + pageOffset < 65536) {
                    if (entrySize + pageOffset <= 65529) {
                        pos += (long)entrySize;
                        break;
                    }
                    pos += (long)(65536 - pageOffset + 20);
                    break;
                }
                if (entrySize + pageOffset == 65536) {
                    pos += (long)(entrySize + 20);
                    break;
                }
                int chunkSize = OWALPage.calculateRecordSize(65536 - pageOffset);
                restOfRecord -= chunkSize;
                pos += (long)(65536 - pageOffset + 20);
                pageOffset = 20;
            }
            if (pos >= this.filledUpTo) {
                return null;
            }
            return new OLogSequenceNumber(this.order, pos);
        }

        public void close(boolean flush) throws IOException {
            if (!this.closed) {
                this.stopFlush(flush);
                this.rndFile.close();
                this.closed = true;
                if (!this.pagesCache.isEmpty()) {
                    for (OWALPage page : this.pagesCache) {
                        this.directMemory.free(page.getPagePointer());
                    }
                }
                this.currentPage = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selfCheck() throws IOException {
            if (!this.pagesCache.isEmpty()) {
                throw new IllegalStateException("WAL cache is not empty, we can not verify WAL after it was started to be used");
            }
            RandomAccessFile randomAccessFile = this.rndFile;
            synchronized (randomAccessFile) {
                long intialFlushId;
                byte[] content;
                long pagesCount = this.rndFile.length() / 65536L;
                if (this.rndFile.length() % 65536L > 0L) {
                    OLogManager.instance().error((Object)this, "Last WAL page was written partially, auto fix.", new Object[0]);
                    this.rndFile.setLength(65536L * pagesCount);
                }
                long currentPage = pagesCount - 1L;
                CRC32 crc32 = new CRC32();
                while (currentPage >= 0L) {
                    crc32.reset();
                    content = new byte[65536];
                    this.rndFile.seek(currentPage * 65536L);
                    this.rndFile.readFully(content);
                    int pageCRC = OIntegerSerializer.INSTANCE.deserializeNative(content, 0);
                    crc32.update(content, 4, 65532);
                    int calculatedCRC = (int)crc32.getValue();
                    if (pageCRC == calculatedCRC) break;
                    OLogManager.instance().error((Object)this, "%d WAL page has been broken and will be truncated.", new Object[]{currentPage});
                    pagesCount = --currentPage + 1L;
                    this.rndFile.setLength(pagesCount * 65536L);
                }
                if (currentPage < 0L) {
                    return;
                }
                content = new byte[65536];
                this.rndFile.seek(currentPage * 65536L);
                this.rndFile.readFully(content);
                --currentPage;
                long loadedFlushId = intialFlushId = OLongSerializer.INSTANCE.deserializeNative(content, 4).longValue();
                int flushedPagesCount = 1;
                while (currentPage >= 0L) {
                    content = new byte[65536];
                    this.rndFile.seek(currentPage * 65536L);
                    this.rndFile.readFully(content);
                    crc32.reset();
                    crc32.update(content, 4, 65532);
                    int calculatedCRC = (int)crc32.getValue();
                    int pageCRC = OIntegerSerializer.INSTANCE.deserializeNative(content, 0);
                    if (pageCRC != calculatedCRC) {
                        OLogManager.instance().error((Object)this, "%d WAL page has been broken and will be truncated.", new Object[]{currentPage});
                        pagesCount = --currentPage + 1L;
                        this.rndFile.setLength(pagesCount * 65536L);
                        flushedPagesCount = 0;
                        continue;
                    }
                    loadedFlushId = OLongSerializer.INSTANCE.deserializeNative(content, 4);
                    if (loadedFlushId != intialFlushId) break;
                    ++flushedPagesCount;
                    --currentPage;
                }
                if (flushedPagesCount != 0) {
                    content = new byte[65536];
                    this.rndFile.seek((currentPage + 1L) * 65536L);
                    this.rndFile.readFully(content);
                    int firstFlushIndex = OIntegerSerializer.INSTANCE.deserializeNative(content, 12);
                    if (firstFlushIndex != 0) {
                        OLogManager.instance().error((Object)this, "%d WAL page has been broken and will be truncated.", new Object[]{currentPage + 1L});
                        pagesCount = currentPage + 1L;
                        this.rndFile.setLength(pagesCount * 65536L);
                        flushedPagesCount = 0;
                    }
                }
                currentPage += (long)flushedPagesCount;
                while (currentPage >= 0L) {
                    this.rndFile.seek(currentPage * 65536L);
                    this.rndFile.readFully(content);
                    long pointer = this.directMemory.allocate(content);
                    try {
                        OWALPage page = new OWALPage(pointer, false);
                        int pageOffset = this.findLastRecord(page, false);
                        if (pageOffset < 0 || !page.mergeWithNextPage(pageOffset)) break;
                        page.truncateTill(pageOffset);
                        this.rndFile.seek(currentPage * 65536L);
                        content = this.directMemory.get(pointer, 65536);
                        this.rndFile.write(content);
                        if (!page.isEmpty()) break;
                        OLogManager.instance().error((Object)this, "%d WAL page has been broken and will be truncated.", new Object[]{currentPage});
                        pagesCount = --currentPage + 1L;
                        this.rndFile.setLength(pagesCount * 65536L);
                    }
                    finally {
                        this.directMemory.free(pointer);
                    }
                }
                this.rndFile.getFD().sync();
            }
        }

        public OLogSequenceNumber readFlushedLSN() throws IOException {
            long pages = this.rndFile.length() / 65536L;
            if (pages == 0L) {
                return null;
            }
            long pageIndex = pages - 1L;
            while (true) {
                this.rndFile.seek(pageIndex * 65536L);
                byte[] pageContent = new byte[65536];
                this.rndFile.readFully(pageContent);
                long pointer = this.directMemory.allocate(pageContent);
                try {
                    OWALPage page = new OWALPage(pointer, false);
                    int pageOffset = this.findLastRecord(page, true);
                    if (pageOffset < 0) {
                        if (--pageIndex >= 0L) continue;
                        return null;
                    }
                    OLogSequenceNumber oLogSequenceNumber = new OLogSequenceNumber(this.order, pageIndex * 65536L + (long)pageOffset);
                    return oLogSequenceNumber;
                }
                finally {
                    this.directMemory.free(pointer);
                    continue;
                }
                break;
            }
        }

        public void flush() {
            if (!this.commitExecutor.isShutdown()) {
                try {
                    this.commitExecutor.submit(new FlushTask()).get();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw new OStorageException("Thread was interrupted during flush", e);
                }
                catch (ExecutionException e) {
                    throw new OStorageException("Error during WAL segment " + this.getPath() + " flush.");
                }
            } else {
                new FlushTask().run();
            }
        }

        private final class FlushTask
        implements Runnable {
            private FlushTask() {
            }

            @Override
            public void run() {
                try {
                    this.commit();
                }
                catch (Throwable e) {
                    OLogManager.instance().error((Object)this, "Error during WAL background flush", e, new Object[0]);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void commit() throws IOException {
                long dataPointer;
                Object page;
                if (LogSegment.this.pagesCache.isEmpty()) {
                    return;
                }
                if (!LogSegment.this.flushNewData) {
                    return;
                }
                LogSegment.this.flushNewData = false;
                int maxSize = LogSegment.this.pagesCache.size();
                long[] pagesToFlush = new long[maxSize];
                long filePointer = LogSegment.this.nextPositionToFlush;
                int lastRecordOffset = -1;
                long lastPageIndex = -1L;
                int flushedPages = 0;
                Iterator pageIterator = LogSegment.this.pagesCache.iterator();
                while (flushedPages < maxSize) {
                    page = (OWALPage)pageIterator.next();
                    OWALPage oWALPage = page;
                    synchronized (oWALPage) {
                        if (flushedPages == maxSize - 1) {
                            dataPointer = LogSegment.this.directMemory.allocate(65536L);
                            LogSegment.this.directMemory.copyData(((OWALPage)page).getPagePointer(), dataPointer, 65536L);
                        } else {
                            dataPointer = ((OWALPage)page).getPagePointer();
                        }
                        pagesToFlush[flushedPages] = dataPointer;
                        int recordOffset = LogSegment.this.findLastRecord((OWALPage)page, true);
                        if (recordOffset >= 0) {
                            lastRecordOffset = recordOffset;
                            lastPageIndex = flushedPages;
                        }
                    }
                    ++flushedPages;
                }
                LogSegment logSegment = LogSegment.this;
                logSegment.flushId = logSegment.flushId + 1L;
                page = LogSegment.this.rndFile;
                synchronized (page) {
                    LogSegment.this.rndFile.seek(filePointer);
                    int i = 0;
                    while (i < pagesToFlush.length) {
                        dataPointer = pagesToFlush[i];
                        byte[] pageContent = LogSegment.this.directMemory.get(dataPointer, 65536);
                        if (i == pagesToFlush.length - 1) {
                            LogSegment.this.directMemory.free(dataPointer);
                        }
                        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(LogSegment.this.flushId), pageContent, 4);
                        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(i), pageContent, 12);
                        this.flushPage(pageContent);
                        filePointer += 65536L;
                        ++i;
                    }
                    LogSegment.this.rndFile.getFD().sync();
                }
                long oldPositionToFlush = LogSegment.this.nextPositionToFlush;
                LogSegment.this.nextPositionToFlush = filePointer - 65536L;
                if (lastRecordOffset >= 0) {
                    OWriteAheadLog.this.flushedLsn = new OLogSequenceNumber(LogSegment.this.order, oldPositionToFlush + lastPageIndex * 65536L + (long)lastRecordOffset);
                }
                int i = 0;
                while (i < flushedPages - 1) {
                    OWALPage page2 = (OWALPage)LogSegment.this.pagesCache.poll();
                    LogSegment.this.directMemory.free(page2.getPagePointer());
                    ++i;
                }
                assert (!LogSegment.this.pagesCache.isEmpty());
            }

            private void flushPage(byte[] content) throws IOException {
                CRC32 crc32 = new CRC32();
                crc32.update(content, 4, 65532);
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf((int)crc32.getValue()), content, 0);
                LogSegment.this.rndFile.write(content);
            }
        }
    }
}

