/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;

public class OWALPage {
    public static final int PAGE_SIZE = 65536;
    public static final int MIN_RECORD_SIZE = 7;
    public static final int CRC_OFFSET = 0;
    public static final int FLUSH_ID_OFFSET = 4;
    public static final int FLUSH_INDEX_OFFSET = 12;
    private static final int FREE_SPACE_OFFSET = 16;
    public static final int RECORDS_OFFSET = 20;
    private static final int MAX_ENTRY_SIZE = 65516;
    private final long pagePointer;
    private final ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();

    public OWALPage(long pagePointer, boolean isNew) {
        this.pagePointer = pagePointer;
        if (isNew) {
            OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(65516), this.directMemory, pagePointer + 16L);
        }
    }

    public long getPagePointer() {
        return this.pagePointer;
    }

    public int appendRecord(byte[] content, boolean mergeWithNextPage, boolean recordTail) {
        int freePosition;
        int freeSpace = this.getFreeSpace();
        int position = freePosition = 65536 - freeSpace;
        this.directMemory.setByte(this.pagePointer + (long)position, mergeWithNextPage ? (byte)1 : 0);
        this.directMemory.setByte(this.pagePointer + (long)(++position), recordTail ? (byte)1 : 0);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(content.length), this.directMemory, this.pagePointer + (long)(++position));
        this.directMemory.set(this.pagePointer + (long)(position += 4), content, 0, content.length);
        position += content.length;
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(freeSpace - 2 - 4 - content.length), this.directMemory, this.pagePointer + 16L);
        return freePosition;
    }

    public byte[] getRecord(int position) {
        int recordSize = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + (long)(position += 2));
        return this.directMemory.get(this.pagePointer + (long)(position += 4), recordSize);
    }

    public int getSerializedRecordSize(int position) {
        int recordSize = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + (long)position + 2L);
        return recordSize + 4 + 2;
    }

    public boolean mergeWithNextPage(int position) {
        return this.directMemory.getByte(this.pagePointer + (long)position) > 0;
    }

    public boolean recordTail(int position) {
        return this.directMemory.getByte(this.pagePointer + (long)position + 1L) > 0;
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == 65516;
    }

    public int getFreeSpace() {
        return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + 16L);
    }

    public int getFilledUpTo() {
        return 65536 - this.getFreeSpace();
    }

    public static int calculateSerializedSize(int recordSize) {
        return recordSize + 4 + 2;
    }

    public static int calculateRecordSize(int serializedSize) {
        return serializedSize - 4 - 2;
    }

    public void truncateTill(int pageOffset) {
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(65536 - pageOffset), this.directMemory, this.pagePointer + 16L);
    }
}

