/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OClusterAwareWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;

public class OFreePageChangeRecord
extends OOperationUnitRecord
implements OClusterAwareWALRecord {
    private OLogSequenceNumber lsn;
    private int clusterId;
    private int freePageIndex;
    private long prevPageIndex;
    private long pageIndex;

    public OFreePageChangeRecord() {
    }

    public OFreePageChangeRecord(OOperationUnitId operationUnitId, int clusterId, int freePageIndex, long prevPageIndex, long pageIndex) {
        super(operationUnitId);
        this.clusterId = clusterId;
        this.freePageIndex = freePageIndex;
        this.prevPageIndex = prevPageIndex;
        this.pageIndex = pageIndex;
    }

    public int getFreePageIndex() {
        return this.freePageIndex;
    }

    public long getPrevPageIndex() {
        return this.prevPageIndex;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.clusterId), content, offset);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.freePageIndex), content, offset += 4);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.prevPageIndex), content, offset += 4);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.pageIndex), content, offset += 8);
        return offset += 8;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.clusterId = OIntegerSerializer.INSTANCE.deserializeNative(content, offset);
        this.freePageIndex = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += 4);
        this.prevPageIndex = OLongSerializer.INSTANCE.deserializeNative(content, offset += 4);
        this.pageIndex = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        return offset += 8;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 16;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OFreePageChangeRecord that = (OFreePageChangeRecord)o;
        if (this.clusterId != that.clusterId) {
            return false;
        }
        if (this.freePageIndex != that.freePageIndex) {
            return false;
        }
        if (this.pageIndex != that.pageIndex) {
            return false;
        }
        return this.prevPageIndex == that.prevPageIndex;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clusterId;
        result = 31 * result + this.freePageIndex;
        result = 31 * result + (int)(this.prevPageIndex ^ this.prevPageIndex >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "OFreePageChangeRecord{lsn=" + this.lsn + ", clusterId=" + this.clusterId + ", freePageIndex=" + this.freePageIndex + ", prevPageIndex=" + this.prevPageIndex + ", pageIndex=" + this.pageIndex + "} " + super.toString();
    }
}

