/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import java.util.HashSet;
import java.util.Set;

public class ODirtyPagesRecord
implements OWALRecord {
    private OLogSequenceNumber lsn;
    private Set<ODirtyPage> dirtyPages;

    public ODirtyPagesRecord() {
    }

    public ODirtyPagesRecord(Set<ODirtyPage> dirtyPages) {
        this.dirtyPages = dirtyPages;
    }

    public Set<ODirtyPage> getDirtyPages() {
        return this.dirtyPages;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.dirtyPages.size()), content, offset);
        offset += 4;
        for (ODirtyPage dirtyPage : this.dirtyPages) {
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(dirtyPage.getPageIndex()), content, offset);
            OStringSerializer.INSTANCE.serializeNative(dirtyPage.getFileName(), content, offset += 8);
            OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(dirtyPage.getLsn().getSegment()), content, offset += OStringSerializer.INSTANCE.getObjectSize(dirtyPage.getFileName()));
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(dirtyPage.getLsn().getPosition()), content, offset += 4);
            offset += 8;
        }
        return offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        int size = OIntegerSerializer.INSTANCE.deserializeNative(content, offset);
        offset += 4;
        this.dirtyPages = new HashSet<ODirtyPage>();
        for (int i = 0; i < size; ++i) {
            long pageIndex = OLongSerializer.INSTANCE.deserializeNative(content, offset);
            String fileName = OStringSerializer.INSTANCE.deserializeNative(content, offset += 8);
            int segment = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += OStringSerializer.INSTANCE.getObjectSize(fileName));
            long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 4);
            offset += 8;
            this.dirtyPages.add(new ODirtyPage(fileName, pageIndex, new OLogSequenceNumber(segment, position)));
        }
        return offset;
    }

    @Override
    public int serializedSize() {
        int size = 4;
        for (ODirtyPage dirtyPage : this.dirtyPages) {
            size += 20;
            size += OStringSerializer.INSTANCE.getObjectSize(dirtyPage.getFileName());
        }
        return size;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODirtyPagesRecord that = (ODirtyPagesRecord)o;
        return this.dirtyPages.equals(that.dirtyPages);
    }

    public int hashCode() {
        return this.dirtyPages.hashCode();
    }

    public String toString() {
        return "ODirtyPagesRecord{lsn=" + this.lsn + ", dirtyPages=" + this.dirtyPages + '}';
    }
}

