/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;

public class OAtomicUnitEndRecord
extends OOperationUnitRecord {
    private OLogSequenceNumber lsn;
    private boolean rollback;

    public OAtomicUnitEndRecord() {
    }

    public OAtomicUnitEndRecord(OOperationUnitId operationUnitId, boolean rollback) {
        super(operationUnitId);
        this.rollback = rollback;
        assert (operationUnitId != null);
    }

    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        content[offset] = this.rollback ? (byte)1 : 0;
        return ++offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        this.rollback = content[offset = super.fromStream(content, offset)] > 0;
        return offset;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    @Override
    public String toString() {
        return "OAtomicUnitEndRecord{lsn=" + this.lsn + "} " + super.toString();
    }
}

