/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OClusterAwareWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;

public abstract class OAbstractPageWALRecord
extends OOperationUnitRecord
implements OClusterAwareWALRecord {
    private OLogSequenceNumber lsn;
    private long pageIndex;
    private int clusterId;

    protected OAbstractPageWALRecord() {
    }

    protected OAbstractPageWALRecord(long pageIndex, int clusterId, OOperationUnitId operationUnitId) {
        super(operationUnitId);
        this.pageIndex = pageIndex;
        this.clusterId = clusterId;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.pageIndex), content, offset);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.clusterId), content, offset += 8);
        return offset += 4;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.pageIndex = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        this.clusterId = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += 8);
        return offset += 4;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 4;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAbstractPageWALRecord that = (OAbstractPageWALRecord)o;
        if (this.clusterId != that.clusterId) {
            return false;
        }
        return this.pageIndex == that.pageIndex;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        result = 31 * result + this.clusterId;
        return result;
    }

    @Override
    public String toString() {
        return "OAbstractPageWALRecord{lsn=" + this.lsn + ", pageIndex=" + this.pageIndex + ", clusterId=" + this.clusterId + "} " + super.toString();
    }
}

