/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;

public abstract class OAbstractCheckPointStartRecord
implements OWALRecord {
    private OLogSequenceNumber previousCheckpoint;

    protected OAbstractCheckPointStartRecord() {
    }

    protected OAbstractCheckPointStartRecord(OLogSequenceNumber previousCheckpoint) {
        this.previousCheckpoint = previousCheckpoint;
    }

    public OLogSequenceNumber getPreviousCheckpoint() {
        return this.previousCheckpoint;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        if (this.previousCheckpoint == null) {
            content[offset] = 0;
            return ++offset;
        }
        content[offset] = 1;
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.previousCheckpoint.getSegment()), content, ++offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.previousCheckpoint.getPosition()), content, offset += 4);
        return offset += 8;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        if (content[offset] == 0) {
            return ++offset;
        }
        int segment = OIntegerSerializer.INSTANCE.deserializeNative(content, ++offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 4);
        this.previousCheckpoint = new OLogSequenceNumber(segment, position);
        return offset += 8;
    }

    @Override
    public int serializedSize() {
        if (this.previousCheckpoint == null) {
            return 1;
        }
        return 13;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAbstractCheckPointStartRecord that = (OAbstractCheckPointStartRecord)o;
        return !(this.previousCheckpoint != null ? !this.previousCheckpoint.equals(that.previousCheckpoint) : that.previousCheckpoint != null);
    }

    public int hashCode() {
        return this.previousCheckpoint != null ? this.previousCheckpoint.hashCode() : 0;
    }

    public String toString() {
        return "OAbstractCheckPointStartRecord{previousCheckpoint=" + this.previousCheckpoint + '}';
    }
}

