/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStorageEHClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfigurationLocal;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.O2QCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerLocator;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalTxExecuter;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterLocalEH;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class OStorageLocal
extends OStorageLocalAbstract {
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final Map<String, OCluster> clusterMap = new LinkedHashMap<String, OCluster>();
    private OCluster[] clusters = new OCluster[0];
    private ODataLocal[] dataSegments = new ODataLocal[0];
    private final OStorageLocalTxExecuter txManager;
    private String storagePath;
    private final OStorageVariableParser variableParser;
    private int defaultClusterId = -1;
    private static String[] ALL_FILE_EXTENSIONS = new String[]{"ocf", ".och", ".ocl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".hib", ".him", ".hit"};
    private long positionGenerator = 1L;
    private OModificationLock modificationLock = new OModificationLock();
    private final Set<String> clustersToSyncImmediately = new HashSet<String>();
    private final ODiskCache diskCache;

    public OStorageLocal(String iName, String iFilePath, String iMode) throws IOException {
        super(iName, iFilePath, iMode);
        File f = new File(this.url);
        this.storagePath = f.exists() || !this.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getParent()));
        this.storagePath = OIOUtils.getPathFromDatabaseName((String)this.storagePath);
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.txManager = new OStorageLocalTxExecuter(this, this.configuration.txSegment);
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        String[] clustersToSync = OGlobalConfiguration.NON_TX_CLUSTERS_SYNC_IMMEDIATELY.getValueAsString().trim().split("\\s*,\\s*");
        this.clustersToSyncImmediately.addAll(Arrays.asList(clustersToSync));
        this.installProfilerHooks();
        ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
        this.diskCache = directMemory != null ? new O2QCache(OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L, OGlobalConfiguration.DISK_CACHE_WRITE_QUEUE_LENGTH.getValueAsInteger(), directMemory, null, OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, this, false) : null;
    }

    @Override
    public synchronized void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            this.addUser();
            if (this.status != OStorage.STATUS.CLOSED) {
                return;
            }
            try {
                if (!this.exists()) {
                    throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
                }
                this.status = OStorage.STATUS.OPEN;
                int pos = this.registerDataSegment(new OStorageDataConfiguration(this.configuration, "default", 0, this.getStoragePath()));
                this.dataSegments[pos].open();
                if (OGlobalConfiguration.USE_LHPEPS_CLUSTER.getValueAsBoolean()) {
                    this.addEHDefaultClusters();
                } else {
                    this.addDefaultClusters();
                }
                int i = 0;
                while (i < this.configuration.dataSegments.size()) {
                    OStorageDataConfiguration dataConfig = this.configuration.dataSegments.get(i);
                    if (dataConfig != null) {
                        pos = this.registerDataSegment(dataConfig);
                        if (pos == -1) {
                            this.dataSegments[i].close();
                            this.dataSegments[i] = new ODataLocal(this, dataConfig, i);
                            this.dataSegments[i].open();
                        } else {
                            this.dataSegments[pos].open();
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < this.configuration.clusters.size()) {
                    block22: {
                        OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                        if (clusterConfig != null) {
                            pos = this.createClusterFromConfig(clusterConfig);
                            try {
                                if (pos == -1) {
                                    if (this.clusters[i] != null && this.clusters[i] instanceof OClusterLocal) {
                                        this.clusters[i].close();
                                    }
                                    this.clusters[i] = Orient.instance().getClusterFactory().createCluster("PHYSICAL", this.clusters[i] instanceof OClusterLocal);
                                    this.clusters[i].configure(this, clusterConfig);
                                    this.clusterMap.put(this.clusters[i].getName(), this.clusters[i]);
                                    this.clusters[i].open();
                                    break block22;
                                }
                                if (clusterConfig.getName().equals("default")) {
                                    this.defaultClusterId = pos;
                                }
                                this.clusters[pos].open();
                            }
                            catch (FileNotFoundException e) {
                                OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters[i].getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", new Object[0]);
                                this.clusterMap.remove(this.clusters[i].getName());
                                this.clusters[i] = null;
                            }
                        } else {
                            this.clusters = Arrays.copyOf(this.clusters, this.clusters.length + 1);
                            this.clusters[i] = null;
                        }
                    }
                    ++i;
                }
                this.txManager.open();
            }
            catch (Exception e) {
                this.close(true);
                throw new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode, e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".open", "Open a local database", timer, "db.*.open");
        }
    }

    @Override
    public ODiskCache getDiskCache() {
        return this.diskCache;
    }

    private void addDefaultClusters() throws IOException {
        this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "internal"));
        this.configuration.load();
        this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "index"));
        this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "manindex"));
        this.defaultClusterId = this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "default"));
    }

    private void addEHDefaultClusters() throws IOException {
        this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "internal"));
        this.configuration.load();
        this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "index"));
        this.createClusterFromConfig(new OStoragePhysicalClusterConfigurationLocal(this.configuration, this.clusters.length, 0, "manindex"));
        this.defaultClusterId = this.createClusterFromConfig(new OStorageEHClusterConfiguration(this.configuration, this.clusters.length, "default", null, 0));
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                if (this.status != OStorage.STATUS.CLOSED) {
                    throw new OStorageException("Cannot create new storage '" + this.name + "' because it is not closed (status:" + (Object)((Object)this.status) + ")");
                }
                this.addUser();
                File storageFolder = new File(this.storagePath);
                if (!storageFolder.exists()) {
                    storageFolder.mkdir();
                }
                if (this.exists()) {
                    throw new OStorageException("Cannot create new storage '" + this.name + "' because it already exists");
                }
                this.status = OStorage.STATUS.OPEN;
                this.addDataSegment("default");
                this.addDataSegment("index");
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "internal", null, null, true, new Object[0]);
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "index", null, "index", true, new Object[0]);
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "manindex", null, null, true, new Object[0]);
                this.defaultClusterId = this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "default", null, null, false, new Object[0]);
                this.configuration.create();
                this.txManager.create();
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage '" + this.name + "'", e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".create", "Create a local database", timer, "db.*.create");
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean exists() {
        return this.exists(this.storagePath);
    }

    private boolean exists(String path) {
        return new File(String.valueOf(path) + "/" + "default" + ".0" + ".oda").exists();
    }

    @Override
    public void close(boolean iForce) {
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (!this.checkForClose(iForce)) {
                return;
            }
            try {
                this.status = OStorage.STATUS.CLOSING;
                Object[] objectArray = this.clusters;
                int n = this.clusters.length;
                int n2 = 0;
                while (n2 < n) {
                    OCluster cluster = objectArray[n2];
                    if (cluster != null) {
                        cluster.close();
                    }
                    ++n2;
                }
                this.clusters = new OCluster[0];
                this.clusterMap.clear();
                objectArray = this.dataSegments;
                n = this.dataSegments.length;
                n2 = 0;
                while (n2 < n) {
                    Object data = objectArray[n2];
                    if (data != null) {
                        ((ODataLocal)data).close();
                    }
                    ++n2;
                }
                this.dataSegments = new ODataLocal[0];
                this.txManager.close();
                if (this.configuration != null) {
                    this.configuration.close();
                }
                this.level2Cache.shutdown();
                OMMapManagerLocator.getInstance().flush();
                super.close(iForce);
                this.uninstallProfilerHooks();
                if (this.diskCache != null) {
                    this.diskCache.close();
                }
                Orient.instance().unregisterStorage(this);
                this.status = OStorage.STATUS.CLOSED;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)e, OStorageException.class, new Object[0]);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a local database", timer, "db.*.close");
        }
    }

    @Override
    public void delete() {
        if (this.status != OStorage.STATUS.CLOSED && this.getUsers() > 0) {
            while (this.removeUser() > 0) {
            }
        }
        this.close(true);
        try {
            Orient.instance().unregisterStorage(this);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Cannot unregister storage", (Throwable)e, new Object[0]);
        }
        long timer = Orient.instance().getProfiler().startChrono();
        File dbDir = new File(OIOUtils.getPathFromDatabaseName((String)OSystemVariableResolver.resolveSystemVariables((String)this.url)));
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            dbDir = dbDir.getParentFile();
        }
        this.lock.acquireExclusiveLock();
        try {
            int i = 0;
            while (i < this.DELETE_MAX_RETRIES) {
                if (dbDir.exists() && dbDir.isDirectory()) {
                    int notDeletedFiles = 0;
                    File[] files = dbDir.listFiles();
                    if (files != null) {
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            String[] stringArray = ALL_FILE_EXTENSIONS;
                            int n3 = ALL_FILE_EXTENSIONS.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String ext = stringArray[n4];
                                if (f.getPath().endsWith(ext)) {
                                    if (f.delete()) break;
                                    ++notDeletedFiles;
                                    break;
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    if (notDeletedFiles == 0) {
                        dbDir.delete();
                        return;
                    }
                } else {
                    return;
                }
                OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", new Object[]{this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES});
                OMemoryWatchDog.freeMemoryForResourceCleanup(this.DELETE_WAIT_TIME);
                ++i;
            }
            throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".drop", "Drop a local database", timer, "db.*.drop");
        }
    }

    @Override
    public boolean check(boolean iVerbose, OCommandOutputListener iListener) {
        int errors = 0;
        int warnings = 0;
        this.lock.acquireSharedLock();
        try {
            long totalRecors = 0L;
            long start = System.currentTimeMillis();
            this.formatMessage(iVerbose, iListener, "\nChecking database '" + this.getName() + "'...\n", new Object[0]);
            this.formatMessage(iVerbose, iListener, "\n(1) Checking data-clusters. This activity checks if pointers to data are coherent.", new Object[0]);
            OPhysicalPosition ppos = new OPhysicalPosition();
            OCluster[] oClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OCluster c = oClusterArray[n2];
                if (c instanceof OClusterLocal) {
                    int totalHoles;
                    this.formatMessage(iVerbose, iListener, "\n- data-cluster #%-5d %s -> ", c.getId(), c.getName());
                    OClusterEntryIterator it = c.absoluteIterator();
                    while (it.hasNext()) {
                        OPhysicalPosition physicalPosition = it.next();
                        ++totalRecors;
                        try {
                            if (physicalPosition.dataSegmentId >= this.dataSegments.length) {
                                this.formatMessage(iVerbose, iListener, "WARN: Found wrong data segment %d ", physicalPosition.dataSegmentId);
                                ++warnings;
                            }
                            if (physicalPosition.recordSize < 0) {
                                this.formatMessage(iVerbose, iListener, "WARN: Found wrong record size %d ", physicalPosition.recordSize);
                                ++warnings;
                            }
                            if (physicalPosition.recordSize >= 1000000) {
                                this.formatMessage(iVerbose, iListener, "WARN: Found suspected big record size %d. Is it corrupted? ", physicalPosition.recordSize);
                                ++warnings;
                            }
                            if (physicalPosition.dataSegmentPos > this.dataSegments[physicalPosition.dataSegmentId].getFilledUpTo()) {
                                this.formatMessage(iVerbose, iListener, "WARN: Found wrong pointer to data chunk %d out of data segment size (%d) ", physicalPosition.dataSegmentPos, this.dataSegments[physicalPosition.dataSegmentId].getFilledUpTo());
                                ++warnings;
                            }
                            if (!physicalPosition.recordVersion.isTombstone() || !(c instanceof OClusterLocal)) continue;
                            boolean found = false;
                            int tot = ((OClusterLocal)c).holeSegment.getHoles();
                            int i = 0;
                            while (i < tot) {
                                long recycledPosition = ((OClusterLocal)c).holeSegment.getEntryPosition(i) / (long)OClusterLocal.RECORD_SIZE;
                                if (recycledPosition == physicalPosition.clusterPosition.longValue()) {
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (found) continue;
                            this.formatMessage(iVerbose, iListener, "WARN: Cannot find hole for deleted record %d:%d ", c.getId(), physicalPosition.clusterPosition);
                            ++warnings;
                        }
                        catch (IOException e) {
                            this.formatMessage(iVerbose, iListener, "WARN: Error while reading record #%d:%d ", e, c.getId(), ppos.clusterPosition);
                            ++warnings;
                        }
                    }
                    if (c instanceof OClusterLocal && (totalHoles = ((OClusterLocal)c).holeSegment.getHoles()) > 0) {
                        this.formatMessage(iVerbose, iListener, " [found " + totalHoles + " hole(s)]", new Object[0]);
                        int i = 0;
                        while (i < totalHoles) {
                            long recycledPosition = -1L;
                            try {
                                ppos.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(((OClusterLocal)c).holeSegment.getEntryPosition(i) / (long)OClusterLocal.RECORD_SIZE);
                                OPhysicalPosition physicalPosition = c.getPhysicalPosition(ppos);
                                if (physicalPosition != null && !physicalPosition.recordVersion.isTombstone()) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Found wrong hole %d/%d for deleted record %d:%d. The record seems good ", i, totalHoles - 1, c.getId(), recycledPosition);
                                    ++warnings;
                                }
                            }
                            catch (Exception e) {
                                this.formatMessage(iVerbose, iListener, "WARN: Found wrong hole %d/%d for deleted record %d:%d. The record not exists ", i, totalHoles - 1, c.getId(), recycledPosition);
                                ++warnings;
                            }
                            ++i;
                        }
                    }
                    this.formatMessage(iVerbose, iListener, "OK", new Object[0]);
                }
                ++n2;
            }
            int totalChunks = 0;
            this.formatMessage(iVerbose, iListener, "\n\n(2) Checking data chunks integrity. In this phase data segments are scanned to check the back reference into the clusters.", new Object[0]);
            ODataLocal[] oDataLocalArray = this.dataSegments;
            int n3 = this.dataSegments.length;
            n = 0;
            while (n < n3) {
                ODataLocal d = oDataLocalArray[n];
                if (d != null) {
                    this.formatMessage(iVerbose, iListener, "\n- data-segment %s (id=%d) size=%d/%d...", d.getName(), d.getId(), d.getFilledUpTo(), d.getSize(), d.getHoles());
                    int nextPos = 0;
                    List<ODataHoleInfo> holes = d.getHolesList();
                    if (iVerbose) {
                        this.formatMessage(iVerbose, iListener, "\n-- found %d holes:", holes.size());
                        for (ODataHoleInfo hole : holes) {
                            this.formatMessage(iVerbose, iListener, "\n--- hole #%-7d offset=%-10d size=%-7d", hole.holeOffset, hole.dataOffset, hole.size);
                        }
                    }
                    this.formatMessage(iVerbose, iListener, "\n-- checking chunks:", new Object[0]);
                    do {
                        try {
                            int pos = nextPos;
                            ODataHoleInfo foundHole = null;
                            for (ODataHoleInfo hole : holes) {
                                if (hole.dataOffset != (long)pos) continue;
                                foundHole = hole;
                                break;
                            }
                            int recordSize = d.getRecordSize(pos);
                            this.formatMessage(iVerbose, iListener, "\n--- chunk #%-7d offset=%-10d size=%-7d -> ", totalChunks, pos, recordSize);
                            if (recordSize < 0) {
                                recordSize *= -1;
                                if (foundHole != null) {
                                    if (foundHole.size != recordSize) {
                                        this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) differs in size with the hole size %d ", d.getName(), totalChunks, pos, recordSize, foundHole.size);
                                        ++warnings;
                                    }
                                    nextPos = pos + foundHole.size;
                                } else {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has no hole for deleted chunk ", d.getName(), totalChunks, pos, recordSize);
                                    ++warnings;
                                    nextPos = pos + recordSize;
                                }
                            } else if (foundHole != null) {
                                this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) it's between the holes (hole #%d) even if has no negative recordSize. Jump the content ", d.getName(), totalChunks, pos, recordSize, foundHole.holeOffset);
                                ++warnings;
                                nextPos = pos + foundHole.size;
                            } else {
                                ORecordId rid;
                                nextPos = pos + ODataLocal.RECORD_FIX_SIZE + recordSize;
                                byte[] buffer = d.getRecord(pos);
                                if (buffer.length != recordSize) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has wrong record size because the record length is %d ", d.getName(), totalChunks, pos, recordSize, buffer.length);
                                    ++warnings;
                                }
                                if (!(rid = d.getRecordRid(pos)).isValid()) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) points to invalid RID %s ", d.getName(), totalChunks, pos, recordSize, rid);
                                    ++warnings;
                                } else if (rid.clusterId >= this.clusters.length) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has invalid RID because points to %s but configured clusters are %d in total ", d.getName(), totalChunks, pos, recordSize, rid, this.clusters.length);
                                    ++warnings;
                                } else if (this.clusters[rid.clusterId] == null) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has invalid RID because points to %s but the cluster %d not exists ", d.getName(), totalChunks, pos, recordSize, rid, rid.clusterId);
                                    ++warnings;
                                } else {
                                    ppos.clusterPosition = rid.clusterPosition;
                                    this.clusters[rid.clusterId].getPhysicalPosition(ppos);
                                    if (ppos.dataSegmentId != d.getId()) {
                                        this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) point to the RID %d but it doesn't point to current data segment %d but to %d ", d.getName(), totalChunks, pos, recordSize, rid, d.getId(), ppos.dataSegmentId);
                                        ++warnings;
                                    }
                                    if (ppos.dataSegmentPos != (long)pos) {
                                        this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) point to the RID %d but it doesn't point to current chunk %d but to %d ", d.getName(), totalChunks, pos, recordSize, rid, ppos.dataSegmentPos, pos);
                                        ++warnings;
                                    }
                                }
                            }
                            ++totalChunks;
                            this.formatMessage(iVerbose, iListener, "OK", new Object[0]);
                        }
                        catch (Exception e) {
                            iListener.onMessage("ERROR: " + e.toString());
                            ++errors;
                        }
                    } while ((long)nextPos < d.getFilledUpTo());
                    this.formatMessage(iVerbose, iListener, "\n", new Object[0]);
                }
                ++n;
            }
            iListener.onMessage("\nCheck of database completed in " + (System.currentTimeMillis() - start) + "ms:\n- Total records checked: " + totalRecors + "\n- Total chunks checked.: " + totalChunks + "\n- Warnings.............: " + warnings + "\n- Errors...............: " + errors + "\n");
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return errors == 0;
    }

    @Override
    public ODataLocal getDataSegmentById(int iDataSegmentId) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            if (iDataSegmentId >= this.dataSegments.length) {
                throw new IllegalArgumentException("Data segment #" + iDataSegmentId + " does not exist in database '" + this.name + "'");
            }
            ODataLocal oDataLocal = this.dataSegments[iDataSegmentId];
            return oDataLocal;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        if (iDataSegmentName == null) {
            return 0;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            ODataLocal[] oDataLocalArray = this.dataSegments;
            int n = this.dataSegments.length;
            int n2 = 0;
            while (n2 < n) {
                ODataLocal d = oDataLocalArray[n2];
                if (d != null && d.getName().equalsIgnoreCase(iDataSegmentName)) {
                    int n3 = d.getId();
                    return n3;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Data segment '" + iDataSegmentName + "' does not exist in database '" + this.name + "'");
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    @Override
    public int addDataSegment(String iSegmentName, String iDirectory) {
        this.checkOpeness();
        iSegmentName = iSegmentName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            OStorageDataConfiguration conf = new OStorageDataConfiguration(this.configuration, iSegmentName, -1, iDirectory);
            int pos = this.registerDataSegment(conf);
            if (pos == -1) {
                throw new OConfigurationException("Cannot add segment " + conf.name + " because it is already part of storage '" + this.name + "'");
            }
            this.dataSegments[pos].create(-1);
            conf.id = pos;
            if (pos == this.configuration.dataSegments.size()) {
                this.configuration.dataSegments.add(conf);
            } else {
                this.configuration.dataSegments.set(pos, conf);
            }
            this.configuration.update();
            int n = pos;
            return n;
        }
        catch (Throwable e) {
            OLogManager.instance().error((Object)this, "Error on creation of new data segment '" + iSegmentName + "' in: " + iDirectory, e, OStorageException.class, new Object[0]);
            return -1;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            OCluster cluster;
            if (iClusterName != null) {
                iClusterName = iClusterName.toLowerCase();
                int clusterPos = this.clusters.length;
                int i = 0;
                while (i < this.clusters.length) {
                    if (this.clusters[i] == null) {
                        clusterPos = i;
                        break;
                    }
                    ++i;
                }
                cluster = Orient.instance().getClusterFactory().createCluster(iClusterType, forceListBased);
                cluster.configure(this, clusterPos, iClusterName, iLocation, this.getDataSegmentIdByName(iDataSegmentName), iParameters);
            } else {
                cluster = null;
            }
            int clusterId = this.registerCluster(cluster);
            if (cluster != null) {
                cluster.create(-1);
                this.configuration.update();
            }
            int n = clusterId;
            return n;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error in creation of new cluster '" + iClusterName + "' of type: " + iClusterType, e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return -1;
    }

    @Override
    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        throw new UnsupportedOperationException();
    }

    public ODataLocal[] getDataSegments() {
        return this.dataSegments;
    }

    public OStorageLocalTxExecuter getTxManager() {
        return this.txManager;
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.lock.acquireExclusiveLock();
        try {
            if (iClusterId < 0 || iClusterId >= this.clusters.length) {
                throw new IllegalArgumentException("Cluster id '" + iClusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.length - 1) + ") in database '" + this.name + "'");
            }
            OCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                return false;
            }
            this.getLevel2Cache().freeCluster(iClusterId);
            if (iTruncate) {
                cluster.truncate();
            }
            cluster.delete();
            this.clusterMap.remove(cluster.getName());
            this.clusters[iClusterId] = null;
            this.configuration.dropCluster(iClusterId);
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error while removing cluster '" + iClusterId + "'", e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    @Override
    public boolean dropDataSegment(String iName) {
        this.lock.acquireExclusiveLock();
        try {
            int id = this.getDataSegmentIdByName(iName);
            ODataLocal data = this.dataSegments[id];
            if (data == null) {
                return false;
            }
            data.drop();
            this.dataSegments[id] = null;
            this.configuration.dropDataSegment(id);
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error while removing data segment '" + iName + "'", e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            int[] nArray = iClusterIds;
            int n = iClusterIds.length;
            int n2 = 0;
            while (n2 < n) {
                OCluster c;
                int iClusterId = nArray[n2];
                if (iClusterId >= this.clusters.length) {
                    throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
                }
                if (iClusterId > -1 && (c = this.clusters[iClusterId]) != null) {
                    tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
                }
                ++n2;
            }
            long l = tot;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        if (iClusterId == -1) {
            return new OClusterPosition[]{OClusterPosition.INVALID_POSITION, OClusterPosition.INVALID_POSITION};
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OClusterPosition[] oClusterPositionArray;
            if (this.clusters[iClusterId] != null) {
                OClusterPosition[] oClusterPositionArray2 = new OClusterPosition[2];
                oClusterPositionArray2[0] = this.clusters[iClusterId].getFirstPosition();
                oClusterPositionArray = oClusterPositionArray2;
                oClusterPositionArray2[1] = this.clusters[iClusterId].getLastPosition();
            } else {
                oClusterPositionArray = new OClusterPosition[]{};
            }
            OClusterPosition[] oClusterPositionArray3 = oClusterPositionArray;
            return oClusterPositionArray3;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not retrieve information about data range", ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    @Override
    public long count(int iClusterId, boolean countTombstones) {
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id " + iClusterId + " is invalid in database '" + this.name + "'");
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                return 0L;
            }
            if (countTombstones) {
                long l = cluster.getEntries();
                return l;
            }
            long l = cluster.getEntries() - cluster.getTombstonesCount();
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        OPhysicalPosition ppos;
        this.checkOpeness();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        ODataLocal dataSegment = this.getDataSegmentById(iDataSegmentId);
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                if (this.txManager.isCommitting()) {
                    ppos = this.txManager.createRecord(this.txManager.getCurrentTransaction().getId(), dataSegment, cluster, iRid, iContent, iRecordVersion, iRecordType);
                } else {
                    ppos = this.createRecord(dataSegment, cluster, iContent, iRecordType, iRid, iRecordVersion);
                    if (OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean() || this.clustersToSyncImmediately.contains(cluster.getName())) {
                        this.synchRecordUpdate(cluster, ppos);
                    }
                    if (iCallback != null) {
                        iCallback.call(iRid, ppos.clusterPosition);
                    }
                }
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
        return new OStorageOperationResult<OPhysicalPosition>(ppos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        if (rid.isNew()) {
            throw new OStorageException("Passed record with id " + rid + " is new and can not be treated as replica.");
        }
        this.checkOpeness();
        OCluster cluster = this.getClusterById(rid.clusterId);
        ODataLocal dataSegment = this.getDataSegmentById(dataSegmentId);
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                try {
                    OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.clusterPosition));
                    if (ppos == null) {
                        if (!cluster.isHashBased()) {
                            throw new OStorageException("Cluster with LH support is required.");
                        }
                        ppos = new OPhysicalPosition(rid.clusterPosition, recordVersion);
                        ppos.recordType = recordType;
                        ppos.dataSegmentId = dataSegment.getId();
                        if (!recordVersion.isTombstone()) {
                            ppos.dataSegmentPos = dataSegment.addRecord(rid, content);
                        }
                        cluster.addPhysicalPosition(ppos);
                        return true;
                    }
                    if (ppos.recordType != recordType) {
                        throw new OStorageException("Record types of provided and stored replicas are different " + recordType + ":" + ppos.recordType + ".");
                    }
                    if (ppos.recordVersion.compareTo(recordVersion) < 0) {
                        cluster.updateVersion(ppos.clusterPosition, recordVersion);
                        if (!recordVersion.isTombstone() && !ppos.recordVersion.isTombstone()) {
                            ppos.dataSegmentPos = dataSegment.setRecord(ppos.dataSegmentPos, rid, content);
                            cluster.updateDataSegmentPosition(ppos.clusterPosition, dataSegmentId, ppos.dataSegmentPos);
                            return true;
                        }
                        if (!recordVersion.isTombstone() && ppos.recordVersion.isTombstone()) {
                            ppos.dataSegmentPos = dataSegment.addRecord(rid, content);
                            cluster.updateDataSegmentPosition(ppos.clusterPosition, dataSegmentId, ppos.dataSegmentPos);
                            return true;
                        }
                        if (!recordVersion.isTombstone()) return true;
                        if (ppos.recordVersion.isTombstone()) return true;
                        dataSegment.deleteRecord(ppos.dataSegmentPos);
                        return true;
                    }
                }
                finally {
                    this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                }
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.modificationLock.requestModificationLock();
            try {
                V v = super.callInLock(iCallable, iExclusiveLock);
                return v;
            }
            finally {
                this.modificationLock.releaseModificationLock();
            }
        }
        return super.callInLock(iCallable, iExclusiveLock);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <V> V callInRecordLock(Callable<V> callable, ORID rid, boolean exclusiveLock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        this.checkOpeness();
        return new OStorageOperationResult<ORawBuffer>(this.readRecord(this.getClusterById(iRid.clusterId), iRid, true, loadTombstones));
    }

    @Override
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        this.checkOpeness();
        this.modificationLock.requestModificationLock();
        try {
            ORecordVersion returnValue;
            OCluster cluster;
            block10: {
                OStorageOperationResult<ORecordVersion> oStorageOperationResult;
                this.lock.acquireExclusiveLock();
                try {
                    cluster = this.getClusterById(iRid.clusterId);
                    if (!this.txManager.isCommitting()) break block10;
                    oStorageOperationResult = new OStorageOperationResult<ORecordVersion>(this.txManager.updateRecord(this.txManager.getCurrentTransaction().getId(), cluster, iRid, iContent, iVersion, iRecordType));
                }
                catch (Throwable throwable) {
                    this.lock.releaseExclusiveLock();
                    throw throwable;
                }
                this.lock.releaseExclusiveLock();
                return oStorageOperationResult;
            }
            OPhysicalPosition ppos = this.updateRecord(cluster, iRid, iContent, iVersion, iRecordType);
            if (ppos != null && (OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean() || this.clustersToSyncImmediately.contains(cluster.getName()))) {
                this.synchRecordUpdate(cluster, ppos);
            }
            ORecordVersion oRecordVersion = returnValue = ppos != null ? ppos.recordVersion : OVersionFactory.instance().createUntrackedVersion();
            if (iCallback != null) {
                iCallback.call(iRid, returnValue);
            }
            OStorageOperationResult<ORecordVersion> oStorageOperationResult = new OStorageOperationResult<ORecordVersion>(returnValue);
            this.lock.releaseExclusiveLock();
            return oStorageOperationResult;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.checkOpeness();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.modificationLock.requestModificationLock();
        try {
            boolean returnValue;
            block10: {
                OStorageOperationResult<Boolean> oStorageOperationResult;
                this.lock.acquireExclusiveLock();
                try {
                    if (!this.txManager.isCommitting()) break block10;
                    oStorageOperationResult = new OStorageOperationResult<Boolean>(this.txManager.deleteRecord(this.txManager.getCurrentTransaction().getId(), cluster, iRid.clusterPosition, iVersion));
                }
                catch (Throwable throwable) {
                    this.lock.releaseExclusiveLock();
                    throw throwable;
                }
                this.lock.releaseExclusiveLock();
                return oStorageOperationResult;
            }
            OPhysicalPosition ppos = this.deleteRecord(cluster, iRid, iVersion, OGlobalConfiguration.STORAGE_USE_TOMBSTONES.getValueAsBoolean());
            if (ppos != null && (OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean() || this.clustersToSyncImmediately.contains(cluster.getName()))) {
                this.synchRecordUpdate(cluster, ppos);
            }
            boolean bl = returnValue = ppos != null;
            if (iCallback != null) {
                iCallback.call(iRid, returnValue);
            }
            OStorageOperationResult<Boolean> oStorageOperationResult = new OStorageOperationResult<Boolean>(returnValue);
            this.lock.releaseExclusiveLock();
            return oStorageOperationResult;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            Set<String> set = this.clusterMap.keySet();
            return set;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkOpeness();
        if (iClusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        if (iClusterName.length() == 0) {
            throw new IllegalArgumentException("Cluster name is empty");
        }
        if (Character.isDigit(iClusterName.charAt(0))) {
            return Integer.parseInt(iClusterName);
        }
        this.lock.acquireSharedLock();
        try {
            OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
            if (segment != null) {
                int n = segment.getId();
                return n;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return -1;
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        this.checkOpeness();
        if (iClusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        this.lock.acquireSharedLock();
        try {
            OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
            if (segment != null) {
                String string = segment.getType();
                return string;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return null;
    }

    @Override
    public void commit(OTransaction iTx) {
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                try {
                    try {
                        this.txManager.clearLogEntries(iTx);
                        this.txManager.commitAllPendingRecords(iTx);
                        if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                            this.synch();
                        }
                    }
                    catch (Exception e) {
                        OLogManager.instance().info((Object)this, "Error during transaction commit, transaction will be rolled back (tx-id=%d)", (Throwable)e, new Object[]{iTx.getId()});
                        this.rollback(iTx);
                        if (e instanceof OException) {
                            throw (OException)((Object)e);
                        }
                        throw new OStorageException("Error during transaction commit.", e);
                    }
                }
                finally {
                    try {
                        this.txManager.clearLogEntries(iTx);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Clear tx log entries failed", (Throwable)e, new Object[0]);
                    }
                }
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                try {
                    this.txManager.getTxSegment().rollback(iTx);
                    if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                        this.synch();
                    }
                }
                catch (IOException ioe) {
                    OLogManager.instance().error((Object)this, "Error executing rollback for transaction with id '" + iTx.getId() + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
                    this.lock.releaseExclusiveLock();
                }
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public void synch() {
        this.checkOpeness();
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                Object[] objectArray = this.clusters;
                int n = this.clusters.length;
                int n2 = 0;
                while (n2 < n) {
                    OCluster cluster = objectArray[n2];
                    if (cluster != null) {
                        cluster.synch();
                    }
                    ++n2;
                }
                objectArray = this.dataSegments;
                n = this.dataSegments.length;
                n2 = 0;
                while (n2 < n) {
                    Object data = objectArray[n2];
                    if (data != null) {
                        ((ODataLocal)data).synch();
                    }
                    ++n2;
                }
                if (this.configuration != null) {
                    this.configuration.synch();
                }
            }
            catch (IOException e) {
                throw new OStorageException("Error on synch storage '" + this.name + "'", e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a local database", timer, "db.*.synch");
        }
    }

    protected void synchRecordUpdate(OCluster cluster, OPhysicalPosition ppos) {
        this.checkOpeness();
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                cluster.synch();
                ODataLocal data = this.getDataSegmentById(ppos.dataSegmentId);
                data.synch();
                if (this.configuration != null) {
                    this.configuration.synch();
                }
            }
            catch (IOException e) {
                throw new OStorageException("Error on synch storage '" + this.name + "'", e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + "record.synch", "Synch a record to local database", timer, "db.*.record.synch");
        }
    }

    public List<ODataHoleInfo> getHolesList() {
        ArrayList<ODataHoleInfo> holes = new ArrayList<ODataHoleInfo>();
        this.lock.acquireSharedLock();
        try {
            ODataLocal[] oDataLocalArray = this.dataSegments;
            int n = this.dataSegments.length;
            int n2 = 0;
            while (n2 < n) {
                ODataLocal d = oDataLocalArray[n2];
                if (d != null) {
                    holes.addAll(d.getHolesList());
                }
                ++n2;
            }
            ArrayList<ODataHoleInfo> arrayList = holes;
            return arrayList;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public long getHoles() {
        this.lock.acquireSharedLock();
        try {
            long holes = 0L;
            ODataLocal[] oDataLocalArray = this.dataSegments;
            int n = this.dataSegments.length;
            int n2 = 0;
            while (n2 < n) {
                ODataLocal d = oDataLocalArray[n2];
                if (d != null) {
                    holes += d.getHoles();
                }
                ++n2;
            }
            long l = holes;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public long getHoleSize() {
        this.lock.acquireSharedLock();
        try {
            List<ODataHoleInfo> holes = this.getHolesList();
            long size = 0L;
            for (ODataHoleInfo h : holes) {
                if (h.dataOffset <= -1L || h.size <= 0) continue;
                size += (long)h.size;
            }
            long l = size;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.checkOpeness();
        if (iClusterId < 0) {
            return null;
        }
        this.lock.acquireSharedLock();
        try {
            if (iClusterId >= this.clusters.length) {
                return null;
            }
            String string = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getName() : null;
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            OCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
            }
            OCluster oCluster = cluster;
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterName + " does not exist in database '" + this.name + "'");
            }
            OCluster oCluster = cluster;
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getURL() {
        return "local:" + this.url;
    }

    @Override
    public long getSize() {
        this.lock.acquireSharedLock();
        try {
            long size = 0L;
            OCluster[] oClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OCluster c = oClusterArray[n2];
                if (c != null) {
                    size += c.getRecordsSize();
                }
                ++n2;
            }
            long l = size;
            return l;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not calculate records size");
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getStoragePath() {
        return this.storagePath;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        this.lock.acquireSharedLock();
        try {
            OCluster[] oClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OCluster c = oClusterArray[n2];
                if (c != null) {
                    result.add(c);
                }
                ++n2;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return result;
    }

    public void renameCluster(String iOldName, String iNewName) {
        this.clusterMap.put(iNewName, this.clusterMap.remove(iOldName));
    }

    protected int registerDataSegment(OStorageDataConfiguration iConfig) throws IOException {
        this.checkOpeness();
        ODataLocal[] oDataLocalArray = this.dataSegments;
        int n = this.dataSegments.length;
        int n2 = 0;
        while (n2 < n) {
            ODataLocal data = oDataLocalArray[n2];
            if (data != null && data.getName().equals(iConfig.name)) {
                data.config = iConfig;
                return -1;
            }
            ++n2;
        }
        int pos = -1;
        int i = 0;
        while (i < this.dataSegments.length) {
            if (this.dataSegments[i] == null) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            pos = this.dataSegments.length;
        }
        ODataLocal segment = new ODataLocal(this, iConfig, pos);
        if (pos == this.dataSegments.length) {
            this.dataSegments = (ODataLocal[])OArrays.copyOf((Object[])this.dataSegments, (int)(this.dataSegments.length + 1));
        }
        this.dataSegments[pos] = segment;
        return pos;
    }

    private int createClusterFromConfig(OStorageClusterConfiguration iConfig) throws IOException {
        OCluster cluster = this.clusterMap.get(iConfig.getName());
        if (cluster instanceof OClusterLocal && iConfig instanceof OStorageEHClusterConfiguration) {
            this.clusterMap.remove(iConfig.getName());
        } else if (cluster != null) {
            if (cluster instanceof OClusterLocal || cluster instanceof OClusterLocalEH) {
                cluster.configure(this, iConfig);
            }
            return -1;
        }
        cluster = Orient.instance().getClusterFactory().createCluster(iConfig);
        cluster.configure(this, iConfig);
        return this.registerCluster(cluster);
    }

    private int registerCluster(OCluster iCluster) throws IOException {
        int id;
        if (iCluster != null) {
            if (this.clusterMap.containsKey(iCluster.getName())) {
                throw new OConfigurationException("Cannot add segment '" + iCluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(iCluster.getName(), iCluster);
            id = iCluster.getId();
        } else {
            id = this.clusters.length;
        }
        this.clusters = (OCluster[])OArrays.copyOf((Object[])this.clusters, (int)(this.clusters.length + 1));
        this.clusters[id] = iCluster;
        return id;
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.length - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    @Override
    protected OPhysicalPosition createRecord(ODataLocal dataSegment, OCluster cluster, byte[] content, byte recordType, ORecordId rid, ORecordVersion recordVersion) {
        assert (this.lock.assertExclusiveLockHold());
        this.checkOpeness();
        if (content == null) {
            throw new IllegalArgumentException("Record is null");
        }
        long timer = Orient.instance().getProfiler().startChrono();
        OPhysicalPosition ppos = new OPhysicalPosition(-1, -1L, recordType);
        if (cluster.isHashBased()) {
            ppos.clusterPosition = rid.isNew() ? (OGlobalConfiguration.USE_NODE_ID_CLUSTER_POSITION.getValueAsBoolean() ? OClusterPositionFactory.INSTANCE.generateUniqueClusterPosition() : OClusterPositionFactory.INSTANCE.valueOf(this.positionGenerator++)) : rid.clusterPosition;
        }
        try {
            OPhysicalPosition oPhysicalPosition;
            if (!cluster.addPhysicalPosition(ppos)) {
                throw new OStorageException("Record with given id " + new ORecordId(rid.clusterId, ppos.clusterPosition) + " already exists.");
            }
            rid.clusterPosition = ppos.clusterPosition;
            this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
            try {
                ppos.dataSegmentId = dataSegment.getId();
                ppos.dataSegmentPos = dataSegment.addRecord(rid, content);
                cluster.updateDataSegmentPosition(ppos.clusterPosition, ppos.dataSegmentId, ppos.dataSegmentPos);
                if (recordVersion.getCounter() > -1 && recordVersion.compareTo(ppos.recordVersion) > 0) {
                    cluster.updateVersion(rid.clusterPosition, recordVersion);
                    ppos.recordVersion = recordVersion;
                }
                oPhysicalPosition = ppos;
            }
            catch (Throwable throwable) {
                try {
                    this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                    throw throwable;
                }
                catch (IOException ioe) {
                    try {
                        if (ppos.clusterPosition != null && ppos.clusterPosition.compareTo(OClusterPosition.INVALID_POSITION) != 0) {
                            cluster.removePhysicalPosition(ppos.clusterPosition);
                        }
                    }
                    catch (IOException e) {
                        OLogManager.instance().error((Object)this, "Error on removing physical position in cluster: " + cluster, (Throwable)e, new Object[0]);
                    }
                    OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + cluster, (Throwable)ioe, new Object[0]);
                    return null;
                }
            }
            this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
            return oPhysicalPosition;
        }
        finally {
            Orient.instance().getProfiler().stopChrono(this.PROFILER_CREATE_RECORD, "Create a record in local database", timer, "db.*.createRecord");
        }
    }

    @Override
    public boolean isHashClustersAreUsed() {
        return OGlobalConfiguration.USE_LHPEPS_CLUSTER.getValueAsBoolean();
    }

    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock, boolean loadTombstones) {
        if (!iRid.isPersistent()) {
            throw new IllegalArgumentException("Cannot read record " + iRid + " since the position is invalid in database '" + this.name + '\'');
        }
        long timer = Orient.instance().getProfiler().startChrono();
        if (iAtomicLock) {
            this.lock.acquireSharedLock();
        }
        try {
            OPhysicalPosition ppos;
            block16: {
                block15: {
                    ORawBuffer oRawBuffer;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (ppos == null || !loadTombstones || !ppos.recordVersion.isTombstone()) break block15;
                        oRawBuffer = new ORawBuffer(null, ppos.recordVersion, ppos.recordType);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                            throw throwable;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on reading record " + iRid + " (cluster: " + iClusterSegment + ')', (Throwable)e, new Object[0]);
                            return null;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                    return oRawBuffer;
                }
                if (ppos != null && this.checkForRecordValidity(ppos)) break block16;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                return null;
            }
            ODataLocal data = this.getDataSegmentById(ppos.dataSegmentId);
            ORawBuffer oRawBuffer = new ORawBuffer(data.getRecord(ppos.dataSegmentPos), ppos.recordVersion, ppos.recordType);
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
            return oRawBuffer;
        }
        finally {
            if (iAtomicLock) {
                this.lock.releaseSharedLock();
            }
            Orient.instance().getProfiler().stopChrono(this.PROFILER_READ_RECORD, "Read a record from local database", timer, "db.*.readRecord");
        }
    }

    @Override
    protected OPhysicalPosition updateRecord(OCluster iClusterSegment, ORecordId rid, byte[] recordContent, ORecordVersion recordVersion, byte iRecordType) {
        block22: {
            assert (this.lock.assertExclusiveLockHold());
            if (iClusterSegment == null) {
                throw new OStorageException("Cluster not defined for record: " + rid);
            }
            long timer = Orient.instance().getProfiler().startChrono();
            try {
                long newDataSegmentOffset;
                OPhysicalPosition ppos;
                block21: {
                    this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(rid.clusterPosition));
                        if (this.checkForRecordValidity(ppos)) break block21;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                            throw throwable;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on updating record " + rid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                            break block22;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                    return null;
                }
                switch (recordVersion.getCounter()) {
                    case -1: {
                        ppos.recordVersion.increment();
                        iClusterSegment.updateVersion(rid.clusterPosition, ppos.recordVersion);
                        break;
                    }
                    case -2: {
                        break;
                    }
                    default: {
                        if (recordVersion.getCounter() > -1) {
                            if (!recordVersion.equals(ppos.recordVersion)) {
                                if (OFastConcurrentModificationException.enabled()) {
                                    throw OFastConcurrentModificationException.instance();
                                }
                                throw new OConcurrentModificationException(rid, ppos.recordVersion, recordVersion, 1);
                            }
                            ppos.recordVersion.increment();
                            iClusterSegment.updateVersion(rid.clusterPosition, ppos.recordVersion);
                            break;
                        }
                        recordVersion.clearRollbackMode();
                        ppos.recordVersion.copyFrom(recordVersion);
                        iClusterSegment.updateVersion(rid.clusterPosition, ppos.recordVersion);
                    }
                }
                if (ppos.recordType != iRecordType) {
                    iClusterSegment.updateRecordType(rid.clusterPosition, iRecordType);
                }
                if ((newDataSegmentOffset = ppos.dataSegmentPos == -1L ? this.getDataSegmentById(ppos.dataSegmentId).addRecord(rid, recordContent) : this.getDataSegmentById(ppos.dataSegmentId).setRecord(ppos.dataSegmentPos, rid, recordContent)) != ppos.dataSegmentPos) {
                    iClusterSegment.updateDataSegmentPosition(ppos.clusterPosition, ppos.dataSegmentId, newDataSegmentOffset);
                    ppos.dataSegmentPos = newDataSegmentOffset;
                }
                OPhysicalPosition oPhysicalPosition = ppos;
                this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
                return oPhysicalPosition;
            }
            finally {
                Orient.instance().getProfiler().stopChrono(this.PROFILER_UPDATE_RECORD, "Update a record to local database", timer, "db.*.updateRecord");
            }
        }
        return null;
    }

    protected OPhysicalPosition deleteRecord(OCluster iClusterSegment, ORecordId iRid, ORecordVersion iVersion, boolean useTombstones) {
        block19: {
            assert (this.lock.assertExclusiveLockHold());
            long timer = Orient.instance().getProfiler().startChrono();
            try {
                OPhysicalPosition ppos;
                block18: {
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (ppos != null && ppos.dataSegmentId >= 0 && (!useTombstones || !ppos.recordVersion.isTombstone())) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                            throw throwable;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on deleting record " + iRid + "( cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                            break block19;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    return null;
                }
                if (iVersion.getCounter() > -1 && !ppos.recordVersion.equals(iVersion)) {
                    if (OFastConcurrentModificationException.enabled()) {
                        throw OFastConcurrentModificationException.instance();
                    }
                    throw new OConcurrentModificationException(iRid, ppos.recordVersion, iVersion, 2);
                }
                if (!ppos.recordVersion.isTombstone() && ppos.dataSegmentPos > -1L) {
                    try {
                        this.getDataSegmentById(ppos.dataSegmentId).deleteRecord(ppos.dataSegmentPos);
                    }
                    catch (OIOException e) {
                        OLogManager.instance().error((Object)this, "Cannot remove the record in data segment, however remove it from cluster", (Throwable)e, new Object[0]);
                    }
                }
                if (useTombstones && iClusterSegment.hasTombstonesSupport()) {
                    iClusterSegment.convertToTombstone(iRid.clusterPosition);
                } else {
                    iClusterSegment.removePhysicalPosition(iRid.clusterPosition);
                }
                OPhysicalPosition oPhysicalPosition = ppos;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                return oPhysicalPosition;
            }
            finally {
                Orient.instance().getProfiler().stopChrono(this.PROFILER_DELETE_RECORD, "Delete a record from local database", timer, "db.*.deleteRecord");
            }
        }
        return null;
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        OCluster cluster = this.getClusterById(recordId.clusterId);
        this.modificationLock.requestModificationLock();
        try {
            boolean returnValue;
            OPhysicalPosition ppos = this.deleteRecord(cluster, recordId, recordVersion, false);
            if (ppos != null && (OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean() || this.clustersToSyncImmediately.contains(cluster.getName()))) {
                this.synchRecordUpdate(cluster, ppos);
            }
            boolean bl = returnValue = ppos != null;
            if (callback != null) {
                callback.call(recordId, returnValue);
            }
            boolean bl2 = returnValue;
            return bl2;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    private void installProfilerHooks() {
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".data.holes", "Number of the holes in local database", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoles();
            }
        }, "db.*.data.holes");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".data.holeSize", "Size of the holes in local database", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoleSize();
            }
        }, "db.*.data.holeSize");
    }

    private void uninstallProfilerHooks() {
        Orient.instance().getProfiler().unregisterHookValue("db." + this.name + ".data.holes");
        Orient.instance().getProfiler().unregisterHookValue("db." + this.name + ".data.holeSize");
    }

    private void formatMessage(boolean iVerbose, OCommandOutputListener iListener, String iMessage, Object ... iArgs) {
        if (iVerbose) {
            iListener.onMessage(String.format(iMessage, iArgs));
        }
    }

    @Override
    public void freeze(boolean throwException) {
        this.modificationLock.prohibitModifications(throwException);
        this.synch();
        try {
            Object[] objectArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OCluster cluster = objectArray[n2];
                if (cluster != null) {
                    cluster.setSoftlyClosed(true);
                }
                ++n2;
            }
            objectArray = this.dataSegments;
            n = this.dataSegments.length;
            n2 = 0;
            while (n2 < n) {
                Object data = objectArray[n2];
                if (data != null) {
                    ((ODataLocal)data).setSoftlyClosed(true);
                }
                ++n2;
            }
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(true);
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on freeze storage '" + this.name + "'", e);
        }
    }

    @Override
    public void release() {
        try {
            Object[] objectArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OCluster cluster = objectArray[n2];
                if (cluster != null) {
                    cluster.setSoftlyClosed(false);
                }
                ++n2;
            }
            objectArray = this.dataSegments;
            n = this.dataSegments.length;
            n2 = 0;
            while (n2 < n) {
                Object data = objectArray[n2];
                if (data != null) {
                    ((ODataLocal)data).setSoftlyClosed(false);
                }
                ++n2;
            }
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(false);
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on release storage '" + this.name + "'", e);
        }
        this.modificationLock.allowModifications();
    }

    @Override
    public boolean wasClusterSoftlyClosed(String clusterName) {
        OCluster indexCluster = this.clusterMap.get(clusterName);
        return !(indexCluster instanceof OClusterLocal) || ((OClusterLocal)indexCluster).isSoftlyClosed();
    }

    @Override
    public String getType() {
        return "local";
    }
}

