/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OMMapManagerOld
extends OMMapManagerAbstract
implements OMMapManager {
    private static final long MIN_MEMORY = 50000000L;
    private static OVERLAP_STRATEGY overlapStrategy;
    private static OMMapManager.ALLOC_STRATEGY lastStrategy;
    private static int blockSize;
    private static long maxMemory;
    private static long totalMemory;
    private static final ReadWriteLock lock;
    private static long metricUsedChannel;
    private static long metricReusedPagesBetweenLast;
    private static long metricReusedPages;
    private static long metricOverlappedPageUsingChannel;
    private static List<OMMapBufferEntry> bufferPoolLRU;
    private static Map<OFileMMap, List<OMMapBufferEntry>> bufferPoolPerFile;

    OMMapManagerOld() {
    }

    @Override
    public void init() {
        blockSize = OGlobalConfiguration.FILE_MMAP_BLOCK_SIZE.getValueAsInteger();
        maxMemory = OGlobalConfiguration.FILE_MMAP_MAX_MEMORY.getValueAsLong();
        OMMapManagerOld.setOverlapStrategy(OGlobalConfiguration.FILE_MMAP_OVERLAP_STRATEGY.getValueAsInteger());
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.totalMemory", "Total memory used by memory mapping", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return totalMemory;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.maxMemory", "Maximum memory usable by memory mapping", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return maxMemory;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.blockSize", "Total block size used for memory mapping", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return blockSize;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.blocks", "Total memory used by memory mapping", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() {
                lock.readLock().lock();
                try {
                    Integer n = bufferPoolLRU.size();
                    return n;
                }
                finally {
                    lock.readLock().unlock();
                }
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.alloc.strategy", "Memory mapping allocation strategy", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return lastStrategy;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.overlap.strategy", "Memory mapping overlapping strategy", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return overlapStrategy;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.usedChannel", "Number of times the memory mapping has been bypassed to use direct file channel", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricUsedChannel;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.reusedPagesBetweenLast", "Number of times a memory mapped page has been reused in short time", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricReusedPagesBetweenLast;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.reusedPages", "Number of times a memory mapped page has been reused", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricReusedPages;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.overlappedPageUsingChannel", "Number of times a direct file channel access has been used because overlapping", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricOverlappedPageUsingChannel;
            }
        });
    }

    @Override
    public OMMapBufferEntry[] acquire(OFileMMap iFile, long iBeginOffset, int iSize, OMMapManager.OPERATION_TYPE iOperationType, OMMapManager.ALLOC_STRATEGY iStrategy) {
        return this.acquire(iFile, iBeginOffset, iSize, false, iOperationType, iStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OMMapBufferEntry[] acquire(OFileMMap iFile, long iBeginOffset, int iSize, boolean iForce, OMMapManager.OPERATION_TYPE iOperationType, OMMapManager.ALLOC_STRATEGY iStrategy) {
        if (iStrategy == OMMapManager.ALLOC_STRATEGY.MMAP_NEVER) {
            return null;
        }
        lock.writeLock().lock();
        try {
            lastStrategy = iStrategy;
            OMMapBufferEntry entry = OMMapManagerOld.searchBetweenLastBlocks(iFile, iBeginOffset, iSize);
            try {
                int position;
                if (entry != null && entry.buffer != null) {
                    OMMapBufferEntry[] oMMapBufferEntryArray = new OMMapBufferEntry[]{entry};
                    return oMMapBufferEntryArray;
                }
                List<OMMapBufferEntry> fileEntries = bufferPoolPerFile.get(iFile);
                if (fileEntries == null) {
                    fileEntries = new ArrayList<OMMapBufferEntry>();
                    bufferPoolPerFile.put(iFile, fileEntries);
                }
                if ((position = OMMapManagerOld.searchEntry(fileEntries, iBeginOffset, iSize)) > -1 && (entry = fileEntries.get(position)) != null && entry.buffer != null) {
                    OMMapBufferEntry[] oMMapBufferEntryArray = new OMMapBufferEntry[]{entry};
                    return oMMapBufferEntryArray;
                }
                int p = (position + 2) * -1;
                if (!OMMapManagerOld.allocIfOverlaps(iBeginOffset, iSize, fileEntries, p)) {
                    ++metricUsedChannel;
                    OMMapBufferEntry[] oMMapBufferEntryArray = null;
                    return oMMapBufferEntryArray;
                }
                int bufferSize = OMMapManagerOld.computeBestEntrySize(iFile, iBeginOffset, iSize, iForce, fileEntries, p);
                if (totalMemory + (long)bufferSize > maxMemory && (iStrategy == OMMapManager.ALLOC_STRATEGY.MMAP_ONLY_AVAIL_POOL || iOperationType == OMMapManager.OPERATION_TYPE.READ && iStrategy == OMMapManager.ALLOC_STRATEGY.MMAP_WRITE_ALWAYS_READ_IF_AVAIL_POOL)) {
                    ++metricUsedChannel;
                    OMMapBufferEntry[] oMMapBufferEntryArray = null;
                    return oMMapBufferEntryArray;
                }
                entry = null;
                do {
                    if (totalMemory + (long)bufferSize > maxMemory) {
                        OMMapManagerOld.freeResources();
                    }
                    if ((position = OMMapManagerOld.searchEntry(fileEntries = bufferPoolPerFile.get(iFile), iBeginOffset, iSize)) > -1 && (entry = fileEntries.get(position)) != null && entry.buffer != null) {
                        OMMapBufferEntry[] oMMapBufferEntryArray = new OMMapBufferEntry[]{entry};
                        return oMMapBufferEntryArray;
                    }
                    try {
                        entry = OMMapManagerOld.mapBuffer(iFile, iBeginOffset, bufferSize);
                    }
                    catch (IllegalArgumentException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        maxMemory = maxMemory * 90L / 100L;
                        OLogManager.instance().warn(OMMapManagerOld.class, "Memory mapping error, try to reduce max memory to %d and retry...", (Throwable)e, new Object[]{maxMemory});
                    }
                } while (entry == null && maxMemory > 50000000L);
                if (entry == null) throw new OIOException("You cannot access to the file portion " + iBeginOffset + "-" + iBeginOffset + iSize + " bytes");
                if (!entry.isValid()) {
                    throw new OIOException("You cannot access to the file portion " + iBeginOffset + "-" + iBeginOffset + iSize + " bytes");
                }
                totalMemory += (long)bufferSize;
                bufferPoolLRU.add(entry);
                p = (position + 2) * -1;
                if (p < 0) {
                    p = 0;
                }
                if (fileEntries == null) {
                    fileEntries = new ArrayList<OMMapBufferEntry>();
                    bufferPoolPerFile.put(iFile, fileEntries);
                }
                fileEntries.add(p, entry);
                if (entry != null && entry.buffer != null) {
                    OMMapBufferEntry[] oMMapBufferEntryArray = new OMMapBufferEntry[]{entry};
                    return oMMapBufferEntryArray;
                }
            }
            finally {
                if (entry != null) {
                    entry.acquireLock();
                    if (iOperationType == OMMapManager.OPERATION_TYPE.WRITE) {
                        entry.setDirty();
                    }
                }
            }
            OMMapBufferEntry[] oMMapBufferEntryArray = null;
            return oMMapBufferEntryArray;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static void freeResources() {
        long memoryThreshold = (long)((double)maxMemory * 0.75);
        long startingMemory = totalMemory;
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug(null, "Freeing off-heap memory as mmmap blocks, target is %s...", new Object[]{OFileUtils.getSizeAsString((long)(startingMemory - memoryThreshold))});
        }
        Collections.sort(bufferPoolLRU, new Comparator<OMMapBufferEntry>(){

            @Override
            public int compare(OMMapBufferEntry o1, OMMapBufferEntry o2) {
                return (int)(o1.getLastUsed() - o2.getLastUsed());
            }
        });
        Iterator<OMMapBufferEntry> it = bufferPoolLRU.iterator();
        while (it.hasNext()) {
            OMMapBufferEntry entry = it.next();
            if (OMMapManagerOld.removeEntry(entry)) {
                it.remove();
            }
            if (totalMemory >= memoryThreshold) continue;
            break;
        }
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug(null, "Freed off-heap memory as mmmap blocks for %s...", new Object[]{OFileUtils.getSizeAsString((long)(startingMemory - totalMemory))});
        }
    }

    private static OMMapBufferEntry searchBetweenLastBlocks(OFileMMap iFile, long iBeginOffset, int iSize) {
        if (!bufferPoolLRU.isEmpty()) {
            int min = Math.max(bufferPoolLRU.size() - 5, -1);
            for (int i = bufferPoolLRU.size() - 1; i > min; --i) {
                OMMapBufferEntry e = bufferPoolLRU.get(i);
                if (!e.isValid() || e.file != iFile || iBeginOffset < e.beginOffset || iBeginOffset + (long)iSize > e.beginOffset + (long)e.size) continue;
                ++metricReusedPagesBetweenLast;
                e.updateLastUsedTime();
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        lock.writeLock().lock();
        try {
            Iterator<OMMapBufferEntry> it = bufferPoolLRU.iterator();
            while (it.hasNext()) {
                OMMapBufferEntry entry = it.next();
                if (entry.file == null || !entry.file.isClosed() || !OMMapManagerOld.removeEntry(entry)) continue;
                it.remove();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean removeEntry(OMMapBufferEntry entry) {
        if (!entry.flush()) {
            return false;
        }
        entry.acquireLock();
        try {
            List<OMMapBufferEntry> file = bufferPoolPerFile.get(entry.file);
            if (file != null) {
                file.remove(entry);
                if (file.isEmpty()) {
                    bufferPoolPerFile.remove(entry.file);
                }
            }
            entry.close();
            totalMemory -= (long)entry.size;
            boolean bl = true;
            return bl;
        }
        finally {
            entry.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(OFileMMap iFile) {
        lock.writeLock().lock();
        try {
            List<OMMapBufferEntry> entries = bufferPoolPerFile.remove(iFile);
            if (entries != null) {
                for (OMMapBufferEntry entry : entries) {
                    bufferPoolLRU.remove(entry);
                    OMMapManagerOld.removeEntry(entry);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushFile(OFileMMap iFile) {
        lock.readLock().lock();
        try {
            List<OMMapBufferEntry> entries = bufferPoolPerFile.get(iFile);
            boolean allFlushed = true;
            if (entries != null) {
                for (OMMapBufferEntry entry : entries) {
                    if (entry.flush()) continue;
                    allFlushed = false;
                }
            }
            boolean bl = allFlushed;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        lock.writeLock().lock();
        try {
            for (OMMapBufferEntry entry : new ArrayList<OMMapBufferEntry>(bufferPoolLRU)) {
                OMMapManagerOld.removeEntry(entry);
            }
            bufferPoolLRU.clear();
            bufferPoolPerFile.clear();
            totalMemory = 0L;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public long getMaxMemory() {
        return maxMemory;
    }

    public static void setMaxMemory(long iMaxMemory) {
        maxMemory = iMaxMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public int getBlockSize() {
        return blockSize;
    }

    public static void setBlockSize(int blockSize) {
        OMMapManagerOld.blockSize = blockSize;
    }

    public OVERLAP_STRATEGY getOverlapStrategy() {
        return overlapStrategy;
    }

    public static void setOverlapStrategy(int overlapStrategy) {
        OMMapManagerOld.overlapStrategy = OVERLAP_STRATEGY.values()[overlapStrategy];
    }

    public void setOverlapStrategy(OVERLAP_STRATEGY overlapStrategy) {
        OMMapManagerOld.overlapStrategy = overlapStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOverlappedBlocks() {
        lock.readLock().lock();
        try {
            int count = 0;
            for (OFileMMap f : bufferPoolPerFile.keySet()) {
                count += this.getOverlappedBlocks(f);
            }
            int n = count;
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOverlappedBlocks(OFileMMap iFile) {
        lock.readLock().lock();
        try {
            int count = 0;
            List<OMMapBufferEntry> blocks = bufferPoolPerFile.get(iFile);
            long lastPos = -1L;
            for (OMMapBufferEntry block : blocks) {
                if (lastPos > -1L && lastPos > block.beginOffset) {
                    OLogManager.instance().warn(null, "Found overlapped block for file %s at position %d. Previous offset+size was %d", new Object[]{iFile, block.beginOffset, lastPos});
                    ++count;
                }
                lastPos = block.beginOffset + (long)block.size;
            }
            int n = count;
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMMapBufferEntry mapBuffer(OFileMMap iFile, long iBeginOffset, int iSize) throws IOException {
        long timer = Orient.instance().getProfiler().startChrono();
        try {
            OMMapBufferEntry oMMapBufferEntry = new OMMapBufferEntry(iFile, iFile.map(iBeginOffset, iSize), iBeginOffset, iSize);
            return oMMapBufferEntry;
        }
        finally {
            Orient.instance().getProfiler().stopChrono("OMMapManager.loadPage", "Load a memory mapped page in memory", timer);
        }
    }

    private static int searchEntry(List<OMMapBufferEntry> fileEntries, long iBeginOffset, int iSize) {
        if (fileEntries == null || fileEntries.size() == 0) {
            return -1;
        }
        int high = fileEntries.size() - 1;
        if (high < 0) {
            return -1;
        }
        int low = 0;
        int mid = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            OMMapBufferEntry e = fileEntries.get(mid);
            if (iBeginOffset >= e.beginOffset && iBeginOffset + (long)iSize <= e.beginOffset + (long)e.size) {
                ++metricReusedPages;
                e.updateLastUsedTime();
                return mid;
            }
            if (low == high) {
                if (iBeginOffset > e.beginOffset) {
                    ++low;
                }
                return (low + 2) * -1;
            }
            if (iBeginOffset >= e.beginOffset) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return mid;
    }

    private static boolean allocIfOverlaps(long iBeginOffset, int iSize, List<OMMapBufferEntry> fileEntries, int p) {
        if (overlapStrategy == OVERLAP_STRATEGY.OVERLAP) {
            return true;
        }
        boolean overlaps = false;
        OMMapBufferEntry entry = null;
        if (p > 0) {
            entry = fileEntries.get(p - 1);
            boolean bl = overlaps = entry.beginOffset <= iBeginOffset && entry.beginOffset + (long)entry.size >= iBeginOffset;
        }
        if (!overlaps && p < fileEntries.size() - 1) {
            entry = fileEntries.get(p);
            boolean bl = overlaps = iBeginOffset + (long)iSize >= entry.beginOffset;
        }
        if (overlaps) {
            ++metricOverlappedPageUsingChannel;
            if (overlapStrategy == OVERLAP_STRATEGY.NO_OVERLAP_FLUSH_AND_USE_CHANNEL) {
                entry.flush();
            }
            return false;
        }
        return true;
    }

    private static int computeBestEntrySize(OFileMMap iFile, long iBeginOffset, int iSize, boolean iForce, List<OMMapBufferEntry> fileEntries, int p) {
        int bufferSize;
        if (p > -1 && p < fileEntries.size()) {
            bufferSize = (int)(fileEntries.get((int)p).beginOffset - iBeginOffset);
            if (bufferSize < iSize) {
                bufferSize = iSize;
            }
            if (bufferSize < blockSize) {
                bufferSize = blockSize;
            }
        } else {
            int n = iForce ? iSize : (bufferSize = iSize < blockSize ? blockSize : iSize);
            if (iBeginOffset + (long)bufferSize > iFile.getFileSize()) {
                bufferSize = (int)(iFile.getFileSize() - iBeginOffset);
            }
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Invalid range requested for file " + iFile + ". Requested " + iSize + " bytes from the address " + iBeginOffset + " while the total file size is " + iFile.getFileSize());
        }
        return bufferSize;
    }

    static {
        lock = new ReentrantReadWriteLock();
        metricUsedChannel = 0L;
        metricReusedPagesBetweenLast = 0L;
        metricReusedPages = 0L;
        metricOverlappedPageUsingChannel = 0L;
        bufferPoolLRU = new ArrayList<OMMapBufferEntry>();
        bufferPoolPerFile = new HashMap<OFileMMap, List<OMMapBufferEntry>>();
    }

    public static enum OVERLAP_STRATEGY {
        NO_OVERLAP_USE_CHANNEL,
        NO_OVERLAP_FLUSH_AND_USE_CHANNEL,
        OVERLAP;

    }
}

