/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerAbstract;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class OMMapManagerNew
extends OMMapManagerAbstract
implements OMMapManager {
    private static final int BINARY_SEARCH_THRESHOLD = 10;
    private static final OMMapBufferEntry[] EMPTY_BUFFER_ENTRIES = new OMMapBufferEntry[0];
    private final ConcurrentHashMap<OFileMMap, OMMapBufferEntry[]> bufferPoolPerFile = new ConcurrentHashMap();
    private final ConcurrentHashMap<OFileMMap, LastMMapEntrySearchInfo> mapEntrySearchInfo = new ConcurrentHashMap();
    private final OLockManager<OFileMMap, Runnable> lockManager = new OLockManager(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger());
    private long metricMappedPages = 0L;
    private long metricReusedPages = 0L;
    private TimerTask autoFlushTask;
    private int autoFlushUnusedTime;

    @Override
    public void init() {
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.mappedPages", "Number of memory mapped pages used", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMMapManagerNew.this.metricMappedPages;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.reusedPages", "Number of times memory mapped pages have been reused", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMMapManagerNew.this.metricReusedPages;
            }
        });
        int autoFlushTimer = OGlobalConfiguration.FILE_MMAP_AUTOFLUSH_TIMER.getValueAsInteger();
        if (autoFlushTimer > 0) {
            this.autoFlushUnusedTime = OGlobalConfiguration.FILE_MMAP_AUTOFLUSH_UNUSED_TIME.getValueAsInteger() * 1000;
            this.autoFlushTask = new TimerTask(){

                @Override
                public void run() {
                    OMMapManagerNew.this.flush();
                }
            };
            Orient.instance().getTimer().schedule(this.autoFlushTask, autoFlushTimer *= 1000, (long)autoFlushTimer);
        }
    }

    @Override
    public OMMapBufferEntry[] acquire(OFileMMap iFile, long iBeginOffset, int iSize, OMMapManager.OPERATION_TYPE iOperationType, OMMapManager.ALLOC_STRATEGY iStrategy) {
        OMMapBufferEntry[] foundEntries;
        if (iStrategy == OMMapManager.ALLOC_STRATEGY.MMAP_NEVER) {
            return null;
        }
        OMMapBufferEntry[] fileEntries = this.bufferPoolPerFile.get(iFile);
        if (fileEntries == null) {
            fileEntries = EMPTY_BUFFER_ENTRIES;
            this.bufferPoolPerFile.putIfAbsent(iFile, fileEntries);
        }
        if ((foundEntries = this.searchAmongExisting(iFile, fileEntries, iBeginOffset, iSize)).length > 0) {
            OMMapBufferEntry lastEntry = foundEntries[foundEntries.length - 1];
            if (lastEntry.beginOffset + (long)lastEntry.size >= iBeginOffset + (long)iSize) {
                this.acquireLocksOnEntries(foundEntries, iOperationType);
                ++this.metricReusedPages;
                return foundEntries;
            }
        }
        this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.EXCLUSIVE);
        try {
            OMMapBufferEntry newMappedEntry;
            fileEntries = this.bufferPoolPerFile.get(iFile);
            foundEntries = this.searchAmongExisting(iFile, fileEntries, iBeginOffset, iSize);
            long totalMappedSize = 0L;
            if (fileEntries.length > 0) {
                OMMapBufferEntry lastEntry = fileEntries[fileEntries.length - 1];
                totalMappedSize = lastEntry.beginOffset + (long)lastEntry.size;
            }
            try {
                newMappedEntry = this.mapNew(iFile, totalMappedSize);
            }
            catch (IOException ex) {
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.EXCLUSIVE);
                return null;
            }
            OMMapBufferEntry[] newEntries = this.addEntry(fileEntries, newMappedEntry);
            this.bufferPoolPerFile.put(iFile, newEntries);
            OMMapBufferEntry[] resultEntries = this.addEntry(foundEntries, newMappedEntry);
            this.acquireLocksOnEntries(resultEntries, iOperationType);
            OMMapBufferEntry[] oMMapBufferEntryArray = resultEntries;
            return oMMapBufferEntryArray;
        }
        finally {
            this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.EXCLUSIVE);
        }
    }

    @Override
    public void flush() {
        OLogManager.instance().debug((Object)this, "[OMMapManagerNew] flushing pages in memory...", new Object[0]);
        int flushedBlocks = 0;
        int totalBlocks = 0;
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<OFileMMap, OMMapBufferEntry[]>> it = this.bufferPoolPerFile.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<OFileMMap, OMMapBufferEntry[]> mapEntry = it.next();
            OFileMMap file = mapEntry.getKey();
            this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)file, OLockManager.LOCK.EXCLUSIVE);
            try {
                int n;
                if (file.isClosed()) {
                    OMMapBufferEntry[] notFlushed = EMPTY_BUFFER_ENTRIES;
                    OMMapBufferEntry[] oMMapBufferEntryArray = mapEntry.getValue();
                    int n2 = oMMapBufferEntryArray.length;
                    n = 0;
                    while (n < n2) {
                        OMMapBufferEntry entry = oMMapBufferEntryArray[n];
                        ++totalBlocks;
                        if (this.removeEntry(entry)) {
                            ++flushedBlocks;
                        } else {
                            notFlushed = this.addEntry(notFlushed, entry);
                        }
                        ++n;
                    }
                    if (notFlushed.length == 0) {
                        it.remove();
                        continue;
                    }
                    mapEntry.setValue(notFlushed);
                    continue;
                }
                if (this.autoFlushUnusedTime <= 0) continue;
                OMMapBufferEntry[] oMMapBufferEntryArray = mapEntry.getValue();
                n = oMMapBufferEntryArray.length;
                int n3 = 0;
                while (n3 < n) {
                    OMMapBufferEntry entry = oMMapBufferEntryArray[n3];
                    ++totalBlocks;
                    if (entry.isDirty() && (this.autoFlushUnusedTime == 0 || now - entry.getLastUsed() > (long)this.autoFlushUnusedTime)) {
                        ++flushedBlocks;
                        entry.flush();
                    }
                    ++n3;
                }
            }
            finally {
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)file, OLockManager.LOCK.EXCLUSIVE);
            }
        }
        OLogManager.instance().debug((Object)this, "[OMMapManagerNew] flushed %d/%d blocks", new Object[]{flushedBlocks, totalBlocks});
    }

    @Override
    public void shutdown() {
        for (Map.Entry<OFileMMap, OMMapBufferEntry[]> entries : this.bufferPoolPerFile.entrySet()) {
            OFileMMap file = entries.getKey();
            this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)file, OLockManager.LOCK.EXCLUSIVE);
            try {
                this.removeFileEntries(entries.getValue());
            }
            finally {
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)file, OLockManager.LOCK.EXCLUSIVE);
            }
        }
        this.bufferPoolPerFile.clear();
        this.mapEntrySearchInfo.clear();
    }

    private OMMapBufferEntry[] searchAmongExisting(OFileMMap file, OMMapBufferEntry[] fileEntries, long beginOffset, int size) {
        int endSearchPosition;
        int beginSearchPosition;
        if (fileEntries.length == 0) {
            return EMPTY_BUFFER_ENTRIES;
        }
        OMMapBufferEntry lastEntry = fileEntries[fileEntries.length - 1];
        if (lastEntry.beginOffset + (long)lastEntry.size <= beginOffset) {
            return EMPTY_BUFFER_ENTRIES;
        }
        LastMMapEntrySearchInfo entrySearchInfo = this.mapEntrySearchInfo.get(file);
        if (entrySearchInfo == null) {
            beginSearchPosition = 0;
            endSearchPosition = fileEntries.length - 1;
        } else if (entrySearchInfo.requestedPosition <= beginOffset) {
            beginSearchPosition = entrySearchInfo.foundMmapIndex;
            endSearchPosition = fileEntries.length - 1;
        } else {
            beginSearchPosition = 0;
            endSearchPosition = entrySearchInfo.foundMmapIndex;
        }
        int resultFirstPosition = endSearchPosition - beginSearchPosition > 10 ? this.binarySearch(fileEntries, beginOffset, beginSearchPosition, endSearchPosition) : this.linearSearch(fileEntries, beginOffset, beginSearchPosition, endSearchPosition);
        if (beginSearchPosition < 0) {
            return EMPTY_BUFFER_ENTRIES;
        }
        int resultLastPosition = fileEntries.length - 1;
        int i = resultFirstPosition;
        while (i <= resultLastPosition) {
            OMMapBufferEntry entry = fileEntries[i];
            if (entry.beginOffset + (long)entry.size >= beginOffset + (long)size) {
                resultLastPosition = i;
                break;
            }
            ++i;
        }
        int length = resultLastPosition - resultFirstPosition + 1;
        OMMapBufferEntry[] foundEntries = new OMMapBufferEntry[length];
        if (length > 0) {
            System.arraycopy(fileEntries, resultFirstPosition, foundEntries, 0, length);
            this.mapEntrySearchInfo.put(file, new LastMMapEntrySearchInfo(resultFirstPosition, beginOffset));
        }
        return foundEntries;
    }

    private int binarySearch(OMMapBufferEntry[] fileEntries, long beginOffset, int beginPosition, int endPosition) {
        while (beginPosition <= endPosition) {
            int midPosition = beginPosition + endPosition >>> 1;
            OMMapBufferEntry entry = fileEntries[midPosition];
            if (entry.beginOffset + (long)entry.size > beginOffset && entry.beginOffset <= beginOffset) {
                return midPosition;
            }
            if (beginPosition == endPosition) {
                return -1;
            }
            if (beginOffset > entry.beginOffset) {
                beginPosition = midPosition + 1;
                continue;
            }
            endPosition = midPosition;
        }
        return -1;
    }

    private int linearSearch(OMMapBufferEntry[] fileEntries, long beginOffset, int beginPosition, int endPosition) {
        int i = beginPosition;
        while (i <= endPosition) {
            OMMapBufferEntry entry = fileEntries[i];
            if (entry.beginOffset + (long)entry.size > beginOffset && entry.beginOffset <= beginOffset) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private OMMapBufferEntry mapNew(OFileMMap file, long beginOffset) throws IOException {
        ++this.metricMappedPages;
        return new OMMapBufferEntry(file, file.map(beginOffset, (int)(file.getFileSize() - beginOffset)), beginOffset, (int)(file.getFileSize() - beginOffset));
    }

    private OMMapBufferEntry[] addEntry(OMMapBufferEntry[] sourceEntries, OMMapBufferEntry newEntry) {
        OMMapBufferEntry[] newEntries = new OMMapBufferEntry[sourceEntries.length + 1];
        System.arraycopy(sourceEntries, 0, newEntries, 0, sourceEntries.length);
        newEntries[sourceEntries.length] = newEntry;
        return newEntries;
    }

    private void acquireLocksOnEntries(OMMapBufferEntry[] entries, OMMapManager.OPERATION_TYPE operationType) {
        if (operationType == OMMapManager.OPERATION_TYPE.WRITE) {
            OMMapBufferEntry[] oMMapBufferEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                OMMapBufferEntry entry = oMMapBufferEntryArray[n2];
                entry.acquireLock();
                entry.setDirty();
                ++n2;
            }
        } else {
            OMMapBufferEntry[] oMMapBufferEntryArray = entries;
            int n = entries.length;
            int n3 = 0;
            while (n3 < n) {
                OMMapBufferEntry entry = oMMapBufferEntryArray[n3];
                entry.acquireLock();
                ++n3;
            }
        }
    }

    @Override
    public void removeFile(OFileMMap iFile) {
        this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.EXCLUSIVE);
        try {
            this.mapEntrySearchInfo.remove(iFile);
            OMMapBufferEntry[] entries = this.bufferPoolPerFile.remove(iFile);
            this.removeFileEntries(entries);
        }
        finally {
            this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.EXCLUSIVE);
        }
    }

    private void closeEntry(OMMapBufferEntry entry) {
        entry.acquireLock();
        try {
            entry.close();
        }
        finally {
            entry.releaseLock();
        }
    }

    private void removeFileEntries(OMMapBufferEntry[] fileEntries) {
        if (fileEntries != null) {
            OMMapBufferEntry[] oMMapBufferEntryArray = fileEntries;
            int n = fileEntries.length;
            int n2 = 0;
            while (n2 < n) {
                OMMapBufferEntry entry = oMMapBufferEntryArray[n2];
                this.removeEntry(entry);
                ++n2;
            }
        }
    }

    private boolean removeEntry(OMMapBufferEntry entry) {
        if (!entry.flush()) {
            return false;
        }
        this.closeEntry(entry);
        return true;
    }

    @Override
    public boolean flushFile(OFileMMap iFile) {
        this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.SHARED);
        try {
            boolean allFlushed = true;
            OMMapBufferEntry[] fileEntries = this.bufferPoolPerFile.get(iFile);
            if (fileEntries != null) {
                OMMapBufferEntry[] oMMapBufferEntryArray = fileEntries;
                int n = fileEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    OMMapBufferEntry entry = oMMapBufferEntryArray[n2];
                    if (!entry.flush()) {
                        allFlushed = false;
                    }
                    ++n2;
                }
            }
            boolean bl = allFlushed;
            return bl;
        }
        finally {
            this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iFile, OLockManager.LOCK.SHARED);
        }
    }

    private static final class LastMMapEntrySearchInfo {
        private final int foundMmapIndex;
        private final long requestedPosition;

        private LastMMapEntrySearchInfo(int foundMmapIndex, long requestedPosition) {
            this.foundMmapIndex = foundMmapIndex;
            this.requestedPosition = requestedPosition;
        }
    }
}

