/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.factory.ODynamicFactory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.io.IOException;

public class OFileFactory
extends ODynamicFactory<String, Class<? extends OFile>> {
    public static final String MMAP = "mmap";
    public static final String CLASSIC = "classic";
    protected static final OFileFactory instance = new OFileFactory();

    public OFileFactory() {
        this.register(MMAP, OFileMMap.class);
        this.register(CLASSIC, OFileClassic.class);
    }

    public OFile create(String iType, String iFileName, String iOpenMode) throws IOException {
        Class fileClass = (Class)this.registry.get(iType);
        if (fileClass == null) {
            throw new OConfigurationException("File type '" + iType + "' is not configured");
        }
        try {
            OFile f = (OFile)fileClass.newInstance();
            f.init(iFileName, iOpenMode);
            return f;
        }
        catch (Exception e) {
            throw new OConfigurationException("Cannot create file of type '" + iType + "'", e);
        }
    }

    public static OFileFactory instance() {
        return instance;
    }
}

