/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.storage.fs.OAbstractFile;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OFileClassic
extends OAbstractFile {
    public static final String NAME = "classic";
    protected ByteBuffer internalWriteBuffer = ByteBuffer.allocate(8);

    @Override
    public long allocateSpace(long size) throws IOException {
        this.acquireWriteLock();
        try {
            long currentSize = this.getFilledUpTo();
            if (this.maxSize > 0L && currentSize + size > this.maxSize) {
                throw new IllegalArgumentException("Cannot enlarge file since the configured max size (" + OFileUtils.getSizeAsString((long)this.maxSize) + ") was reached! " + this.toString());
            }
            this.size += size;
            long l = currentSize;
            return l;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void shrink(long iSize) throws IOException {
        this.acquireWriteLock();
        try {
            this.channel.truncate(1024L + iSize);
            this.size = iSize;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public long getFileSize() {
        return this.size;
    }

    @Override
    public long getFilledUpTo() {
        return this.size;
    }

    @Override
    public void read(long iOffset, byte[] iData, int iLength, int iArrayOffset) throws IOException {
        this.acquireReadLock();
        try {
            iOffset = this.checkRegions(iOffset, iLength);
            ByteBuffer buffer = ByteBuffer.wrap(iData, iArrayOffset, iLength);
            this.channel.read(buffer, iOffset);
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void write(long iOffset, byte[] iData, int iSize, int iArrayOffset) throws IOException {
        this.acquireWriteLock();
        try {
            this.writeInternal(iOffset, iData, iSize, iArrayOffset);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void writeInternal(long iOffset, byte[] iData, int iSize, int iArrayOffset) throws IOException {
        if (iData != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(iData, iArrayOffset, iSize);
            this.channel.write(byteBuffer, iOffset += 1024L);
            this.setDirty();
        }
    }

    @Override
    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        this.read(iOffset, iDestBuffer, iLenght, 0);
    }

    @Override
    public int readInt(long iOffset) throws IOException {
        this.acquireReadLock();
        try {
            iOffset = this.checkRegions(iOffset, 4L);
            int n = this.readData(iOffset, 4).getInt();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public long readLong(long iOffset) throws IOException {
        this.acquireReadLock();
        try {
            iOffset = this.checkRegions(iOffset, 8L);
            long l = this.readData(iOffset, 8).getLong();
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public short readShort(long iOffset) throws IOException {
        this.acquireReadLock();
        try {
            iOffset = this.checkRegions(iOffset, 2L);
            short s = this.readData(iOffset, 2).getShort();
            return s;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public byte readByte(long iOffset) throws IOException {
        this.acquireReadLock();
        try {
            iOffset = this.checkRegions(iOffset, 1L);
            byte by = this.readData(iOffset, 1).get();
            return by;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void writeInt(long iOffset, int iValue) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = this.getWriteBuffer(4);
            buffer.putInt(iValue);
            this.writeBuffer(buffer, iOffset += 1024L);
            this.setDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void writeLong(long iOffset, long iValue) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = this.getWriteBuffer(8);
            buffer.putLong(iValue);
            this.writeBuffer(buffer, iOffset += 1024L);
            this.setDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void writeShort(long iOffset, short iValue) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = this.getWriteBuffer(2);
            buffer.putShort(iValue);
            this.writeBuffer(buffer, iOffset += 1024L);
            this.setDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void writeByte(long iOffset, byte iValue) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = this.getWriteBuffer(1);
            buffer.put(iValue);
            this.writeBuffer(buffer, iOffset += 1024L);
            this.setDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        this.acquireWriteLock();
        try {
            if (iSourceBuffer != null) {
                this.writeInternal(iOffset, iSourceBuffer, iSourceBuffer.length, 0);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean synch() throws IOException {
        this.acquireWriteLock();
        try {
            this.flushHeader();
            return true;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected void flushHeader() throws IOException {
        this.acquireWriteLock();
        try {
            if (this.headerDirty || this.dirty) {
                this.dirty = false;
                this.headerDirty = false;
                this.channel.force(false);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void create(int iStartSize) throws IOException {
        this.acquireWriteLock();
        try {
            super.create(1024);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected void init() throws IOException {
        this.acquireWriteLock();
        try {
            this.size = this.osFile.length() - 1024L;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected void setFilledUpTo(long value) throws IOException {
        this.setFilledUpTo(value, false);
    }

    @Override
    protected void setFilledUpTo(long iHow, boolean force) {
        this.acquireWriteLock();
        try {
            this.size = iHow;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void setSize(long iSize) throws IOException {
        this.setSize(iSize, false);
    }

    @Override
    protected void setSize(long size, boolean force) throws IOException {
    }

    @Override
    public void writeHeaderLong(int iPosition, long iValue) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = this.getWriteBuffer(8);
            buffer.putLong(iValue);
            this.writeBuffer(buffer, 128 + iPosition);
            this.setHeaderDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public long readHeaderLong(int iPosition) throws IOException {
        this.acquireReadLock();
        try {
            long l = this.readData(128 + iPosition, 8).getLong();
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean isSoftlyClosed() throws IOException {
        this.acquireReadLock();
        try {
            ByteBuffer buffer = this.version == 0 ? this.readData(8L, 1) : this.readData(16L, 1);
            boolean bl = buffer.get(0) > 0;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void setSoftlyClosed(boolean value) throws IOException {
        this.acquireWriteLock();
        try {
            if (this.channel == null || this.mode.indexOf(119) < 0) {
                return;
            }
            ByteBuffer buffer = this.getBuffer(1);
            buffer.put(0, (byte)(value ? 1 : 0));
            this.writeBuffer(buffer, 16L);
            this.channel.force(true);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected long checkRegions(long iOffset, long iLength) {
        this.acquireReadLock();
        try {
            long l = super.checkRegions(iOffset, iLength) + 1024L;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private ByteBuffer readData(long iOffset, int iSize) throws IOException {
        ByteBuffer buffer = this.getBuffer(iSize);
        this.channel.read(buffer, iOffset);
        buffer.rewind();
        return buffer;
    }

    private void writeBuffer(ByteBuffer iBuffer, long iOffset) throws IOException {
        iBuffer.rewind();
        this.channel.write(iBuffer, iOffset);
    }

    private ByteBuffer getBuffer(int iLenght) {
        return ByteBuffer.allocate(iLenght);
    }

    private ByteBuffer getWriteBuffer(int iLenght) {
        this.setDirty();
        if (iLenght <= 8) {
            return (ByteBuffer)this.internalWriteBuffer.rewind();
        }
        return this.getBuffer(iLenght);
    }

    @Override
    protected void setVersion(int version) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = this.getWriteBuffer(1);
            buffer.put((byte)version);
            this.writeBuffer(buffer, 48L);
            this.setHeaderDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }
}

