/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public interface OStorage
extends OSharedContainer {
    public static final String DATA_DEFAULT_NAME = "default";
    public static final String CLUSTER_DEFAULT_NAME = "default";

    public void open(String var1, String var2, Map<String, Object> var3);

    public void create(Map<String, Object> var1);

    public boolean exists();

    public void reload();

    public void delete();

    public void close();

    public void close(boolean var1);

    public boolean isClosed();

    public OLevel2RecordCache getLevel2Cache();

    public OSharedResourceAdaptiveExternal getLock();

    public OStorageOperationResult<OPhysicalPosition> createRecord(int var1, ORecordId var2, byte[] var3, ORecordVersion var4, byte var5, int var6, ORecordCallback<OClusterPosition> var7);

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId var1, String var2, boolean var3, ORecordCallback<ORawBuffer> var4, boolean var5);

    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId var1, byte[] var2, ORecordVersion var3, byte var4, int var5, ORecordCallback<ORecordVersion> var6);

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId var1, ORecordVersion var2, int var3, ORecordCallback<Boolean> var4);

    public boolean updateReplica(int var1, ORecordId var2, byte[] var3, ORecordVersion var4, byte var5) throws IOException;

    public ORecordMetadata getRecordMetadata(ORID var1);

    public boolean cleanOutRecord(ORecordId var1, ORecordVersion var2, int var3, ORecordCallback<Boolean> var4);

    public void commit(OTransaction var1);

    public void rollback(OTransaction var1);

    public OStorageConfiguration getConfiguration();

    public int getClusters();

    public Set<String> getClusterNames();

    public OCluster getClusterById(int var1);

    public Collection<? extends OCluster> getClusterInstances();

    public int addCluster(String var1, String var2, String var3, String var4, boolean var5, Object ... var6);

    public int addCluster(String var1, String var2, int var3, String var4, String var5, boolean var6, Object ... var7);

    public boolean dropCluster(String var1, boolean var2);

    public boolean dropCluster(int var1, boolean var2);

    public int addDataSegment(String var1);

    public int addDataSegment(String var1, String var2);

    public long count(int var1);

    public long count(int var1, boolean var2);

    public long count(int[] var1);

    public long count(int[] var1, boolean var2);

    public long getSize();

    public long countRecords();

    public int getDefaultClusterId();

    public void setDefaultClusterId(int var1);

    public int getClusterIdByName(String var1);

    public String getClusterTypeByName(String var1);

    public String getPhysicalClusterNameById(int var1);

    public boolean checkForRecordValidity(OPhysicalPosition var1);

    public String getName();

    public String getURL();

    public long getVersion();

    public void synch();

    public int getUsers();

    public int addUser();

    public int removeUser();

    public Object command(OCommandRequestText var1);

    public OClusterPosition[] getClusterDataRange(int var1);

    public <V> V callInLock(Callable<V> var1, boolean var2);

    public <V> V callInRecordLock(Callable<V> var1, ORID var2, boolean var3);

    public ODataSegment getDataSegmentById(int var1);

    public int getDataSegmentIdByName(String var1);

    public boolean dropDataSegment(String var1);

    public OPhysicalPosition[] higherPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] lowerPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] ceilingPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] floorPhysicalPositions(int var1, OPhysicalPosition var2);

    public STATUS getStatus();

    public boolean isHashClustersAreUsed();

    public String getType();

    public void checkForClusterPermissions(String var1);

    public static enum CLUSTER_TYPE {
        PHYSICAL,
        MEMORY;

    }

    public static enum SIZE {
        TINY,
        MEDIUM,
        LARGE,
        HUGE;

    }

    public static enum STATUS {
        CLOSED,
        OPEN,
        CLOSING;

    }
}

