/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ORawBuffer
implements Externalizable {
    public byte[] buffer;
    public ORecordVersion version;
    public byte recordType;

    public ORawBuffer() {
        this.version = OVersionFactory.instance().createVersion();
    }

    public ORawBuffer(byte[] buffer, ORecordVersion version, byte recordType) {
        this.buffer = buffer;
        this.version = version.copy();
        this.recordType = recordType;
    }

    public ORawBuffer(ORecordInternal<?> iRecord) {
        this.buffer = iRecord.toStream();
        this.version = iRecord.getRecordVersion().copy();
        this.recordType = iRecord.getRecordType();
    }

    @Override
    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        int bufferLenght = iInput.readInt();
        if (bufferLenght > 0) {
            this.buffer = new byte[bufferLenght];
            int bytesReaded = 0;
            for (int pos = 0; pos < bufferLenght; pos += bytesReaded) {
                bytesReaded = iInput.read(this.buffer, pos, this.buffer.length - pos);
            }
        } else {
            this.buffer = null;
        }
        this.version.getSerializer().readFrom(iInput, this.version);
        this.recordType = iInput.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput iOutput) throws IOException {
        int bufferLenght = this.buffer != null ? this.buffer.length : 0;
        iOutput.writeInt(bufferLenght);
        if (bufferLenght > 0) {
            iOutput.write(this.buffer);
        }
        this.version.getSerializer().writeTo(iOutput, this.version);
        iOutput.write(this.recordType);
    }

    public String toString() {
        return "size:" + (this.buffer != null ? Integer.valueOf(this.buffer.length) : "empty");
    }
}

