/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OSQLSynchQuery<T>
extends OSQLAsynchQuery<T>
implements OCommandResultListener,
Iterable<T> {
    private ORID nextPageRID;
    private final List<T> result = new ArrayList<T>();
    private Map<Object, Object> previousQueryParams = new HashMap<Object, Object>();

    public OSQLSynchQuery() {
        this.resultListener = this;
    }

    public OSQLSynchQuery(String iText) {
        super(iText);
        this.resultListener = this;
    }

    public OSQLSynchQuery(String iText, int iLimit) {
        super(iText, iLimit, null);
        this.resultListener = this;
    }

    @Override
    public void reset() {
        this.result.clear();
    }

    @Override
    public boolean result(Object iRecord) {
        this.result.add(iRecord);
        return true;
    }

    @Override
    public void end() {
    }

    @Override
    public List<T> run(Object ... iArgs) {
        if (!this.result.isEmpty()) {
            this.result.clear();
        }
        Map<Object, Object> queryParams = this.fetchQueryParams(iArgs);
        this.resetNextRIDIfParametersWereChanged(queryParams);
        List res = super.run(iArgs);
        if (res != null && this.result.isEmpty()) {
            for (Object r : res) {
                this.result.add(r);
            }
        }
        if (!this.result.isEmpty()) {
            this.previousQueryParams = new HashMap<Object, Object>(queryParams);
            ORID lastRid = ((OIdentifiable)this.result.get(this.result.size() - 1)).getIdentity();
            this.nextPageRID = new ORecordId(lastRid.next());
        }
        return this.result;
    }

    private void resetNextRIDIfParametersWereChanged(Map<Object, Object> queryParams) {
        if (!queryParams.equals(this.previousQueryParams)) {
            this.nextPageRID = null;
        }
    }

    private Map<Object, Object> fetchQueryParams(Object ... iArgs) {
        if (iArgs != null && iArgs.length > 0) {
            return this.convertToParameters(iArgs);
        }
        Map<Object, Object> queryParams = this.getParameters();
        if (queryParams == null) {
            queryParams = new HashMap<Object, Object>();
        }
        return queryParams;
    }

    public Object getResult() {
        return this.result;
    }

    @Override
    protected OMemoryStream queryToStream() {
        OMemoryStream buffer = super.queryToStream();
        buffer.set(this.nextPageRID != null ? this.nextPageRID.toString() : "");
        byte[] queryParams = this.serializeQueryParameters(this.previousQueryParams);
        buffer.set(queryParams);
        return buffer;
    }

    @Override
    protected void queryFromStream(OMemoryStream buffer) {
        super.queryFromStream(buffer);
        String rid = buffer.getAsString();
        this.nextPageRID = "".equals(rid) ? null : new ORecordId(rid);
        byte[] serializedPrevParams = buffer.getAsByteArray();
        this.previousQueryParams = this.deserializeQueryParameters(serializedPrevParams);
    }

    public ORID getNextPageRID() {
        return this.nextPageRID;
    }

    public void resetPagination() {
        this.nextPageRID = null;
    }

    @Override
    public Iterator<T> iterator() {
        this.execute(new Object[0]);
        return ((Iterable)this.getResult()).iterator();
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }
}

