/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OQueryOperatorContainsValue
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContainsValue() {
        super("CONTAINSVALUE", 5, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        OSQLFilterCondition condition = iCondition.getLeft() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getLeft() : (iCondition.getRight() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getRight() : null);
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            if (condition == null) return map.containsValue(iRight);
            for (Object v : map.values()) {
                Object object = this.loadIfNeed(v);
                if (!((Boolean)condition.evaluate((ORecordSchemaAware)object, null, iContext)).booleanValue()) continue;
                return true;
            }
            return false;
        } else {
            Iterator iterator;
            if (!(iRight instanceof Map)) return false;
            Map map = (Map)iRight;
            if (condition == null || !(iterator = map.values().iterator()).hasNext()) return false;
            Object v = iterator.next();
            Object object = this.loadIfNeed(v);
            if (!((Boolean)condition.evaluate((ORecordSchemaAware)object, null, iContext)).booleanValue()) return map.containsValue(iLeft);
            return true;
        }
    }

    private Object loadIfNeed(Object o) {
        ORecord record = (ORecord)o;
        if (record.getRecord().getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                o = record.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OException("Error during loading record with id : " + record.getIdentity());
            }
        }
        return o;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (!(iRight instanceof OSQLFilterCondition) && !(iLeft instanceof OSQLFilterCondition)) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public Object executeIndexQuery(OCommandContext iContext, OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        Collection<OIdentifiable> result;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            if (!(indexDefinition instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)indexDefinition).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.VALUE) {
                return null;
            }
            Object key = ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0));
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            result = this.convertIndexResult(indexResult);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            if (!(compositeIndexDefinition.getMultiValueDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)compositeIndexDefinition.getMultiValueDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.VALUE) {
                return null;
            }
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            if (internalIndex.hasRangeQuerySupport()) {
                OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
                result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                Object indexResult = index.get(keyOne);
                result = this.convertIndexResult(indexResult);
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return result;
    }

    private Object convertIndexResult(Object indexResult) {
        List<Object> result = indexResult instanceof Collection ? (List)indexResult : (indexResult == null ? Collections.emptyList() : Collections.singletonList((OIdentifiable)indexResult));
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

