/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method.misc;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.ArrayList;
import java.util.Collection;

public class OSQLMethodField
extends OAbstractSQLMethod {
    public static final String NAME = "field";

    public OSQLMethodField() {
        super(NAME, 0, 1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iMethodParams) {
        if (ioResult != null) {
            if (ioResult instanceof String) {
                try {
                    ioResult = new ODocument(new ORecordId((String)ioResult));
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on reading rid with value '%s'", null, new Object[]{ioResult});
                    ioResult = null;
                }
            } else if (ioResult instanceof OIdentifiable) {
                ioResult = ((OIdentifiable)ioResult).getRecord();
            } else if (ioResult instanceof Collection || ioResult instanceof OMultiCollectionIterator || ioResult.getClass().isArray()) {
                ArrayList result = new ArrayList(OMultiValue.getSize((Object)ioResult));
                for (Object o : OMultiValue.getMultiValueIterable((Object)ioResult)) {
                    result.add(ODocumentHelper.getFieldValue(o, iMethodParams[0].toString()));
                }
                return result;
            }
        }
        if (ioResult != null) {
            ioResult = ioResult instanceof OCommandContext ? ((OCommandContext)ioResult).getVariable(iMethodParams[0].toString()) : ODocumentHelper.getFieldValue(ioResult, iMethodParams[0].toString(), iContext);
        }
        return ioResult;
    }
}

