/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method;

import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.method.OSQLMethodFactory;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAppend;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsBoolean;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsDate;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsDateTime;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsDecimal;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsFloat;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsInteger;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsList;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsLong;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsSet;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsString;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodCharAt;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodField;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodFormat;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodFunctionDelegate;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodIndexOf;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodKeys;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodLeft;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodLength;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodNormalize;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodPrefix;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodRemove;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodRemoveAll;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodReplace;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodRight;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodSize;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodSubString;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodToJSON;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodToLowerCase;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodToUpperCase;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodTrim;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodValues;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ODefaultSQLMethodFactory
implements OSQLMethodFactory {
    private final Map<String, Object> methods = new HashMap<String, Object>();

    public ODefaultSQLMethodFactory() {
        this.methods.put("append", new OSQLMethodAppend());
        this.methods.put("asboolean", new OSQLMethodAsBoolean());
        this.methods.put("asdate", new OSQLMethodAsDate());
        this.methods.put("asdatetime", new OSQLMethodAsDateTime());
        this.methods.put("asdecimal", new OSQLMethodAsDecimal());
        this.methods.put("asfloat", new OSQLMethodAsFloat());
        this.methods.put("asinteger", new OSQLMethodAsInteger());
        this.methods.put("aslist", new OSQLMethodAsList());
        this.methods.put("aslong", new OSQLMethodAsLong());
        this.methods.put("asset", new OSQLMethodAsSet());
        this.methods.put("asstring", new OSQLMethodAsString());
        this.methods.put("charat", new OSQLMethodCharAt());
        this.methods.put("field", new OSQLMethodField());
        this.methods.put("format", new OSQLMethodFormat());
        this.methods.put("function", OSQLMethodFunctionDelegate.class);
        this.methods.put("indexof", new OSQLMethodIndexOf());
        this.methods.put("keys", new OSQLMethodKeys());
        this.methods.put("left", new OSQLMethodLeft());
        this.methods.put("length", new OSQLMethodLength());
        this.methods.put("normalize", new OSQLMethodNormalize());
        this.methods.put("prefix", new OSQLMethodPrefix());
        this.methods.put("replace", new OSQLMethodReplace());
        this.methods.put("remove", new OSQLMethodRemove());
        this.methods.put("removeall", new OSQLMethodRemoveAll());
        this.methods.put("right", new OSQLMethodRight());
        this.methods.put("size", new OSQLMethodSize());
        this.methods.put("substring", new OSQLMethodSubString());
        this.methods.put("tojson", new OSQLMethodToJSON());
        this.methods.put("tolowercase", new OSQLMethodToLowerCase());
        this.methods.put("touppercase", new OSQLMethodToUpperCase());
        this.methods.put("trim", new OSQLMethodTrim());
        this.methods.put("values", new OSQLMethodValues());
    }

    @Override
    public boolean hasMethod(String iName) {
        return this.methods.containsKey(iName);
    }

    @Override
    public Set<String> getMethodNames() {
        return this.methods.keySet();
    }

    @Override
    public OSQLMethod createMethod(String name) throws OCommandExecutionException {
        OSQLMethod method;
        Object m = this.methods.get(name);
        if (m instanceof Class) {
            try {
                method = (OSQLMethod)((Class)m).newInstance();
            }
            catch (Exception e) {
                throw new OCommandExecutionException("Cannot create SQL method: " + m);
            }
        } else {
            method = (OSQLMethod)m;
        }
        if (method == null) {
            throw new OCommandExecutionException("Unknown method name: " + name);
        }
        return method;
    }
}

