/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class OSQLFunctionSysdate
extends OSQLFunctionAbstract {
    public static final String NAME = "sysdate";
    private final Date now = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionSysdate() {
        super(NAME, 0, 2);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters.length == 0) {
            return this.now;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat((String)iParameters[0]);
            if (iParameters.length == 2) {
                this.format.setTimeZone(TimeZone.getTimeZone(iParameters[1].toString()));
            } else {
                this.format.setTimeZone(ODateHelper.getDatabaseTimeZone());
            }
        }
        return this.format.format(this.now);
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: sysdate([<format>] [,<timezone>])";
    }

    @Override
    public Object getResult() {
        return null;
    }
}

