/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.List;

public class OSQLFunctionSum
extends OSQLFunctionMathAbstract {
    public static final String NAME = "sum";
    private Number sum;

    public OSQLFunctionSum() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        block4: {
            block2: {
                block3: {
                    if (iParameters.length != 1) break block2;
                    if (!(iParameters[0] instanceof Number)) break block3;
                    this.sum((Number)iParameters[0]);
                    break block4;
                }
                if (!OMultiValue.isMultiValue((Object)iParameters[0])) break block4;
                for (Object n : OMultiValue.getMultiValueIterable((Object)iParameters[0])) {
                    this.sum((Number)n);
                }
                break block4;
            }
            this.sum = null;
            for (int i = 0; i < iParameters.length; ++i) {
                this.sum((Number)iParameters[i]);
            }
        }
        return this.sum;
    }

    protected void sum(Number value) {
        if (value != null) {
            this.sum = this.sum == null ? (Number)value : (Number)OType.increment(this.sum, value);
        }
    }

    @Override
    public boolean aggregateResults() {
        return this.configuredParameters.length == 1;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: sum(<field> [,<field>*])";
    }

    @Override
    public Object getResult() {
        return this.sum;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Number sum = null;
        for (Object iParameter : resultsToMerge) {
            Number value = (Number)iParameter;
            if (value == null) continue;
            if (sum == null) {
                sum = value;
                continue;
            }
            sum = OType.increment(sum, value);
        }
        return sum;
    }
}

