/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OSQLFunctionUnion
extends OSQLFunctionMultiValueAbstract<Set<Object>> {
    public static final String NAME = "union";

    public OSQLFunctionUnion() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters.length == 1) {
            Object value = iParameters[0];
            if (value != null) {
                if (value instanceof OSQLFilterItemVariable) {
                    value = ((OSQLFilterItemVariable)value).getValue(iCurrentRecord, iContext);
                }
                if (this.context == null) {
                    this.context = new HashSet();
                }
                OMultiValue.add((Object)this.context, (Object)value);
            }
            return this.context;
        }
        ArrayList<Collection> result = new ArrayList<Collection>();
        for (Object value : iParameters) {
            if (value == null) continue;
            if (value instanceof OSQLFilterItemVariable) {
                value = ((OSQLFilterItemVariable)value).getValue(iCurrentRecord, iContext);
            }
            result.add((Collection)value);
        }
        return new OMultiCollectionIterator(result);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: union(<field>*)";
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        HashSet result = new HashSet();
        for (Object iParameter : resultsToMerge) {
            Collection items = (Collection)iParameter;
            if (items == null) continue;
            result.addAll(items);
        }
        return result;
    }
}

