/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionMap
extends OSQLFunctionMultiValueAbstract<Map<Object, Object>> {
    public static final String NAME = "map";

    public OSQLFunctionMap() {
        super(NAME, 1, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters.length > 2) {
            this.context = new HashMap();
        }
        if (iParameters.length == 1) {
            if (!(iParameters[0] instanceof Map)) throw new IllegalArgumentException("Map function: expected a map or pairs of parameters as key, value");
            ((Map)this.context).putAll((Map)iParameters[0]);
            return this.prepareResult((Map)this.context);
        } else {
            if (iParameters.length % 2 != 0) {
                throw new IllegalArgumentException("Map function: expected a map or pairs of parameters as key, value");
            }
            for (int i = 0; i < iParameters.length; i += 2) {
                Object key = iParameters[i];
                Object value = iParameters[i + 1];
                if (value == null) continue;
                if (iParameters.length <= 2 && this.context == null) {
                    this.context = new HashMap();
                }
                ((Map)this.context).put(key, value);
            }
        }
        return this.prepareResult((Map)this.context);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: map(<map>|[<key>,<value>]*)";
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return configuredParameters.length <= 2;
    }

    @Override
    public Map<Object, Object> getResult() {
        Map res = (Map)this.context;
        this.context = null;
        return this.prepareResult(res);
    }

    protected Map<Object, Object> prepareResult(Map<Object, Object> res) {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("node", this.getDistributedStorageId());
            doc.put("context", res);
            return Collections.singletonMap("doc", doc);
        }
        return res;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        HashMap<Long, Map> chunks = new HashMap<Long, Map>();
        for (Object iParameter : resultsToMerge) {
            Map container = (Map)((Map)iParameter).get("doc");
            chunks.put((Long)container.get("node"), (Map)container.get("context"));
        }
        HashMap result = new HashMap();
        for (Map chunk : chunks.values()) {
            result.putAll(chunk);
        }
        return result;
    }
}

