/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OSQLFunctionIntersect
extends OSQLFunctionMultiValueAbstract<Set<Object>> {
    public static final String NAME = "intersect";

    public OSQLFunctionIntersect() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        Object value = iParameters[0];
        if (value instanceof OSQLFilterItemVariable) {
            value = ((OSQLFilterItemVariable)value).getValue(iCurrentRecord, iContext);
        }
        if (value == null) {
            return Collections.emptySet();
        }
        if (!(value instanceof Collection)) {
            value = Arrays.asList(value);
        }
        Collection coll = (Collection)value;
        if (iParameters.length == 1) {
            if (this.context == null) {
                this.context = new HashSet(coll);
            } else {
                ((Set)this.context).retainAll(coll);
            }
            return null;
        }
        HashSet result = new HashSet(coll);
        for (int i = 1; i < iParameters.length; ++i) {
            value = iParameters[i];
            if (value instanceof OSQLFilterItemVariable) {
                value = ((OSQLFilterItemVariable)value).getValue(iCurrentRecord, iContext);
            }
            if (value != null) {
                if (!(value instanceof Collection)) {
                    value = Arrays.asList(value);
                }
                result.retainAll((Collection)value);
                continue;
            }
            result.clear();
        }
        return result;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: intersect(<field>*)";
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Collection items;
        HashSet result = new HashSet();
        if (!resultsToMerge.isEmpty() && (items = (Collection)resultsToMerge.get(0)) != null) {
            result.addAll(items);
        }
        for (int i = 1; i < resultsToMerge.size(); ++i) {
            Collection items2 = (Collection)resultsToMerge.get(i);
            if (items2 == null) continue;
            result.retainAll(items2);
        }
        return result;
    }
}

