/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodFunctionDelegate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public abstract class OSQLFilterItemAbstract
implements OSQLFilterItem {
    protected List<OPair<OSQLMethod, Object[]>> operationsChain = null;

    public OSQLFilterItemAbstract(OBaseParser iQueryToParse, String iText) {
        List<String> parts = OStringSerializerHelper.smartSplit(iText, '.', new char[0]);
        this.setRoot(iQueryToParse, parts.get(0));
        if (parts.size() > 1) {
            this.operationsChain = new ArrayList<OPair<OSQLMethod, Object[]>>();
            int i = 1;
            while (i < parts.size()) {
                String part = parts.get(i);
                int pindex = part.indexOf(40);
                if (pindex > -1) {
                    Object[] arguments;
                    String methodName = part.substring(0, pindex).trim().toLowerCase(Locale.ENGLISH);
                    OSQLMethod method = OSQLHelper.getMethodByName(methodName);
                    if (method != null) {
                        if (method.getMaxParams() == -1 || method.getMaxParams() > 0) {
                            arguments = OStringSerializerHelper.getParameters(part).toArray();
                            if (arguments.length < method.getMinParams() || method.getMaxParams() > -1 && arguments.length > method.getMaxParams()) {
                                throw new OQueryParsingException(iQueryToParse.parserText, "Syntax error: field operator '" + method.getName() + "' needs " + (method.getMinParams() == method.getMaxParams() ? Integer.valueOf(method.getMinParams()) : String.valueOf(method.getMinParams()) + "-" + method.getMaxParams()) + " argument(s) while has been received " + arguments.length, 0);
                            }
                        } else {
                            arguments = null;
                        }
                    } else {
                        OSQLFunction f = OSQLEngine.getInstance().getFunction(methodName);
                        if (f == null) {
                            throw new OQueryParsingException(iQueryToParse.parserText, "Syntax error: function or field operator not recognized between the supported ones: " + Arrays.toString(OSQLHelper.getAllMethodNames()), 0);
                        }
                        if (f.getMaxParams() == -1 || f.getMaxParams() > 0) {
                            arguments = OStringSerializerHelper.getParameters(part).toArray();
                            if (arguments.length < f.getMinParams() || f.getMaxParams() > -1 && arguments.length > f.getMaxParams()) {
                                throw new OQueryParsingException(iQueryToParse.parserText, "Syntax error: function '" + f.getName() + "' needs " + (f.getMinParams() == f.getMaxParams() ? Integer.valueOf(f.getMinParams()) : String.valueOf(f.getMinParams()) + "-" + f.getMaxParams()) + " argument(s) while has been received " + arguments.length, 0);
                            }
                        } else {
                            arguments = null;
                        }
                        method = new OSQLMethodFunctionDelegate(f);
                    }
                    this.operationsChain.add((OPair<OSQLMethod, Object[]>)new OPair((Comparable)method, (Object)arguments));
                } else {
                    this.operationsChain.add((OPair<OSQLMethod, Object[]>)new OPair((Comparable)OSQLHelper.getMethodByName("field"), (Object)new Object[]{part}));
                }
                ++i;
            }
        }
    }

    public abstract String getRoot();

    protected abstract void setRoot(OBaseParser var1, String var2);

    public Object transformValue(OIdentifiable iRecord, OCommandContext iContext, Object ioResult) {
        if (ioResult != null && this.operationsChain != null) {
            OSQLMethod operator = null;
            try {
                for (OPair<OSQLMethod, Object[]> op : this.operationsChain) {
                    operator = (OSQLMethod)op.getKey();
                    ioResult = operator.execute(iRecord, iContext, ioResult, (Object[])op.getValue());
                }
            }
            catch (ParseException e) {
                OLogManager.instance().exception("Error on conversion of value '%s' using field operator %s", (Exception)e, OCommandExecutionException.class, new Object[]{ioResult, operator.getName()});
            }
        }
        return ioResult;
    }

    public boolean hasChainOperators() {
        return this.operationsChain != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String root = this.getRoot();
        if (root != null) {
            buffer.append(root);
        }
        if (this.operationsChain != null) {
            for (OPair<OSQLMethod, Object[]> op : this.operationsChain) {
                buffer.append('.');
                buffer.append(op.getKey());
                if (op.getValue() == null) continue;
                Object[] values = (Object[])op.getValue();
                buffer.append('(');
                int i = 0;
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    if (i++ > 0) {
                        buffer.append(',');
                    }
                    buffer.append(v);
                    ++n2;
                }
                buffer.append(')');
            }
        }
        return buffer.toString();
    }
}

