/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerCSVAbstract;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.method.OSQLMethodFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OSQLHelper {
    public static final String NAME = "sql";
    public static final String VALUE_NOT_PARSED = "_NOT_PARSED_";
    public static final String NOT_NULL = "_NOT_NULL_";
    public static final String DEFINED = "_DEFINED_";
    private static ClassLoader orientClassLoader = OSQLFilterItemAbstract.class.getClassLoader();

    public static Object parseValue(String iValue, OCommandContext iContext) {
        if (iValue == null) {
            return null;
        }
        iValue = iValue.trim();
        Object fieldValue = VALUE_NOT_PARSED;
        if (iValue.startsWith("'") && iValue.endsWith("'") || iValue.startsWith("\"") && iValue.endsWith("\"")) {
            fieldValue = OStringSerializerHelper.getStringContent(iValue);
        } else if (iValue.charAt(0) == '[' && iValue.charAt(iValue.length() - 1) == ']') {
            List<String> items = OStringSerializerHelper.smartSplit(iValue.substring(1, iValue.length() - 1), ',', new char[0]);
            ArrayList<Object> coll = new ArrayList<Object>();
            for (String item : items) {
                coll.add(OSQLHelper.parseValue(item, iContext));
            }
            fieldValue = coll;
        } else if (iValue.charAt(0) == '{' && iValue.charAt(iValue.length() - 1) == '}') {
            List<String> items = OStringSerializerHelper.smartSplit(iValue.substring(1, iValue.length() - 1), ',', new char[0]);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (String item : items) {
                List<String> parts = OStringSerializerHelper.smartSplit(item, ':', new char[0]);
                if (parts == null || parts.size() != 2) {
                    throw new OCommandSQLParsingException("Map found but entries are not defined as <key>:<value>");
                }
                map.put(OSQLHelper.parseValue(parts.get(0), iContext), OSQLHelper.parseValue(parts.get(1), iContext));
            }
            fieldValue = map.containsKey("@type") ? new ODocument(map) : map;
        } else if (iValue.charAt(0) == '(' && iValue.charAt(iValue.length() - 1) == ')') {
            fieldValue = new OCommandSQL(iValue.substring(1, iValue.length() - 1));
            ((OCommandSQL)fieldValue).getContext().setParent(iContext);
        } else if (iValue.charAt(0) == '#') {
            fieldValue = new ORecordId(iValue.trim());
        } else {
            String upperCase = iValue.toUpperCase(Locale.ENGLISH);
            if (upperCase.equals("NULL")) {
                fieldValue = null;
            } else if (upperCase.equals("NOT NULL")) {
                fieldValue = NOT_NULL;
            } else if (upperCase.equals("DEFINED")) {
                fieldValue = DEFINED;
            } else if (upperCase.equals("TRUE")) {
                fieldValue = Boolean.TRUE;
            } else if (upperCase.equals("FALSE")) {
                fieldValue = Boolean.FALSE;
            } else {
                Object v = OSQLHelper.parseStringNumber(iValue);
                if (v != null) {
                    fieldValue = v;
                }
            }
        }
        return fieldValue;
    }

    public static Object parseStringNumber(String iValue) {
        OType t = ORecordSerializerCSVAbstract.getType(iValue);
        if (t == OType.INTEGER) {
            return Integer.parseInt(iValue);
        }
        if (t == OType.LONG) {
            return Long.parseLong(iValue);
        }
        if (t == OType.FLOAT) {
            return Float.valueOf(Float.parseFloat(iValue));
        }
        if (t == OType.SHORT) {
            return Short.parseShort(iValue);
        }
        if (t == OType.BYTE) {
            return Byte.parseByte(iValue);
        }
        if (t == OType.DOUBLE) {
            return Double.parseDouble(iValue);
        }
        if (t == OType.DATE || t == OType.DATETIME) {
            return new Date(Long.parseLong(iValue));
        }
        return null;
    }

    public static Object parseValue(OSQLPredicate iSQLFilter, OBaseParser iCommand, String iWord, OCommandContext iContext) {
        if (iWord.charAt(0) == '?' || iWord.charAt(0) == ':') {
            if (iSQLFilter != null) {
                return iSQLFilter.addParameter(iWord);
            }
            return new OSQLFilterItemParameter(iWord);
        }
        return OSQLHelper.parseValue(iCommand, iWord, iContext);
    }

    public static Object parseValue(OBaseParser iCommand, String iWord, OCommandContext iContext) {
        OSQLFunctionRuntime func;
        if (iWord.equals("*")) {
            return "*";
        }
        Object v = OSQLHelper.parseValue(iWord, iContext);
        if (v != VALUE_NOT_PARSED) {
            return v;
        }
        if (!iWord.equalsIgnoreCase("any()") && !iWord.equalsIgnoreCase("all()") && (func = OSQLHelper.getFunction(iCommand, iWord)) != null) {
            return func;
        }
        if (iWord.startsWith("$")) {
            return new OSQLFilterItemVariable(iCommand, iWord);
        }
        return new OSQLFilterItemField(iCommand, iWord);
    }

    public static OSQLFunctionRuntime getFunction(OBaseParser iCommand, String iWord) {
        int endParenthesis;
        int separator = iWord.indexOf(46);
        int beginParenthesis = iWord.indexOf(40);
        if (beginParenthesis > -1 && (separator == -1 || separator > beginParenthesis) && (endParenthesis = iWord.indexOf(41, beginParenthesis)) > -1 && Character.isLetter(iWord.charAt(0))) {
            return new OSQLFunctionRuntime(iCommand, iWord);
        }
        return null;
    }

    public static Object getValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(null, null);
        }
        return iObject;
    }

    public static Object getValue(Object iObject, ORecordInternal<?> iRecord) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(iRecord, null);
        }
        return iObject;
    }

    public static Object getValue(Object iObject, ORecordInternal<?> iRecord, OCommandContext iContext) {
        String s;
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(iRecord, iContext);
        }
        if (iObject instanceof String && !(s = ((String)iObject).trim()).isEmpty() && !OIOUtils.isStringContent((Object)iObject) && !Character.isDigit(s.charAt(0))) {
            return ODocumentHelper.getFieldValue(iRecord, s, iContext);
        }
        return iObject;
    }

    public static Object resolveFieldValue(ODocument iDocument, String iFieldName, Object iFieldValue, OCommandParameters iArguments) {
        if (iFieldValue instanceof OSQLFilterItemField) {
            OSQLFilterItemField f = (OSQLFilterItemField)iFieldValue;
            if (f.getRoot().equals("?")) {
                return iArguments.getNext();
            }
            if (f.getRoot().startsWith(":")) {
                return iArguments.getByName(f.getRoot().substring(1));
            }
        }
        if (iFieldValue instanceof ODocument && !((ODocument)iFieldValue).getIdentity().isValid()) {
            ((ODocument)iFieldValue).addOwner(iDocument);
        }
        return OSQLHelper.getValue(iFieldValue, iDocument);
    }

    public static Set<ODocument> bindParameters(ODocument iDocument, Map<String, Object> iFields, OCommandParameters iArguments, OCommandContext iContext) {
        if (iFields == null) {
            return null;
        }
        HashSet<ODocument> changedDocuments = null;
        for (Map.Entry<String, Object> field : iFields.entrySet()) {
            ODocument doc;
            String fieldName = field.getKey();
            Object fieldValue = field.getValue();
            if (fieldValue != null && fieldValue instanceof OCommandSQL) {
                OProperty prop;
                OCommandSQL cmd = (OCommandSQL)fieldValue;
                cmd.getContext().setParent(iContext);
                fieldValue = ODatabaseRecordThreadLocal.INSTANCE.get().command(cmd).execute(new Object[0]);
                if (iDocument.getSchemaClass() != null && (prop = iDocument.getSchemaClass().getProperty(fieldName)) != null && prop.getType() == OType.LINK && OMultiValue.isMultiValue((Object)fieldValue) && OMultiValue.getSize((Object)fieldValue) == 1) {
                    fieldValue = OMultiValue.getFirstValue((Object)fieldValue);
                }
            }
            if ((doc = iDocument.field(fieldName, OSQLHelper.resolveFieldValue(iDocument, fieldName, fieldValue, iArguments))) == null) continue;
            if (changedDocuments == null) {
                changedDocuments = new HashSet<ODocument>();
            }
            changedDocuments.add(doc);
        }
        return changedDocuments;
    }

    public static String[] getAllMethodNames() {
        ArrayList<String> methods = new ArrayList<String>();
        Iterator ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OSQLMethodFactory.class, (ClassLoader)orientClassLoader);
        while (ite.hasNext()) {
            OSQLMethodFactory factory = (OSQLMethodFactory)ite.next();
            methods.addAll(factory.getMethodNames());
        }
        return methods.toArray(new String[methods.size()]);
    }

    public static OSQLMethod getMethodByName(String name) {
        name = name.toLowerCase();
        Iterator ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OSQLMethodFactory.class, (ClassLoader)orientClassLoader);
        while (ite.hasNext()) {
            OSQLMethodFactory factory = (OSQLMethodFactory)ite.next();
            if (!factory.hasMethod(name)) continue;
            return factory.createMethod(name);
        }
        return null;
    }
}

