/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContains;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsKey;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsValue;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OIndexSearchResult {
    final Map<String, Object> fieldValuePairs = new HashMap<String, Object>(8);
    final OQueryOperator lastOperator;
    final OSQLFilterItemField.FieldChain lastField;
    final Object lastValue;

    OIndexSearchResult(OQueryOperator lastOperator, OSQLFilterItemField.FieldChain field, Object value) {
        this.lastOperator = lastOperator;
        this.lastField = field;
        this.lastValue = value;
    }

    OIndexSearchResult merge(OIndexSearchResult searchResult) {
        OIndexSearchResult result;
        if (searchResult.lastOperator instanceof OQueryOperatorEquals) {
            result = new OIndexSearchResult(this.lastOperator, this.lastField, this.lastValue);
            result.fieldValuePairs.putAll(searchResult.fieldValuePairs);
            result.fieldValuePairs.putAll(this.fieldValuePairs);
            result.fieldValuePairs.put(searchResult.lastField.getItemName(0), searchResult.lastValue);
        } else {
            OQueryOperator operator = searchResult.lastOperator;
            result = new OIndexSearchResult(operator, searchResult.lastField, searchResult.lastValue);
            result.fieldValuePairs.putAll(searchResult.fieldValuePairs);
            result.fieldValuePairs.putAll(this.fieldValuePairs);
            result.fieldValuePairs.put(this.lastField.getItemName(0), this.lastValue);
        }
        return result;
    }

    boolean canBeMerged(OIndexSearchResult searchResult) {
        if (this.lastField.isLong() || searchResult.lastField.isLong()) {
            return false;
        }
        return OIndexSearchResult.isIndexEqualityOperator(this.lastOperator) || OIndexSearchResult.isIndexEqualityOperator(searchResult.lastOperator);
    }

    List<String> fields() {
        ArrayList<String> result = new ArrayList<String>(this.fieldValuePairs.size() + 1);
        result.addAll(this.fieldValuePairs.keySet());
        result.add(this.lastField.getItemName(0));
        return result;
    }

    int getFieldCount() {
        return this.fieldValuePairs.size() + 1;
    }

    public static boolean isIndexEqualityOperator(OQueryOperator queryOperator) {
        return queryOperator instanceof OQueryOperatorEquals || queryOperator instanceof OQueryOperatorContains || queryOperator instanceof OQueryOperatorContainsKey || queryOperator instanceof OQueryOperatorContainsValue;
    }
}

