/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLTraverse
extends OCommandExecutorSQLResultsetAbstract {
    public static final String KEYWORD_WHILE = "WHILE";
    public static final String KEYWORD_TRAVERSE = "TRAVERSE";
    public static final String KEYWORD_STRATEGY = "STRATEGY";
    private OTraverse traverse = new OTraverse();

    @Override
    public OCommandExecutorSQLTraverse parse(OCommandRequest iRequest) {
        super.parse(iRequest);
        int pos = this.parseFields();
        if (pos == -1) {
            throw new OCommandSQLParsingException("Traverse must have the field list. Use " + this.getSyntax());
        }
        int endPosition = this.parserText.length();
        int endP = this.parserTextUpperCase.indexOf(" LIMIT", this.parserGetCurrentPosition());
        if (endP > -1 && endP < endPosition) {
            endPosition = endP;
        }
        this.parsedTarget = OSQLEngine.getInstance().parseTarget(this.parserText.substring(pos, endPosition), this.getContext(), KEYWORD_WHILE);
        if (!this.parsedTarget.parserIsEnded()) {
            this.parserSetCurrentPosition(this.parsedTarget.parserGetCurrentPosition() + pos);
            this.parserNextWord(true);
            if (this.parserGetLastWord().equalsIgnoreCase("WHERE")) {
                this.warnDeprecatedWhere();
            }
            if (this.parserGetLastWord().equalsIgnoreCase("WHERE") || this.parserGetLastWord().equalsIgnoreCase(KEYWORD_WHILE)) {
                this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), KEYWORD_WHILE);
                this.traverse.predicate(this.compiledFilter);
                this.optimize();
                this.parserSetCurrentPosition(this.compiledFilter.parserIsEnded() ? endPosition : this.compiledFilter.parserGetCurrentPosition() + this.parserGetCurrentPosition());
            } else {
                this.parserGoBack();
            }
        } else {
            this.parserSetCurrentPosition(-1);
        }
        this.parserSkipWhiteSpaces();
        if (!this.parserIsEnded() && this.parserOptionalKeyword(new String[]{"LIMIT", "SKIP", "TIMEOUT", KEYWORD_STRATEGY})) {
            String w = this.parserGetLastWord();
            if (w.equals("LIMIT")) {
                this.parseLimit(w);
            } else if (w.equals("SKIP")) {
                this.parseSkip(w);
            } else if (w.equals("TIMEOUT")) {
                this.parseTimeout(w);
            } else if (w.equals(KEYWORD_STRATEGY)) {
                this.parseStrategy(w);
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        this.traverse.limit(this.limit);
        ((OCommandRequestText)iRequest).getContext().setChild(this.traverse.getContext());
        return this;
    }

    protected void warnDeprecatedWhere() {
        OLogManager.instance().warn((Object)this, "Keyword WHERE in traverse has been replaced by WHILE. Please change your query to support WHILE instead of WHERE because now it's only deprecated, but in future it will be removed the back-ward compatibility.", new Object[0]);
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (super.assignTarget(iArgs)) {
            this.traverse.target(this.target);
            return true;
        }
        return false;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (!this.assignTarget(iArgs)) {
            throw new OQueryParsingException("No source found in query: specify class, cluster(s) or single record(s)");
        }
        this.context = this.traverse.getContext();
        this.context.beginExecution(this.timeoutMs, this.timeoutStrategy);
        Object result = this.traverse.execute();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            OIdentifiable r = (OIdentifiable)iterator.next();
            this.handleResult(r, true);
        }
        return this.getResult();
    }

    @Override
    public boolean hasNext() {
        if (this.target == null) {
            this.assignTarget(null);
        }
        return this.traverse.hasNext();
    }

    @Override
    public OCommandContext getContext() {
        return this.traverse.getContext();
    }

    @Override
    public OIdentifiable next() {
        if (this.target == null) {
            this.assignTarget(null);
        }
        return this.traverse.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    public String getSyntax() {
        return "TRAVERSE <field>* FROM <target> [WHILE <condition>] [STRATEGY <strategy>]";
    }

    protected int parseFields() {
        int currentPos = 0;
        StringBuilder word = new StringBuilder();
        currentPos = OCommandExecutorSQLTraverse.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)currentPos, (StringBuilder)word, (boolean)true);
        if (!word.toString().equals(KEYWORD_TRAVERSE)) {
            return -1;
        }
        int fromPosition = this.parserTextUpperCase.indexOf(" FROM ", currentPos);
        if (fromPosition == -1) {
            throw new OQueryParsingException("Missed FROM", this.parserText, currentPos);
        }
        HashSet<Object> fields = new HashSet<Object>();
        String fieldString = this.parserText.substring(currentPos, fromPosition).trim();
        if (fieldString.length() > 0) {
            List<String> items = OStringSerializerHelper.smartSplit(fieldString, ',', new char[0]);
            for (String field : items) {
                String fieldName = field.trim();
                if (fieldName.contains("(")) {
                    fields.add(OSQLHelper.parseValue(null, fieldName, this.context));
                    continue;
                }
                fields.add(fieldName);
            }
        } else {
            throw new OQueryParsingException("Missed field list to cross in TRAVERSE. Use " + this.getSyntax(), this.parserText, currentPos);
        }
        currentPos = fromPosition + "FROM".length() + 1;
        this.traverse.fields(fields);
        return currentPos;
    }

    protected boolean parseStrategy(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_STRATEGY)) {
            return false;
        }
        this.parserNextWord(true);
        String strategyWord = this.parserGetLastWord();
        try {
            this.traverse.setStrategy(OTraverse.STRATEGY.valueOf(strategyWord.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            this.throwParsingException("Invalid STRATEGY. Use one between " + OTraverse.STRATEGY.values());
        }
        return true;
    }
}

