/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

public abstract class OCommandExecutorSQLSetAware
extends OCommandExecutorSQLAbstract {
    protected static final String KEYWORD_SET = "SET";
    protected static final String KEYWORD_CONTENT = "CONTENT";
    protected ODocument content = null;
    protected int parameterCounter = 0;

    protected void parseContent() {
        if (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            String contentAsString = this.parserRequiredWord(false, "Content expected").trim();
            this.content = (ODocument)new ODocument().fromJSON(contentAsString);
            this.parserSkipWhiteSpaces();
        }
        if (this.content == null) {
            this.throwSyntaxErrorException("Content not provided. Example: CONTENT { \"name\": \"Jay\" }");
        }
    }

    protected void parseSetFields(Map<String, Object> fields) {
        while (!(this.parserIsEnded() || fields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            if (fieldName.equalsIgnoreCase("WHERE")) {
                this.parserGoBack();
                break;
            }
            this.parserNextChars(false, true, new String[]{"="});
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            fields.put(fieldName, this.getFieldValueCountingParameters(fieldValue));
            this.parserSkipWhiteSpaces();
        }
        if (fields.size() == 0) {
            this.throwParsingException("Entries to set <field> = <value> are missed. Example: name = 'Bill', salary = 300.2");
        }
    }

    protected Object getFieldValueCountingParameters(String fieldValue) {
        if (fieldValue.trim().equals("?")) {
            ++this.parameterCounter;
        }
        return OSQLHelper.parseValue(this, fieldValue, this.context);
    }
}

