/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OIndexProxy;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.ORuntimeResult;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorAnd;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorOr;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLSelect
extends OCommandExecutorSQLResultsetAbstract {
    private static final String KEYWORD_AS = " AS ";
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_ASC = "ASC";
    public static final String KEYWORD_DESC = "DESC";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_GROUP = "GROUP";
    public static final String KEYWORD_FETCHPLAN = "FETCHPLAN";
    private static final int MIN_THRESHOLD_USE_INDEX_AS_TARGET = 100;
    private Map<String, String> projectionDefinition = null;
    private Map<String, Object> projections = null;
    private List<OPair<String, String>> orderedFields;
    private List<String> groupByFields;
    private Map<Object, ORuntimeResult> groupedResult;
    private Object expandTarget;
    private int fetchLimit = -1;
    private OIdentifiable lastRecord;
    private Iterator<OIdentifiable> subIterator;
    private String fetchPlan;

    @Override
    public OCommandExecutorSQLSelect parse(OCommandRequest iRequest) {
        int pos;
        super.parse(iRequest);
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        if ((pos = this.parseProjections()) == -1) {
            return this;
        }
        int endPosition = this.parserText.length();
        this.parserNextWord(true);
        if (this.parserGetLastWord().equalsIgnoreCase("FROM")) {
            this.parsedTarget = OSQLEngine.getInstance().parseTarget(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), "WHERE");
            this.parserSetCurrentPosition(this.parsedTarget.parserIsEnded() ? endPosition : this.parsedTarget.parserGetCurrentPosition() + this.parserGetCurrentPosition());
        } else {
            this.parserGoBack();
        }
        if (!this.parserIsEnded()) {
            this.parserSkipWhiteSpaces();
            while (!this.parserIsEnded()) {
                this.parserNextWord(true);
                if (this.parserIsEnded()) continue;
                String w = this.parserGetLastWord();
                if (w.equals("WHERE")) {
                    this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), "WHERE");
                    this.optimize();
                    this.parserSetCurrentPosition(this.compiledFilter.parserIsEnded() ? endPosition : this.compiledFilter.parserGetCurrentPosition() + this.parserGetCurrentPosition());
                    continue;
                }
                if (w.equals("LET")) {
                    this.parseLet();
                    continue;
                }
                if (w.equals(KEYWORD_GROUP)) {
                    this.parseGroupBy(w);
                    continue;
                }
                if (w.equals(KEYWORD_ORDER)) {
                    this.parseOrderBy(w);
                    continue;
                }
                if (w.equals("LIMIT")) {
                    this.parseLimit(w);
                    continue;
                }
                if (w.equals("SKIP")) {
                    this.parseSkip(w);
                    continue;
                }
                if (w.equals(KEYWORD_FETCHPLAN)) {
                    this.parseFetchplan(w);
                    continue;
                }
                if (w.equals("TIMEOUT")) {
                    this.parseTimeout(w);
                    continue;
                }
                this.throwParsingException("Invalid keyword '" + w + "'");
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        return this;
    }

    public Set<Integer> getInvolvedClusters() {
        HashSet<Integer> clusters = new HashSet<Integer>();
        if (this.parsedTarget.getTargetRecords() != null) {
            for (OIdentifiable oIdentifiable : this.parsedTarget.getTargetRecords()) {
                clusters.add(oIdentifiable.getIdentity().getClusterId());
            }
        }
        if (this.parsedTarget.getTargetClasses() != null) {
            OStorage oStorage = OCommandExecutorSQLSelect.getDatabase().getStorage();
            for (String clazz : this.parsedTarget.getTargetClasses().values()) {
                clusters.add(oStorage.getClusterIdByName(clazz));
            }
        }
        if (this.parsedTarget.getTargetClusters() != null) {
            OStorage oStorage = OCommandExecutorSQLSelect.getDatabase().getStorage();
            for (String clazz : this.parsedTarget.getTargetClusters().values()) {
                clusters.add(oStorage.getClusterIdByName(clazz));
            }
        }
        this.parsedTarget.getTargetIndex();
        return clusters;
    }

    public OCommandExecutorSQLSelect boundToLocalNode(long fromId, long toId) {
        OSQLFilterCondition rootCondition;
        if (fromId == toId) {
            return this;
        }
        OSQLFilterCondition nodeCondition = fromId < toId ? OCommandExecutorSQLSelect.getConditionForRidPosRange(fromId, toId) : new OSQLFilterCondition(OCommandExecutorSQLSelect.getConditionForRidPosRange(fromId, Long.MAX_VALUE), new OQueryOperatorOr(), OCommandExecutorSQLSelect.getConditionForRidPosRange(-1L, toId));
        if (this.compiledFilter == null) {
            this.compiledFilter = OSQLEngine.getInstance().parseCondition("", this.getContext(), "WHERE");
        }
        if ((rootCondition = this.compiledFilter.getRootCondition()) != null) {
            this.compiledFilter.setRootCondition(new OSQLFilterCondition(nodeCondition, new OQueryOperatorAnd(), rootCondition));
        } else {
            this.compiledFilter.setRootCondition(nodeCondition);
        }
        return this;
    }

    protected static OSQLFilterCondition getConditionForRidPosRange(long fromId, long toId) {
        OSQLFilterCondition fromCondition = new OSQLFilterCondition(new OSQLFilterItemField(null, "@rid_pos"), new OQueryOperatorMajor(), fromId);
        OSQLFilterCondition toCondition = new OSQLFilterCondition(new OSQLFilterItemField(null, "@rid_pos"), new OQueryOperatorMinorEquals(), toId);
        return new OSQLFilterCondition(fromCondition, new OQueryOperatorAnd(), toCondition);
    }

    public boolean isAnyFunctionAggregates() {
        return this.groupedResult != null;
    }

    @Override
    public boolean hasNext() {
        if (this.lastRecord == null) {
            this.lastRecord = this.next();
        }
        return this.lastRecord != null;
    }

    @Override
    public OIdentifiable next() {
        if (this.lastRecord != null) {
            OIdentifiable result = this.lastRecord;
            this.lastRecord = null;
            return result;
        }
        if (this.subIterator == null) {
            if (this.target == null) {
                this.executeSearch(null);
                this.applyExpand();
                this.handleNoTarget();
                this.handleGroupBy();
                this.applyOrderBy();
                this.subIterator = new ArrayList((List)this.getResult()).iterator();
                this.lastRecord = null;
                this.tempResult = null;
                this.groupedResult = null;
            } else {
                this.subIterator = this.target;
            }
        }
        if (this.lastRecord == null && this.subIterator != null) {
            while (this.subIterator.hasNext()) {
                this.lastRecord = this.subIterator.next();
                if (this.lastRecord == null) continue;
                return this.lastRecord;
            }
        }
        return this.lastRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (iArgs != null) {
            for (Map.Entry<Object, Object> arg : iArgs.entrySet()) {
                this.context.setVariable(arg.getKey().toString(), arg.getValue());
            }
        }
        if (this.timeoutMs > 0L) {
            this.getContext().beginExecution(this.timeoutMs, this.timeoutStrategy);
        }
        if (!this.optimizeExecution()) {
            this.fetchLimit = this.getQueryFetchLimit();
            this.executeSearch(iArgs);
            this.applyExpand();
            this.handleNoTarget();
            this.handleGroupBy();
            this.applyOrderBy();
            this.applyLimitAndSkip();
        }
        return this.getResult();
    }

    /*
     * Unable to fully structure code
     */
    protected void executeSearch(Map<Object, Object> iArgs) {
        this.assignTarget(iArgs);
        if (this.target != null) ** GOTO lbl-1000
        if (this.let != null) {
            this.assignLetClauses(this.lastRecord != null ? (ORecord<?>)this.lastRecord.getRecord() : null);
        }
        return;
        while (this.executeSearchRecord((OIdentifiable)this.target.next())) lbl-1000:
        // 2 sources

        {
            if (this.target.hasNext()) continue;
        }
        if (this.request.getResultListener() != null) {
            this.request.getResultListener().end();
        }
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (!super.assignTarget(iArgs)) {
            if (this.parsedTarget.getTargetIndex() != null) {
                this.searchInIndex();
            } else {
                throw new OQueryParsingException("No source found in query: specify class, cluster(s), index or single record(s). Use " + this.getSyntax());
            }
        }
        return true;
    }

    protected boolean executeSearchRecord(OIdentifiable id) {
        if (Thread.interrupted()) {
            throw new OCommandExecutionException("The select execution has been interrupted");
        }
        if (!this.context.checkTimeout()) {
            return false;
        }
        ORecordInternal record = (ORecordInternal)id.getRecord();
        this.context.updateMetric("recordReads", 1L);
        if (record == null || record.getRecordType() != 100) {
            return true;
        }
        this.context.updateMetric("documentReads", 1L);
        return !this.filter(record) || this.handleResult(record, true);
    }

    @Override
    protected boolean handleResult(OIdentifiable iRecord, boolean iCloneIt) {
        this.lastRecord = null;
        if (this.orderedFields == null && this.skip > 0) {
            --this.skip;
            return true;
        }
        this.lastRecord = iCloneIt ? (iRecord instanceof ORecord ? ((ORecord)iRecord).copy() : iRecord.getIdentity().copy()) : iRecord;
        ++this.resultCount;
        this.addResult(this.lastRecord);
        return this.orderedFields != null || this.fetchLimit <= -1 || this.resultCount < this.fetchLimit;
    }

    protected void addResult(OIdentifiable iRecord) {
        if (iRecord == null) {
            return;
        }
        if (this.projections != null || this.groupByFields != null && !this.groupByFields.isEmpty()) {
            if (this.groupedResult == null) {
                if ((iRecord = ORuntimeResult.getProjectionResult(this.resultCount, this.projections, this.context, iRecord)) == null) {
                    return;
                }
            } else {
                ODocument doc = (ODocument)iRecord.getRecord();
                Object fieldValue = null;
                if (this.groupByFields != null && !this.groupByFields.isEmpty()) {
                    if (this.groupByFields.size() > 1) {
                        Object[] fields = new Object[this.groupByFields.size()];
                        int i = 0;
                        while (i < this.groupByFields.size()) {
                            String field = this.groupByFields.get(i);
                            fields[i] = field.startsWith("$") ? this.context.getVariable(field) : doc.field(field);
                            ++i;
                        }
                        fieldValue = fields;
                    } else {
                        String field = this.groupByFields.get(0);
                        if (field != null) {
                            fieldValue = field.startsWith("$") ? this.context.getVariable(field) : doc.field(field);
                        }
                    }
                }
                this.getProjectionGroup(fieldValue).applyRecord(iRecord);
                return;
            }
        }
        if (this.orderedFields == null && this.expandTarget == null) {
            if (this.request.getResultListener() != null) {
                this.request.getResultListener().result(iRecord);
            }
        } else {
            if (this.tempResult == null) {
                this.tempResult = new ArrayList();
            }
            ((Collection)this.tempResult).add(iRecord);
        }
    }

    protected ORuntimeResult getProjectionGroup(Object fieldValue) {
        ORuntimeResult group = null;
        if (this.groupedResult == null) {
            this.groupedResult = new LinkedHashMap<Object, ORuntimeResult>();
        } else if (fieldValue != null && fieldValue.getClass().isArray()) {
            int arraySize = Array.getLength(fieldValue);
            for (Map.Entry<Object, ORuntimeResult> entry : this.groupedResult.entrySet()) {
                Object k = entry.getKey();
                boolean same = false;
                if (k != null && k.getClass().isArray() && Array.getLength(k) == arraySize) {
                    same = true;
                    int i = 0;
                    while (i < arraySize) {
                        Object o1 = Array.get(k, i);
                        Object o2 = Array.get(fieldValue, i);
                        if (o1 == null && o2 != null || o1 != null && o2 == null || o1 != null && !o1.equals(o2)) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (!same) continue;
                group = entry.getValue();
            }
        } else {
            group = this.groupedResult.get(fieldValue);
        }
        if (group == null) {
            group = new ORuntimeResult(this.createProjectionFromDefinition(), this.resultCount, this.context);
            this.groupedResult.put(fieldValue, group);
        }
        return group;
    }

    private int getQueryFetchLimit() {
        if (this.orderedFields != null) {
            return -1;
        }
        int sqlLimit = this.limit > -1 ? this.limit : -1;
        int requestLimit = this.request.getLimit() > -1 ? this.request.getLimit() : -1;
        if (sqlLimit == -1) {
            return requestLimit;
        }
        if (requestLimit == -1) {
            return sqlLimit;
        }
        return Math.min(sqlLimit, requestLimit);
    }

    public Map<String, Object> getProjections() {
        return this.projections;
    }

    public List<OPair<String, String>> getOrderedFields() {
        return this.orderedFields;
    }

    protected void parseGroupBy(String w) {
        this.parserRequiredKeyword(new String[]{KEYWORD_BY});
        this.groupByFields = new ArrayList<String>();
        while (!(this.parserIsEnded() || this.groupByFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.groupByFields.add(fieldName);
            this.parserSkipWhiteSpaces();
        }
        if (this.groupByFields.size() == 0) {
            this.throwParsingException("Group by field set was missed. Example: GROUP BY name, salary");
        }
        this.getProjectionGroup(null);
    }

    protected void parseOrderBy(String w) {
        this.parserRequiredKeyword(new String[]{KEYWORD_BY});
        String fieldOrdering = null;
        this.orderedFields = new ArrayList<OPair<String, String>>();
        while (!(this.parserIsEnded() || this.orderedFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserOptionalWord(true);
            String word = this.parserGetLastWord();
            if (word.length() == 0) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals("LIMIT")) {
                fieldOrdering = KEYWORD_ASC;
                this.parserGoBack();
            } else if (word.equals(KEYWORD_ASC)) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals(KEYWORD_DESC)) {
                fieldOrdering = KEYWORD_DESC;
            } else {
                this.throwParsingException("Ordering mode '" + word + "' not supported. Valid is 'ASC', 'DESC' or nothing ('ASC' by default)");
            }
            this.orderedFields.add((OPair<String, String>)new OPair((Comparable)((Object)fieldName), (Object)fieldOrdering));
            this.parserSkipWhiteSpaces();
        }
        if (this.orderedFields.size() == 0) {
            this.throwParsingException("Order by field set was missed. Example: ORDER BY name ASC, salary DESC");
        }
    }

    @Override
    protected void searchInClasses() {
        OClass cls = this.parsedTarget.getTargetClasses().keySet().iterator().next();
        if (!this.searchForIndexes(cls)) {
            super.searchInClasses();
        }
    }

    private boolean searchForIndexes(OClass iSchemaClass) {
        ODatabaseRecord database = OCommandExecutorSQLSelect.getDatabase();
        database.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iSchemaClass.getName().toLowerCase());
        ArrayList<OIndexSearchResult> indexSearchResults = new ArrayList<OIndexSearchResult>();
        if (this.compiledFilter == null) {
            return false;
        }
        OCommandExecutorSQLSelect.analyzeQueryBranch(iSchemaClass, this.compiledFilter.getRootCondition(), indexSearchResults);
        Collections.sort(indexSearchResults, new Comparator<OIndexSearchResult>(){

            @Override
            public int compare(OIndexSearchResult searchResultOne, OIndexSearchResult searchResultTwo) {
                return searchResultTwo.getFieldCount() - searchResultOne.getFieldCount();
            }
        });
        for (OIndexSearchResult searchResult : indexSearchResults) {
            List<OIndex<?>> involvedIndexes = OCommandExecutorSQLSelect.getInvolvedIndexes(iSchemaClass, searchResult);
            Collections.sort(involvedIndexes, IndexComparator.INSTANCE);
            for (OIndex<?> index : involvedIndexes) {
                Object result;
                Object v;
                String relatedIndexField;
                String lastFiled;
                if (index.isRebuiding()) continue;
                OIndexDefinition indexDefinition = index.getDefinition();
                OQueryOperator operator = searchResult.lastOperator;
                if (!OIndexSearchResult.isIndexEqualityOperator(operator) && !(lastFiled = searchResult.lastField.getItemName(searchResult.lastField.getItemCount() - 1)).equals(relatedIndexField = indexDefinition.getFields().get(searchResult.fieldValuePairs.size()))) continue;
                int searchResultFieldsCount = searchResult.fields().size();
                ArrayList<Object> keyParams = new ArrayList<Object>(searchResultFieldsCount);
                for (String fieldName : indexDefinition.getFields().subList(0, searchResultFieldsCount)) {
                    Object fieldValue = searchResult.fieldValuePairs.get(fieldName);
                    if (fieldValue != null) {
                        keyParams.add(fieldValue);
                        continue;
                    }
                    keyParams.add(searchResult.lastValue);
                }
                OQueryOperator.INDEX_OPERATION_TYPE opType = null;
                if (this.context.isRecordingMetrics()) {
                    HashSet<String> idxNames = (HashSet<String>)this.context.getVariable("involvedIndexes");
                    if (idxNames == null) {
                        idxNames = new HashSet<String>();
                        this.context.setVariable("involvedIndexes", idxNames);
                    }
                    idxNames.add(index.getName());
                }
                if (this.projections != null && this.projections.size() == 1 && (v = this.projections.values().iterator().next()) instanceof OSQLFunctionRuntime && ((OSQLFunctionRuntime)v).getFunction() instanceof OSQLFunctionCount && !(this.compiledFilter.getRootCondition().getLeft() instanceof OSQLFilterCondition) && !(this.compiledFilter.getRootCondition().getRight() instanceof OSQLFilterCondition)) {
                    opType = OQueryOperator.INDEX_OPERATION_TYPE.COUNT;
                }
                if (opType == null) {
                    opType = OQueryOperator.INDEX_OPERATION_TYPE.GET;
                }
                if ((result = operator.executeIndexQuery(this.context, index, opType, keyParams, this.fetchLimit)) == null) continue;
                if (opType == OQueryOperator.INDEX_OPERATION_TYPE.COUNT) {
                    String projName = this.projectionDefinition.keySet().iterator().next();
                    this.projectionDefinition.clear();
                    this.getProjectionGroup(null).applyValue(projName, result);
                } else {
                    this.fillSearchIndexResultSet(result);
                }
                return true;
            }
        }
        return false;
    }

    private static List<OIndex<?>> getInvolvedIndexes(OClass iSchemaClass, OIndexSearchResult searchResultFields) {
        Set<OIndex<?>> involvedIndexes = iSchemaClass.getInvolvedIndexes(searchResultFields.fields());
        ArrayList result = new ArrayList(involvedIndexes.size());
        for (OIndex<?> involvedIndex : involvedIndexes) {
            if (searchResultFields.lastField.isLong()) {
                result.addAll(OIndexProxy.createdProxy(involvedIndex, searchResultFields.lastField, OCommandExecutorSQLSelect.getDatabase()));
                continue;
            }
            result.add(involvedIndex);
        }
        return result;
    }

    private static OIndexSearchResult analyzeQueryBranch(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults) {
        if (iCondition == null) {
            return null;
        }
        OQueryOperator operator = iCondition.getOperator();
        while (operator == null) {
            if (iCondition.getRight() == null && iCondition.getLeft() instanceof OSQLFilterCondition) {
                iCondition = (OSQLFilterCondition)iCondition.getLeft();
                operator = iCondition.getOperator();
                continue;
            }
            return null;
        }
        OIndexReuseType indexReuseType = operator.getIndexReuseType(iCondition.getLeft(), iCondition.getRight());
        if (indexReuseType.equals((Object)OIndexReuseType.INDEX_INTERSECTION)) {
            OIndexSearchResult leftResult = OCommandExecutorSQLSelect.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getLeft(), iIndexSearchResults);
            OIndexSearchResult rightResult = OCommandExecutorSQLSelect.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getRight(), iIndexSearchResults);
            if (leftResult != null && rightResult != null && leftResult.canBeMerged(rightResult)) {
                OIndexSearchResult mergeResult = leftResult.merge(rightResult);
                if (iSchemaClass.areIndexed(mergeResult.fields())) {
                    iIndexSearchResults.add(mergeResult);
                }
                return leftResult.merge(rightResult);
            }
            return null;
        }
        if (indexReuseType.equals((Object)OIndexReuseType.INDEX_METHOD)) {
            OIndexSearchResult result = OCommandExecutorSQLSelect.createIndexedProperty(iCondition, iCondition.getLeft());
            if (result == null) {
                result = OCommandExecutorSQLSelect.createIndexedProperty(iCondition, iCondition.getRight());
            }
            if (result == null) {
                return null;
            }
            if (OCommandExecutorSQLSelect.checkIndexExistence(iSchemaClass, result)) {
                iIndexSearchResults.add(result);
            }
            return result;
        }
        return null;
    }

    private static OIndexSearchResult createIndexedProperty(OSQLFilterCondition iCondition, Object iItem) {
        Object origValue;
        if (iItem == null || !(iItem instanceof OSQLFilterItemField)) {
            return null;
        }
        if (iCondition.getLeft() instanceof OSQLFilterItemField && iCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        OSQLFilterItemField item = (OSQLFilterItemField)iItem;
        if (item.hasChainOperators() && !item.isFieldChain()) {
            return null;
        }
        Object object = origValue = iCondition.getLeft() == iItem ? iCondition.getRight() : iCondition.getLeft();
        if (iCondition.getOperator() instanceof OQueryOperatorBetween || iCondition.getOperator() instanceof OQueryOperatorIn) {
            return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), origValue);
        }
        Object value = OSQLHelper.getValue(origValue);
        if (value == null) {
            return null;
        }
        return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), value);
    }

    private void fillSearchIndexResultSet(Object indexResult) {
        if (indexResult != null) {
            if (indexResult instanceof Collection) {
                Collection indexResultSet = (Collection)indexResult;
                this.context.updateMetric("indexReads", indexResultSet.size());
                for (OIdentifiable identifiable : indexResultSet) {
                    boolean continueResultParsing;
                    Object record = identifiable.getRecord();
                    if (record == null || !this.filter((ORecordInternal)record) || (continueResultParsing = this.handleResult((OIdentifiable)record, false))) {
                        continue;
                    }
                    break;
                }
            } else {
                Object record = ((OIdentifiable)indexResult).getRecord();
                if (this.filter((ORecordInternal)record)) {
                    this.handleResult((OIdentifiable)record, true);
                }
            }
        }
    }

    protected int parseProjections() {
        String projectionString;
        if (!this.parserOptionalKeyword(new String[]{KEYWORD_SELECT})) {
            return -1;
        }
        int upperBound = OStringSerializerHelper.getLowerIndexOf(this.parserTextUpperCase, this.parserGetCurrentPosition(), " FROM ", " LET ");
        if (upperBound == -1) {
            upperBound = this.parserText.length();
        }
        if ((projectionString = this.parserText.substring(this.parserGetCurrentPosition(), upperBound).trim()).length() > 0) {
            this.projections = new LinkedHashMap<String, Object>();
            this.projectionDefinition = new LinkedHashMap<String, String>();
            List<String> items = OStringSerializerHelper.smartSplit(projectionString, ',', new char[0]);
            for (String projection : items) {
                String p;
                projection = projection.trim();
                if (this.projectionDefinition == null) {
                    throw new OCommandSQLParsingException("Projection not allowed with FLATTEN() and EXPAND() operators");
                }
                String fieldName = null;
                int endPos = projection.toUpperCase(Locale.ENGLISH).indexOf(KEYWORD_AS);
                if (endPos > -1) {
                    fieldName = projection.substring(endPos + KEYWORD_AS.length()).trim();
                    projection = projection.substring(0, endPos).trim();
                    if (this.projectionDefinition.containsKey(fieldName)) {
                        throw new OCommandSQLParsingException("Field '" + fieldName + "' is duplicated in current SELECT, choose a different name");
                    }
                } else {
                    int beginPos = projection.charAt(0) == '@' ? 1 : 0;
                    endPos = this.extractProjectionNameSubstringEndPosition(projection);
                    fieldName = endPos > -1 ? projection.substring(beginPos, endPos) : projection.substring(beginPos);
                    fieldName = OStringSerializerHelper.getStringContent(fieldName);
                    int fieldIndex = 2;
                    while (this.projectionDefinition.containsKey(fieldName)) {
                        fieldName = String.valueOf(fieldName) + fieldIndex;
                        ++fieldIndex;
                    }
                }
                if ((p = projection.toUpperCase(Locale.ENGLISH)).startsWith("FLATTEN(") || p.startsWith("EXPAND(")) {
                    List<String> pars;
                    if (p.startsWith("FLATTEN(")) {
                        OLogManager.instance().debug((Object)this, "FLATTEN() operator has been replaced by EXPAND()", new Object[0]);
                    }
                    if ((pars = OStringSerializerHelper.getParameters(projection)).size() != 1) {
                        throw new OCommandSQLParsingException("EXPAND/FLATTEN operators expects the field name as parameter. Example EXPAND( out )");
                    }
                    this.expandTarget = OSQLHelper.parseValue(this, pars.get(0).trim(), this.context);
                    this.projectionDefinition = null;
                    this.projections = null;
                    if (this.groupedResult != null || !(this.expandTarget instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)this.expandTarget).aggregateResults()) continue;
                    this.getProjectionGroup(null);
                    continue;
                }
                this.projectionDefinition.put(fieldName, projection);
            }
            if (!(this.projectionDefinition == null || this.projectionDefinition.size() <= 1 && this.projectionDefinition.values().iterator().next().equals("*"))) {
                this.projections = this.createProjectionFromDefinition();
                for (Object p : this.projections.values()) {
                    if (this.groupedResult != null || !(p instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)p).aggregateResults()) continue;
                    this.getProjectionGroup(null);
                    break;
                }
            } else {
                this.projectionDefinition = null;
                this.projections = null;
            }
        }
        if (upperBound < this.parserText.length() - 1) {
            this.parserSetCurrentPosition(upperBound);
        } else {
            this.parserSetEndOfText();
        }
        return this.parserGetCurrentPosition();
    }

    protected Map<String, Object> createProjectionFromDefinition() {
        if (this.projectionDefinition == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> projections = new LinkedHashMap<String, Object>(this.projectionDefinition.size());
        for (Map.Entry<String, String> p : this.projectionDefinition.entrySet()) {
            Object projectionValue = OSQLHelper.parseValue(this, p.getValue(), this.context);
            projections.put(p.getKey(), projectionValue);
        }
        return projections;
    }

    protected int extractProjectionNameSubstringEndPosition(String projection) {
        int endPos;
        int pos1 = projection.indexOf(46);
        int pos2 = projection.indexOf(40);
        int pos3 = projection.indexOf(91);
        if (pos1 > -1 && pos2 == -1 && pos3 == -1) {
            endPos = pos1;
        } else if (pos2 > -1 && pos1 == -1 && pos3 == -1) {
            endPos = pos2;
        } else if (pos3 > -1 && pos1 == -1 && pos2 == -1) {
            endPos = pos3;
        } else if (pos1 > -1 && pos2 > -1 && pos3 == -1) {
            endPos = Math.min(pos1, pos2);
        } else if (pos2 > -1 && pos3 > -1 && pos1 == -1) {
            endPos = Math.min(pos2, pos3);
        } else if (pos1 > -1 && pos3 > -1 && pos2 == -1) {
            endPos = Math.min(pos1, pos3);
        } else if (pos1 > -1 && pos2 > -1 && pos3 > -1) {
            endPos = Math.min(pos1, pos2);
            endPos = Math.min(endPos, pos3);
        } else {
            endPos = -1;
        }
        return endPos;
    }

    private void applyOrderBy() {
        if (this.orderedFields == null) {
            return;
        }
        if (this.tempResult instanceof OMultiCollectionIterator) {
            ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
            for (OIdentifiable o : this.tempResult) {
                list.add(o);
            }
            this.tempResult = list;
        }
        ODocumentHelper.sort((List)this.tempResult, this.orderedFields);
        this.orderedFields.clear();
    }

    private void applyExpand() {
        if (this.expandTarget == null) {
            return;
        }
        if (this.tempResult == null) {
            Object r;
            this.tempResult = new ArrayList();
            if (this.expandTarget instanceof OSQLFilterItemVariable && (r = ((OSQLFilterItemVariable)this.expandTarget).getValue(null, this.context)) != null) {
                if (r instanceof OIdentifiable) {
                    ((Collection)this.tempResult).add((OIdentifiable)r);
                } else if (OMultiValue.isMultiValue((Object)r)) {
                    for (Object o : OMultiValue.getMultiValueIterable((Object)r)) {
                        ((Collection)this.tempResult).add((OIdentifiable)o);
                    }
                }
            }
        } else {
            OMultiCollectionIterator finalResult = new OMultiCollectionIterator();
            finalResult.setLimit(this.limit);
            for (OIdentifiable id : this.tempResult) {
                Object fieldValue = this.expandTarget instanceof OSQLFilterItem ? ((OSQLFilterItem)this.expandTarget).getValue((OIdentifiable)id.getRecord(), this.context) : (this.expandTarget instanceof OSQLFunctionRuntime ? ((OSQLFunctionRuntime)this.expandTarget).getResult() : this.expandTarget.toString());
                if (fieldValue == null) continue;
                if (fieldValue instanceof Collection) {
                    finalResult.add((Object)((Collection)fieldValue));
                    continue;
                }
                if (fieldValue instanceof Map) {
                    finalResult.add(((Map)fieldValue).values());
                    continue;
                }
                if (fieldValue instanceof OMultiCollectionIterator) {
                    finalResult.add((Object)((OMultiCollectionIterator)fieldValue));
                    continue;
                }
                if (!(fieldValue instanceof OIdentifiable)) continue;
                finalResult.add((Object)((OIdentifiable)fieldValue));
            }
            this.tempResult = finalResult;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void searchInIndex() {
        block22: {
            OIndex index;
            block23: {
                void var5_30;
                block29: {
                    OQueryOperator indexOperator;
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        index = OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.parsedTarget.getTargetIndex());
                                        if (index == null) {
                                            throw new OCommandExecutionException("Target index '" + this.parsedTarget.getTargetIndex() + "' not found");
                                        }
                                        if (index.getDefinition() == null) {
                                            return;
                                        }
                                        if (this.compiledFilter == null || this.compiledFilter.getRootCondition() == null) break block23;
                                        if (!"KEY".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
                                            throw new OCommandExecutionException("'Key' field is required for queries against indexes");
                                        }
                                        indexOperator = this.compiledFilter.getRootCondition().getOperator();
                                        if (!(indexOperator instanceof OQueryOperatorBetween)) break block24;
                                        Object[] values = (Object[])this.compiledFilter.getRootCondition().getRight();
                                        Collection<ODocument> entries = index.getEntriesBetween(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[0]), OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[2]));
                                        for (OIdentifiable oIdentifiable : entries) {
                                            boolean continueResultParsing = this.handleResult(oIdentifiable, false);
                                            if (continueResultParsing) {
                                                continue;
                                            }
                                            break block22;
                                        }
                                        break block22;
                                    }
                                    if (!(indexOperator instanceof OQueryOperatorMajor)) break block25;
                                    Object value = this.compiledFilter.getRootCondition().getRight();
                                    Collection<ODocument> entries = index.getEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), false);
                                    this.parseIndexSearchResult(entries);
                                    break block22;
                                }
                                if (!(indexOperator instanceof OQueryOperatorMajorEquals)) break block26;
                                Object value = this.compiledFilter.getRootCondition().getRight();
                                Collection<ODocument> entries = index.getEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), true);
                                this.parseIndexSearchResult(entries);
                                break block22;
                            }
                            if (!(indexOperator instanceof OQueryOperatorMinor)) break block27;
                            Object value = this.compiledFilter.getRootCondition().getRight();
                            Collection<ODocument> entries = index.getEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), false);
                            this.parseIndexSearchResult(entries);
                            break block22;
                        }
                        if (!(indexOperator instanceof OQueryOperatorMinorEquals)) break block28;
                        Object value = this.compiledFilter.getRootCondition().getRight();
                        Collection<ODocument> entries = index.getEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), true);
                        this.parseIndexSearchResult(entries);
                        break block22;
                    }
                    if (!(indexOperator instanceof OQueryOperatorIn)) break block29;
                    List origValues = (List)this.compiledFilter.getRootCondition().getRight();
                    ArrayList<Object> values = new ArrayList<Object>(origValues.size());
                    for (Object e : origValues) {
                        if (index.getDefinition() instanceof OCompositeIndexDefinition) {
                            throw new OCommandExecutionException("Operator IN not supported yet.");
                        }
                        Object object = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), e);
                        values.add(object);
                    }
                    Collection<ODocument> collection = index.getEntries(values);
                    this.parseIndexSearchResult(collection);
                    break block22;
                }
                Object right = this.compiledFilter.getRootCondition().getRight();
                Object keyValue = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right);
                if (index.getDefinition().getParamCount() == 1) {
                    Object obj = index.get(keyValue);
                } else {
                    Object secondKey = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right);
                    Collection<OIdentifiable> collection = index.getValuesBetween(keyValue, secondKey);
                }
                if (var5_30 == null) break block22;
                if (var5_30 instanceof Collection) {
                    for (OIdentifiable r : (Collection)var5_30) {
                        this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(keyValue, r.getIdentity()), true);
                    }
                } else {
                    this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(keyValue, ((OIdentifiable)var5_30).getIdentity()), true);
                }
                break block22;
            }
            if (this.isIndexSizeQuery()) {
                this.getProjectionGroup(null).applyValue(this.projections.keySet().iterator().next(), index.getSize());
                return;
            }
            if (this.isIndexKeySizeQuery()) {
                this.getProjectionGroup(null).applyValue(this.projections.keySet().iterator().next(), index.getKeySize());
                return;
            }
            OIndexInternal<?> indexInternal = index.getInternal();
            if (indexInternal instanceof OSharedResource) {
                ((OSharedResource)indexInternal).acquireExclusiveLock();
            }
            try {
                Iterator<Map.Entry<Object, ?>> it = index.iterator();
                block6: while (it.hasNext()) {
                    Map.Entry<Object, ?> current = it.next();
                    if (current.getValue() instanceof Collection) {
                        for (OIdentifiable oIdentifiable : (OMVRBTreeRIDSet)current.getValue()) {
                            if (!this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(current.getKey(), oIdentifiable.getIdentity()), true)) continue block6;
                        }
                        continue;
                    }
                    if (this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(current.getKey(), (OIdentifiable)current.getValue()), true)) continue;
                }
            }
            finally {
                if (indexInternal instanceof OSharedResource) {
                    ((OSharedResource)indexInternal).releaseExclusiveLock();
                }
            }
        }
    }

    private boolean isIndexSizeQuery() {
        if (this.groupedResult == null || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        if (!f.getRoot().equals("count")) {
            return false;
        }
        return f.configuredParameters == null || f.configuredParameters.length == 0 || f.configuredParameters != null && f.configuredParameters.length == 1 && f.configuredParameters[0].equals("*");
    }

    private boolean isIndexKeySizeQuery() {
        if (this.groupedResult == null || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        if (!f.getRoot().equals("count")) {
            return false;
        }
        if (f.configuredParameters == null || f.configuredParameters.length != 1 || !(f.configuredParameters[0] instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime fConfigured = (OSQLFunctionRuntime)f.configuredParameters[0];
        if (!fConfigured.getRoot().equals("distinct")) {
            return false;
        }
        if (fConfigured.configuredParameters == null || fConfigured.configuredParameters.length != 1 || !(fConfigured.configuredParameters[0] instanceof OSQLFilterItemField)) {
            return false;
        }
        OSQLFilterItemField field = (OSQLFilterItemField)fConfigured.configuredParameters[0];
        return field.getRoot().equals("key");
    }

    private static Object getIndexKey(OIndexDefinition indexDefinition, Object value) {
        if (indexDefinition instanceof OCompositeIndexDefinition) {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Object> keyParams = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    keyParams.add(OSQLHelper.getValue(o));
                }
                return indexDefinition.createValue(keyParams);
            }
            if ((value = OSQLHelper.getValue(value)) instanceof OCompositeKey) {
                return value;
            }
            return indexDefinition.createValue(value);
        }
        return OSQLHelper.getValue(value);
    }

    protected void parseIndexSearchResult(Collection<ODocument> entries) {
        for (ODocument document : entries) {
            boolean continueResultParsing = this.handleResult(document, false);
            if (!continueResultParsing) break;
        }
    }

    private static ODocument createIndexEntryAsDocument(Object iKey, OIdentifiable iValue) {
        ODocument doc = new ODocument().setOrdered(true);
        doc.field("key", iKey);
        doc.field("rid", iValue);
        doc.unsetDirty();
        return doc;
    }

    private void handleNoTarget() {
        if (this.parsedTarget == null) {
            this.handleResult(ORuntimeResult.createProjectionDocument(this.resultCount), true);
        }
    }

    private void handleGroupBy() {
        if (this.groupedResult != null && this.tempResult == null) {
            this.tempResult = new ArrayList();
            for (Map.Entry<Object, ORuntimeResult> g : this.groupedResult.entrySet()) {
                ODocument doc;
                if (g.getKey() == null && (this.groupedResult.size() != 1 || this.groupByFields != null) || (doc = g.getValue().getResult()) == null || doc.isEmpty()) continue;
                ((List)this.tempResult).add(doc);
            }
        }
    }

    private static boolean checkIndexExistence(OClass iSchemaClass, OIndexSearchResult result) {
        if (!iSchemaClass.areIndexed(result.fields())) {
            return false;
        }
        if (result.lastField.isLong()) {
            int fieldCount = result.lastField.getItemCount();
            OClass cls = iSchemaClass.getProperty(result.lastField.getItemName(0)).getLinkedClass();
            int i = 1;
            while (i < fieldCount) {
                if (cls == null || !cls.areIndexed(result.lastField.getItemName(i))) {
                    return false;
                }
                cls = cls.getProperty(result.lastField.getItemName(i)).getLinkedClass();
                ++i;
            }
        }
        return true;
    }

    public String getSyntax() {
        return "SELECT [<Projections>] FROM <Target> [LET <Assignment>*] [WHERE <Condition>*] [ORDER BY <Fields>* [ASC|DESC]*] [LIMIT <MaxRecords>]";
    }

    protected boolean parseFetchplan(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_FETCHPLAN)) {
            return false;
        }
        this.parserNextWord(true);
        this.fetchPlan = OStringSerializerHelper.getStringContent(this.parserGetLastWord());
        this.request.setFetchPlan(this.fetchPlan);
        return true;
    }

    @Override
    public String getFetchPlan() {
        return this.fetchPlan != null ? this.fetchPlan : this.request.getFetchPlan();
    }

    protected boolean optimizeExecution() {
        Set<OIndex<?>> involvedIndexes;
        OPair<String, String> orderByFirstField;
        OClass cls;
        OProperty p;
        Map.Entry<String, Object> entry;
        if ((this.compiledFilter == null || this.compiledFilter != null && this.compiledFilter.getRootCondition() == null) && this.groupByFields == null && this.projections != null && this.projections.size() == 1 && (entry = this.projections.entrySet().iterator().next()).getValue() instanceof OSQLFunctionRuntime) {
            OSQLFunctionRuntime rf = (OSQLFunctionRuntime)entry.getValue();
            if (rf.function instanceof OSQLFunctionCount && rf.configuredParameters.length == 1 && "*".equals(rf.configuredParameters[0])) {
                long count = 0L;
                if (this.parsedTarget.getTargetClasses() != null) {
                    OClass cls2 = this.parsedTarget.getTargetClasses().keySet().iterator().next();
                    count = cls2.count();
                } else if (this.parsedTarget.getTargetClusters() != null) {
                    for (String cluster : this.parsedTarget.getTargetClusters().keySet()) {
                        count += OCommandExecutorSQLSelect.getDatabase().countClusterElements(cluster);
                    }
                } else if (this.parsedTarget.getTargetIndex() != null) {
                    count += OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.parsedTarget.getTargetIndex()).getSize();
                } else {
                    Iterable<? extends OIdentifiable> recs = this.parsedTarget.getTargetRecords();
                    if (recs != null) {
                        if (recs instanceof Collection) {
                            count += (long)((Collection)recs).size();
                        } else {
                            for (OIdentifiable oIdentifiable : recs) {
                                ++count;
                            }
                        }
                    }
                }
                if (this.tempResult == null) {
                    this.tempResult = new ArrayList();
                }
                ((Collection)this.tempResult).add(new ODocument().field(entry.getKey(), count));
                return true;
            }
        }
        if (this.orderedFields != null && !this.orderedFields.isEmpty() && this.parsedTarget.getTargetClasses() != null && (p = (cls = this.parsedTarget.getTargetClasses().keySet().iterator().next()).getProperty((String)((Object)(orderByFirstField = this.orderedFields.iterator().next()).getKey()))) != null && (involvedIndexes = cls.getInvolvedIndexes((String)((Object)orderByFirstField.getKey()))) != null && !involvedIndexes.isEmpty()) {
            for (OIndex<?> idx : involvedIndexes) {
                if (idx.getKeyTypes().length != 1 || !idx.supportsOrderedIterations() || idx.getKeySize() >= 100L && this.compiledFilter != null) continue;
                this.target = ((String)orderByFirstField.getValue()).equalsIgnoreCase("asc") ? idx.valuesIterator() : idx.valuesInverseIterator();
                if (this.context.isRecordingMetrics()) {
                    HashSet<String> idxNames = (HashSet<String>)this.context.getVariable("involvedIndexes");
                    if (idxNames == null) {
                        idxNames = new HashSet<String>();
                        this.context.setVariable("involvedIndexes", idxNames);
                    }
                    idxNames.add(idx.getName());
                }
                this.orderedFields = null;
                this.fetchLimit = this.getQueryFetchLimit();
                break;
            }
        }
        return false;
    }

    private static class IndexComparator
    implements Comparator<OIndex<?>> {
        private static final IndexComparator INSTANCE = new IndexComparator();

        private IndexComparator() {
        }

        @Override
        public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
            return indexOne.getDefinition().getParamCount() - indexTwo.getDefinition().getParamCount();
        }
    }
}

