/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OCaseIncentiveComparator;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLDropProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private boolean force = false;

    public OCommandExecutorSQLDropProperty parse(OCommandRequest iRequest) {
        OCommandExecutorSQLDropProperty.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLDropProperty.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropProperty.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
            throw new OCommandSQLParsingException("Keyword PROPERTY not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropProperty.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.className = parts[0];
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class not found", this.parserText, pos);
        }
        this.fieldName = parts[1];
        if ((pos = OCommandExecutorSQLDropProperty.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)false)) != -1) {
            String forceParameter = word.toString();
            if ("FORCE".equals(forceParameter)) {
                this.force = true;
            } else {
                throw new OCommandSQLParsingException("Wrong query parameter", this.parserText, pos);
            }
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.fieldName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        ODatabaseRecord database = OCommandExecutorSQLDropProperty.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        List<OIndex<?>> indexes = this.relatedIndexes(this.fieldName);
        if (!indexes.isEmpty()) {
            if (this.force) {
                this.dropRelatedIndexes(indexes);
            } else {
                StringBuilder indexNames = new StringBuilder();
                boolean first = true;
                for (OIndex<?> index : sourceClass.getClassInvolvedIndexes(this.fieldName)) {
                    if (!first) {
                        indexNames.append(", ");
                    } else {
                        first = false;
                    }
                    indexNames.append(index.getName());
                }
                throw new OCommandExecutionException("Property used in indexes (" + indexNames.toString() + "). Please drop these indexes before removing property or use FORCE parameter.");
            }
        }
        sourceClass.dropPropertyInternal(this.fieldName);
        sourceClass.saveInternal();
        return null;
    }

    private void dropRelatedIndexes(List<OIndex<?>> indexes) {
        ODatabaseRecord database = OCommandExecutorSQLDropProperty.getDatabase();
        for (OIndex<?> index : indexes) {
            database.command(new OCommandSQL("DROP INDEX " + index.getName())).execute(new Object[0]);
        }
    }

    private List<OIndex<?>> relatedIndexes(String fieldName) {
        ArrayList result = new ArrayList();
        ODatabaseRecord database = OCommandExecutorSQLDropProperty.getDatabase();
        for (OIndex<?> oIndex : database.getMetadata().getIndexManager().getClassIndexes(this.className)) {
            if (OCollections.indexOf(oIndex.getDefinition().getFields(), (Object)fieldName, (Comparator)new OCaseIncentiveComparator()) <= -1) continue;
            result.add(oIndex);
        }
        return result;
    }

    public String getSyntax() {
        return "DROP PROPERTY <class>.<property>";
    }
}

