/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.util.Map;

public class OCommandExecutorSQLCreateCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    public static final String KEYWORD_ID = "ID";
    public static final String KEYWORD_DATASEGMENT = "DATASEGMENT";
    public static final String KEYWORD_LOCATION = "LOCATION";
    public static final String KEYWORD_POSITION = "POSITION";
    private String clusterName;
    private String clusterType;
    private int requestedId = -1;
    private String dataSegmentName = "default";
    private String location = "default";
    private String position = "append";

    public OCommandExecutorSQLCreateCluster parse(OCommandRequest iRequest) {
        int dataId;
        int clusterId;
        ODatabaseRecord database = OCommandExecutorSQLCreateCluster.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(new String[]{KEYWORD_CREATE});
        this.parserRequiredKeyword(new String[]{KEYWORD_CLUSTER});
        this.clusterName = this.parserRequiredWord(false);
        if (!this.clusterName.isEmpty() && Character.isDigit(this.clusterName.charAt(0))) {
            throw new IllegalArgumentException("Cluster name cannot begin with a digit");
        }
        this.clusterType = this.parserRequiredWord(false);
        String temp = this.parseOptionalWord(true, new String[0]);
        while (temp != null) {
            if (temp.equals(KEYWORD_ID)) {
                this.requestedId = Integer.parseInt(this.parserRequiredWord(false));
            } else if (temp.equals(KEYWORD_DATASEGMENT)) {
                this.dataSegmentName = this.parserRequiredWord(false);
            } else if (temp.equals(KEYWORD_LOCATION)) {
                this.location = this.parserRequiredWord(false);
            } else if (temp.equals(KEYWORD_POSITION)) {
                this.position = this.parserRequiredWord(false);
            }
            temp = this.parseOptionalWord(true, new String[0]);
            if (!this.parserIsEnded()) continue;
        }
        if ((clusterId = database.getStorage().getClusterIdByName(this.clusterName)) > -1) {
            throw new OCommandSQLParsingException("Cluster '" + this.clusterName + "' already exists");
        }
        if (!(database.getStorage() instanceof OLocalPaginatedStorage) && (dataId = database.getStorage().getDataSegmentIdByName(this.dataSegmentName)) == -1) {
            throw new OCommandSQLParsingException("Data segment '" + this.dataSegmentName + "' does not exists");
        }
        if (!Orient.instance().getClusterFactory().isSupported(this.clusterType)) {
            throw new OCommandSQLParsingException("Cluster type '" + this.clusterType + "' is not supported");
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateCluster.getDatabase();
        if (this.requestedId == -1) {
            return database.addCluster(this.clusterType, this.clusterName, this.location, this.dataSegmentName, new Object[0]);
        }
        return database.addCluster(this.clusterType, this.clusterName, this.requestedId, this.location, this.dataSegmentName, new Object[0]);
    }

    public String getSyntax() {
        return "CREATE CLUSTER <name> <type> [DATASEGMENT <data-segment>|default] [LOCATION <path>|default] [POSITION <position>|append]";
    }
}

