/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OCommandExecutorSQLAlterCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    protected String clusterName;
    protected int clusterId = -1;
    protected OCluster.ATTRIBUTES attribute;
    protected String value;

    public OCommandExecutorSQLAlterCluster parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLAlterCluster.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLAlterCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
            throw new OCommandSQLParsingException("Keyword CLUSTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected <cluster-name>. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        this.clusterName = word.toString();
        Pattern p = Pattern.compile("([0-9]*)");
        Matcher m = p.matcher(this.clusterName);
        if (m.matches()) {
            this.clusterId = Integer.parseInt(this.clusterName);
        }
        if ((pos = OCommandExecutorSQLAlterCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)(oldPos = pos), (StringBuilder)word, (boolean)true)) == -1) {
            throw new OCommandSQLParsingException("Missing cluster attribute to change. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = OCluster.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown class attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OCluster.ATTRIBUTES.values()), this.parserText, oldPos);
        }
        this.value = this.parserText.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missing property value to change for attribute '" + (Object)((Object)this.attribute) + "'. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if (this.value.equalsIgnoreCase("null")) {
            this.value = null;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OCluster cluster = this.getCluster();
        if (cluster == null) {
            throw new OCommandExecutionException("Cluster '" + this.clusterName + "' not found");
        }
        if (this.clusterId > -1 && this.clusterName.equals(String.valueOf(this.clusterId))) {
            this.clusterName = cluster.getName();
        } else {
            this.clusterId = cluster.getId();
        }
        try {
            cluster.set(this.attribute, this.value);
            OStorage storage = OCommandExecutorSQLAlterCluster.getDatabase().getStorage();
            if (storage instanceof OLocalPaginatedStorage) {
                ((OLocalPaginatedStorage)storage).makeFullCheckpoint();
            }
        }
        catch (IOException ioe) {
            throw new OCommandExecutionException("Error altering cluster '" + this.clusterName + "'", ioe);
        }
        return null;
    }

    protected OCluster getCluster() {
        ODatabaseRecord database = OCommandExecutorSQLAlterCluster.getDatabase();
        if (this.clusterId > -1) {
            return database.getStorage().getClusterById(this.clusterId);
        }
        return database.getStorage().getClusterById(database.getStorage().getClusterIdByName(this.clusterName));
    }

    public String getSyntax() {
        return "ALTER CLUSTER <cluster-name>|<cluster-id> <attribute-name> <attribute-value>";
    }
}

