/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;

public abstract class OCommandExecutorSQLAbstract
extends OCommandExecutorAbstract {
    public static final String KEYWORD_FROM = "FROM";
    public static final String KEYWORD_LET = "LET";
    public static final String KEYWORD_WHERE = "WHERE";
    public static final String KEYWORD_LIMIT = "LIMIT";
    public static final String KEYWORD_SKIP = "SKIP";
    public static final String KEYWORD_TIMEOUT = "TIMEOUT";
    public static final String KEYWORD_KEY = "key";
    public static final String KEYWORD_RID = "rid";
    public static final String CLUSTER_PREFIX = "CLUSTER:";
    public static final String CLASS_PREFIX = "CLASS:";
    public static final String INDEX_PREFIX = "INDEX:";
    public static final String DICTIONARY_PREFIX = "DICTIONARY:";
    protected long timeoutMs = OGlobalConfiguration.COMMAND_TIMEOUT.getValueAsLong();
    protected OCommandContext.TIMEOUT_STRATEGY timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;

    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandSQLParsingException(iText + ". Use " + this.getSyntax(), this.parserText, this.parserGetPreviousPosition());
    }

    protected void throwParsingException(String iText) {
        throw new OCommandSQLParsingException(iText, this.parserText, this.parserGetPreviousPosition());
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    protected boolean parseTimeout(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_TIMEOUT)) {
            return false;
        }
        this.parserNextWord(true);
        String word = this.parserGetLastWord();
        try {
            this.timeoutMs = Long.parseLong(word);
        }
        catch (Exception e) {
            this.throwParsingException("Invalid TIMEOUT value setted to '" + word + "' but it should be a valid long. Example: " + KEYWORD_TIMEOUT + " 3000");
        }
        if (this.timeoutMs < 0L) {
            this.throwParsingException("Invalid TIMEOUT: value setted to less than ZERO. Example: " + this.timeoutMs + " 10");
        }
        this.parserNextWord(true);
        word = this.parserGetLastWord();
        if (word.equals(OCommandContext.TIMEOUT_STRATEGY.EXCEPTION.toString())) {
            this.timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;
        } else if (word.equals(OCommandContext.TIMEOUT_STRATEGY.RETURN.toString())) {
            this.timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.RETURN;
        } else {
            this.parserGoBack();
        }
        return true;
    }
}

