/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchContext;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.ORecordStringable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.core.util.ODateHelper;
import com.orientechnologies.orient.core.version.ODistributedVersion;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ORecordSerializerJSON
extends ORecordSerializerStringAbstract {
    public static final String NAME = "json";
    public static final ORecordSerializerJSON INSTANCE = new ORecordSerializerJSON();
    public static final String ATTRIBUTE_FIELD_TYPES = "@fieldTypes";
    public static final char[] PARAMETER_SEPARATOR = new char[]{':', ','};
    private static final Long MAX_INT = new Long(Integer.MAX_VALUE);
    private static final Long MIN_INT = new Long(Integer.MIN_VALUE);
    private static final Double MAX_FLOAT = new Double(3.4028234663852886E38);
    private static final Double MIN_FLOAT = new Double(1.4E-45f);
    private static /* synthetic */ int[] $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType;

    public ORecordInternal<?> fromString(String iSource, ORecordInternal<?> iRecord, String[] iFields, boolean needReload) {
        return this.fromString(iSource, iRecord, iFields, null, needReload);
    }

    @Override
    public ORecordInternal<?> fromString(String iSource, ORecordInternal<?> iRecord, String[] iFields) {
        return this.fromString(iSource, iRecord, iFields, null, false);
    }

    public ORecordInternal<?> fromString(String iSource, ORecordInternal<?> iRecord, String[] iFields, String iOptions, boolean needReload) {
        block40: {
            List<String> fields;
            if (iSource == null) {
                throw new OSerializationException("Error on unmarshalling JSON content: content is null");
            }
            if (!(iSource = iSource.trim()).startsWith("{") || !iSource.endsWith("}")) {
                throw new OSerializationException("Error on unmarshalling JSON content: content must be between { }");
            }
            if (iRecord != null) {
                iRecord.clear();
            }
            iSource = iSource.substring(1, iSource.length() - 1).trim();
            boolean noMap = false;
            if (iOptions != null) {
                String[] format;
                String[] stringArray = format = iOptions.split(",");
                int n = format.length;
                int n2 = 0;
                while (n2 < n) {
                    String f = stringArray[n2];
                    if (f.equals("noMap")) {
                        noMap = true;
                    }
                    ++n2;
                }
            }
            if ((fields = OStringSerializerHelper.smartSplit(iSource, PARAMETER_SEPARATOR, 0, -1, true, true, false, ' ', '\n', '\r', '\t')).size() % 2 != 0) {
                throw new OSerializationException("Error on unmarshalling JSON content: wrong format. Use <field> : <value>");
            }
            HashMap<String, Character> fieldTypes = null;
            if (fields == null || fields.size() <= 0) break block40;
            int i = 0;
            while (i < fields.size()) {
                String fieldName = OStringSerializerHelper.getStringContent(fields.get(i));
                String fieldValue = fields.get(i + 1);
                String fieldValueAsString = OStringSerializerHelper.getStringContent(fieldValue);
                if (fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) {
                    String[] fieldTypesParts = fieldValueAsString.split(",");
                    if (fieldTypesParts.length > 0) {
                        fieldTypes = new HashMap<String, Character>();
                        String[] stringArray = fieldTypesParts;
                        int n = fieldTypesParts.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String f = stringArray[n3];
                            String[] part = f.split("=");
                            if (part.length == 2) {
                                fieldTypes.put(part[0], Character.valueOf(part[1].charAt(0)));
                            }
                            ++n3;
                        }
                    }
                } else if (fieldName.equals("@type")) {
                    if (iRecord == null || iRecord.getRecordType() != fieldValueAsString.charAt(0)) {
                        iRecord = Orient.instance().getRecordFactoryManager().newInstance((byte)fieldValueAsString.charAt(0));
                    }
                } else if (needReload && fieldName.equals("@rid") && iRecord instanceof ODocument) {
                    ORecordInternal localRecord;
                    if (fieldValue != null && fieldValue.length() > 0 && (localRecord = (ORecordInternal)ODatabaseRecordThreadLocal.INSTANCE.get().load(new ORecordId(fieldValueAsString))) != null) {
                        iRecord = localRecord;
                    }
                } else if (fieldName.equals("@class") && iRecord instanceof ODocument) {
                    ((ODocument)iRecord).setClassNameIfExists("null".equals(fieldValueAsString) ? null : fieldValueAsString);
                }
                i += 2;
            }
            try {
                int recordVersion = 0;
                long timestamp = 0L;
                long macAddress = 0L;
                int i2 = 0;
                while (i2 < fields.size()) {
                    block42: {
                        Object v;
                        OType type;
                        ODocument doc;
                        String fieldValue;
                        String fieldName;
                        block47: {
                            String className;
                            block49: {
                                Object first;
                                block48: {
                                    OProperty prop;
                                    String fieldValueAsString;
                                    block46: {
                                        block45: {
                                            block44: {
                                                block43: {
                                                    block41: {
                                                        fieldName = OStringSerializerHelper.getStringContent(fields.get(i2));
                                                        fieldValue = fields.get(i2 + 1);
                                                        fieldValueAsString = OStringSerializerHelper.getStringContent(fieldValue);
                                                        if (!fieldName.equals("@rid")) break block41;
                                                        iRecord.setIdentity(new ORecordId(fieldValueAsString));
                                                        break block42;
                                                    }
                                                    if (!fieldName.equals("@version")) break block43;
                                                    if (OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                                                        recordVersion = Integer.parseInt(fieldValue);
                                                    } else {
                                                        iRecord.getRecordVersion().setCounter(Integer.parseInt(fieldValue));
                                                    }
                                                    break block42;
                                                }
                                                if (!fieldName.equals("@version_time")) break block44;
                                                if (OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                                                    timestamp = Long.parseLong(fieldValue);
                                                }
                                                break block42;
                                            }
                                            if (!fieldName.equals("@version_mac")) break block45;
                                            if (OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                                                macAddress = Long.parseLong(fieldValue);
                                            }
                                            break block42;
                                        }
                                        if (fieldName.equals("@type") || fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) break block42;
                                        if (!fieldName.equals("value") || iRecord instanceof ODocument) break block46;
                                        if ("null".equals(fieldValue)) {
                                            iRecord.fromStream(new byte[0]);
                                        } else if (iRecord instanceof ORecordBytes) {
                                            iRecord.fromStream(OBase64Utils.decode(fieldValueAsString));
                                        } else if (iRecord instanceof ORecordStringable) {
                                            ((ORecordStringable)((Object)iRecord)).value(fieldValueAsString);
                                        }
                                        break block42;
                                    }
                                    if (!(iRecord instanceof ODocument)) break block42;
                                    doc = (ODocument)iRecord;
                                    type = null;
                                    OClass cls = doc.getSchemaClass();
                                    if (cls != null && (prop = cls.getProperty(fieldName)) != null) {
                                        type = prop.getType();
                                    }
                                    if ((v = this.getValue(doc, fieldName, fieldValue, fieldValueAsString, type, null, fieldTypes, noMap, iOptions)) == null) break block47;
                                    if (!(v instanceof Collection) || ((Collection)v).isEmpty()) break block48;
                                    if (v instanceof ORecordLazyMultiValue) {
                                        ((ORecordLazyMultiValue)v).setAutoConvertToRecord(false);
                                    }
                                    if (type == null && (first = ((Collection)v).iterator().next()) != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                                        OType oType = type = v instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST;
                                    }
                                    if (type == null) break block47;
                                    doc.field(fieldName, v, type);
                                    break block42;
                                }
                                if (!(v instanceof Map) || ((Map)v).isEmpty()) break block49;
                                first = ((Map)v).values().iterator().next();
                                if (first == null || !(first instanceof ORecord) || ((ORecord)first).getIdentity().isValid()) break block47;
                                doc.field(fieldName, v, OType.EMBEDDEDMAP);
                                break block42;
                            }
                            if (v instanceof ODocument && type != null && type.isLink() && (className = ((ODocument)v).getClassName()) != null && className.length() > 0) {
                                ((ODocument)v).save();
                            }
                        }
                        if (type == null && fieldTypes != null && fieldTypes.containsKey(fieldName)) {
                            type = ORecordSerializerStringAbstract.getType(fieldValue, ((Character)fieldTypes.get(fieldName)).charValue());
                        }
                        if (type != null) {
                            doc.field(fieldName, v, type);
                        } else {
                            doc.field(fieldName, v);
                        }
                    }
                    i2 += 2;
                }
                if (timestamp != 0L && OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                    ((ODistributedVersion)iRecord.getRecordVersion()).update(recordVersion, timestamp, macAddress);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OSerializationException("Error on unmarshalling JSON content for record " + iRecord.getIdentity(), e);
            }
        }
        return iRecord;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getValue(ODocument iRecord, String iFieldName, String iFieldValue, String iFieldValueAsString, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions) {
        block57: {
            block54: {
                block58: {
                    block56: {
                        block55: {
                            if (iFieldValue.equals("null")) {
                                return null;
                            }
                            if (iFieldName != null && iRecord.getSchemaClass() != null && (p = iRecord.getSchemaClass().getProperty(iFieldName)) != null) {
                                iType = p.getType();
                                iLinkedType = p.getLinkedType();
                            }
                            if (!iFieldValue.startsWith("{") || !iFieldValue.endsWith("}")) break block55;
                            iFieldValueAsString = iFieldValue.substring(1, iFieldValue.length() - 1);
                            fields = OStringParser.getWords((String)iFieldValueAsString, (String)":,", (boolean)true);
                            if (fields == null || fields.length == 0) {
                                return new HashMap<K, V>();
                            }
                            if (iNoMap || this.hasTypeField(fields)) {
                                recordInternal = this.fromString(iFieldValue, new ODocument(), null, iOptions, false);
                                if ((iType == null || !iType.isLink()) && recordInternal instanceof ODocument) {
                                    ((ODocument)recordInternal).addOwner(iRecord);
                                }
                                return recordInternal;
                            }
                            if (fields.length % 2 == 1) {
                                throw new OSerializationException("Bad JSON format on map. Expected pairs of field:value but received '" + iFieldValueAsString + "'");
                            }
                            embeddedMap = new LinkedHashMap<String, Object>();
                            i = 0;
                            if (true) ** GOTO lbl126
                        }
                        if (!iFieldValue.startsWith("[") || !iFieldValue.endsWith("]")) break block56;
                        embeddedCollection = iType == OType.LINKSET ? new OMVRBTreeRIDSet(iRecord) : (iType == OType.EMBEDDEDSET ? new OTrackedSet<T>(iRecord) : (iType == OType.LINKLIST ? new ORecordLazyList(iRecord) : new OTrackedList<T>(iRecord)));
                        if ((iFieldValue = iFieldValue.substring(1, iFieldValue.length() - 1)).isEmpty()) break block57;
                        items = OStringSerializerHelper.smartSplit(iFieldValue, ',', new char[0]);
                        var14_26 = items.iterator();
                        if (true) ** GOTO lbl137
                    }
                    if (iType != null) break block54;
                    if (iFieldValue.charAt(0) == '\"' || iFieldValue.charAt(0) == '\'') break block58;
                    if (iFieldValue.equalsIgnoreCase("false") || iFieldValue.equalsIgnoreCase("true")) {
                        iType = OType.BOOLEAN;
                        break block54;
                    } else {
                        c = null;
                        if (iFieldTypes != null && (c = iFieldTypes.get(iFieldName)) != null) {
                            iType = ORecordSerializerStringAbstract.getType(String.valueOf(iFieldValue) + c);
                        }
                        if (c == null && !iFieldValue.isEmpty()) {
                            if (iFieldValue.charAt(0) == '#' && iFieldValue.contains(":")) {
                                iType = OType.LINK;
                                break block54;
                            } else {
                                if (OStringSerializerHelper.contains(iFieldValue, '.')) {
                                    v = new Double(OStringSerializerHelper.getStringContent(iFieldValue));
                                    if (v > 0.0 ? v.compareTo(ORecordSerializerJSON.MAX_FLOAT) <= 0 : v.compareTo(ORecordSerializerJSON.MIN_FLOAT) >= 0) {
                                        return Float.valueOf(v.floatValue());
                                    }
                                    return v;
                                }
                                v = new Long(OStringSerializerHelper.getStringContent(iFieldValue));
                                if (v > 0L ? v.compareTo(ORecordSerializerJSON.MAX_INT) <= 0 : v.compareTo(ORecordSerializerJSON.MIN_INT) >= 0) {
                                    return v.intValue();
                                }
                                return v;
                            }
                        }
                    }
                    break block54;
                }
                if (iFieldValue.startsWith("{") && iFieldValue.endsWith("}")) {
                    iType = OType.EMBEDDED;
                } else {
                    if (iFieldValueAsString.length() >= 4 && iFieldValueAsString.charAt(0) == '#' && iFieldValueAsString.contains(":") && (parts = OStringSerializerHelper.split(iFieldValueAsString, 1, -1, ':', new char[0])).size() == 2) {
                        try {
                            Short.parseShort(parts.get(0));
                            if (parts.get(1).matches("\\d+")) {
                                iType = OType.LINK;
                            }
                        }
                        catch (Exception v) {
                            // empty catch block
                        }
                    }
                    if (iFieldTypes != null) {
                        c = null;
                        c = iFieldTypes.get(iFieldName);
                        if (c != null) {
                            iType = ORecordSerializerStringAbstract.getType(iFieldValueAsString, c.charValue());
                        }
                    }
                    if (iType == null) {
                        if (iFieldValueAsString.length() == ODateHelper.getDateFormat().length()) {
                            try {
                                return ODateHelper.getDateFormatInstance().parseObject(iFieldValueAsString);
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                        }
                        if (iFieldValueAsString.length() == ODateHelper.getDateTimeFormat().length()) {
                            try {
                                return ODateHelper.getDateTimeFormatInstance().parseObject(iFieldValueAsString);
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                        }
                        iType = OType.STRING;
                    }
                }
            }
            if (iType == null) {
                return iFieldValueAsString;
            }
            switch (ORecordSerializerJSON.$SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType()[iType.ordinal()]) {
                case 8: {
                    return this.decodeJSON(iFieldValueAsString);
                }
                case 14: {
                    pos = iFieldValueAsString.indexOf(64);
                    if (pos > -1) {
                        return new ODocument(iFieldValueAsString.substring(1, pos), (ORID)new ORecordId(iFieldValueAsString.substring(pos + 1)));
                    }
                    return new ORecordId(iFieldValueAsString);
                }
                case 10: {
                    return this.fromString(iFieldValueAsString);
                }
                case 20: {
                    if (iFieldValueAsString == null || iFieldValueAsString.equals("")) {
                        return null;
                    }
                    try {
                        return Long.parseLong(iFieldValueAsString);
                    }
                    catch (NumberFormatException e) {
                        try {
                            return ODateHelper.getDateFormatInstance().parseObject(iFieldValueAsString);
                        }
                        catch (ParseException ex) {
                            throw new OSerializationException("Unable to unmarshall date (format=" + ODateHelper.getDateFormat() + ") : " + iFieldValueAsString, e);
                        }
                    }
                }
                case 7: {
                    if (iFieldValueAsString == null || iFieldValueAsString.equals("")) {
                        return null;
                    }
                    try {
                        return Long.parseLong(iFieldValueAsString);
                    }
                    catch (NumberFormatException e) {
                        try {
                            return ODateHelper.getDateTimeFormatInstance().parseObject(iFieldValueAsString);
                        }
                        catch (ParseException ex) {
                            throw new OSerializationException("Unable to unmarshall datetime (format=" + ODateHelper.getDateTimeFormat() + ") : " + iFieldValueAsString, e);
                        }
                    }
                }
                case 9: {
                    return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValueAsString);
                }
            }
            return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValue);
            do {
                if ((iFieldName = fields[i]).length() >= 2) {
                    iFieldName = iFieldName.substring(1, iFieldName.length() - 1);
                }
                iFieldValue = fields[i + 1];
                iFieldValueAsString = OStringSerializerHelper.getStringContent(iFieldValue);
                embeddedMap.put(iFieldName, this.getValue(iRecord, null, iFieldValue, iFieldValueAsString, iLinkedType, null, iFieldTypes, iNoMap, iOptions));
                i += 2;
lbl126:
                // 2 sources

            } while (i < fields.length);
            return embeddedMap;
            do {
                iFieldValueAsString = (iFieldValue = (item = var14_26.next()).trim()).length() >= 2 ? iFieldValue.substring(1, iFieldValue.length() - 1) : iFieldValue;
                collectionItem = this.getValue(iRecord, null, iFieldValue, iFieldValueAsString, iLinkedType, null, iFieldTypes, iNoMap, iOptions);
                if ((iType == null || !iType.isLink()) && collectionItem instanceof ODocument && iRecord instanceof ODocument) {
                    ((ODocument)collectionItem).addOwner(iRecord);
                }
                if (collectionItem instanceof String && ((String)collectionItem).length() == 0) continue;
                embeddedCollection.add((OIdentifiable)collectionItem);
lbl137:
                // 3 sources

            } while (var14_26.hasNext());
        }
        return embeddedCollection;
    }

    private String decodeJSON(String iFieldValueAsString) {
        iFieldValueAsString = OStringParser.replaceAll((String)iFieldValueAsString, (String)"\\\\", (String)"\\");
        iFieldValueAsString = OStringParser.replaceAll((String)iFieldValueAsString, (String)"\\\"", (String)"\"");
        iFieldValueAsString = OStringParser.replaceAll((String)iFieldValueAsString, (String)"\\/", (String)"/");
        return iFieldValueAsString;
    }

    @Override
    public StringBuilder toString(ORecordInternal<?> iRecord, StringBuilder iOutput, String iFormat, OUserObject2RecordHandler iObjHandler, Set<Long> iMarshalledRecords, boolean iOnlyDelta, boolean autoDetectCollectionType) {
        try {
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter(buffer, iFormat);
            FormatSettings settings = new FormatSettings(iFormat);
            json.beginObject(settings.indentLevel);
            OJSONFetchContext context = new OJSONFetchContext(json, settings);
            context.writeSignature(json, iRecord);
            if (iRecord instanceof ORecordSchemaAware) {
                OFetchHelper.fetch(iRecord, null, OFetchHelper.buildFetchPlan(settings.fetchPlan), new OJSONFetchListener(), context, iFormat);
            } else if (iRecord instanceof ORecordStringable) {
                ORecordStringable record = (ORecordStringable)((Object)iRecord);
                json.writeAttribute(settings.indentLevel + 1, true, "value", record.value());
            } else if (iRecord instanceof ORecordBytes) {
                ORecordBytes record = (ORecordBytes)iRecord;
                json.writeAttribute(settings.indentLevel + 1, true, "value", OBase64Utils.encodeBytes(record.toStream()));
            } else {
                throw new OSerializationException("Error on marshalling record of type '" + iRecord.getClass() + "' to JSON. The record type cannot be exported to JSON");
            }
            json.endObject(settings.indentLevel);
            iOutput.append(buffer);
            return iOutput;
        }
        catch (IOException e) {
            throw new OSerializationException("Error on marshalling of record to JSON", e);
        }
    }

    private boolean hasTypeField(String[] fields) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].equals("\"@type\"") || fields[i].equals("'@type'")) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public String toString() {
        return NAME;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType() {
        if ($SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType != null) {
            return $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType;
        }
        int[] nArray = new int[OType.values().length];
        try {
            nArray[OType.BINARY.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.BOOLEAN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.BYTE.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.CUSTOM.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.DATE.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.DATETIME.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.DECIMAL.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.DOUBLE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.EMBEDDED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.EMBEDDEDLIST.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.EMBEDDEDMAP.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.EMBEDDEDSET.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.FLOAT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.INTEGER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.LINK.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.LINKLIST.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.LINKMAP.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.LINKSET.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.LONG.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.SHORT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.STRING.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OType.TRANSIENT.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType = nArray;
        return nArray;
    }

    public class FormatSettings {
        public boolean includeVer;
        public boolean includeType;
        public boolean includeId;
        public boolean includeClazz;
        public boolean attribSameRow;
        public boolean alwaysFetchEmbeddedDocuments;
        public int indentLevel;
        public String fetchPlan = null;
        public boolean keepTypes;
        public boolean dateAsLong = false;

        public FormatSettings(String iFormat) {
            if (iFormat == null) {
                this.includeType = true;
                this.includeVer = true;
                this.includeId = true;
                this.includeClazz = true;
                this.attribSameRow = true;
                this.indentLevel = 0;
                this.fetchPlan = "";
                this.keepTypes = true;
                this.alwaysFetchEmbeddedDocuments = true;
            } else {
                String[] format;
                this.includeType = false;
                this.includeVer = false;
                this.includeId = false;
                this.includeClazz = false;
                this.attribSameRow = false;
                this.alwaysFetchEmbeddedDocuments = false;
                this.indentLevel = 0;
                this.keepTypes = true;
                String[] stringArray = format = iFormat.split(",");
                int n = format.length;
                int n2 = 0;
                while (n2 < n) {
                    String f = stringArray[n2];
                    if (f.equals("type")) {
                        this.includeType = true;
                    } else if (f.equals("rid")) {
                        this.includeId = true;
                    } else if (f.equals("version")) {
                        this.includeVer = true;
                    } else if (f.equals("class")) {
                        this.includeClazz = true;
                    } else if (f.equals("attribSameRow")) {
                        this.attribSameRow = true;
                    } else if (f.startsWith("indent")) {
                        this.indentLevel = Integer.parseInt(f.substring(f.indexOf(58) + 1));
                    } else if (f.startsWith("fetchPlan")) {
                        this.fetchPlan = f.substring(f.indexOf(58) + 1);
                    } else if (f.startsWith("keepTypes")) {
                        this.keepTypes = true;
                    } else if (f.startsWith("alwaysFetchEmbedded")) {
                        this.alwaysFetchEmbeddedDocuments = true;
                    } else if (f.startsWith("dateAsLong")) {
                        this.dateAsLong = true;
                    }
                    ++n2;
                }
            }
        }
    }
}

