/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;
import java.util.List;

public class OCompositeKeySerializer
implements OBinarySerializer<OCompositeKey>,
OStreamSerializer {
    public static final String NAME = "cks";
    public static final OCompositeKeySerializer INSTANCE = new OCompositeKeySerializer();
    public static final byte ID = 14;

    public int getObjectSize(OCompositeKey compositeKey) {
        List keys = compositeKey.getKeys();
        int size = 8;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (Object key : keys) {
            OType type = OType.getTypeByClass(key.getClass());
            size += 1 + factory.getObjectSerializer(type).getObjectSize(key);
        }
        return size;
    }

    public void serialize(OCompositeKey compositeKey, byte[] stream, int startPosition) {
        List keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(keysSize), stream, startPosition += 4);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (Object key : keys) {
            OType type = OType.getTypeByClass(key.getClass());
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(type);
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serialize(key, stream, ++startPosition);
            startPosition += binarySerializer.getObjectSize(key);
        }
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(startPosition - oldStartPosition), stream, oldStartPosition);
    }

    public OCompositeKey deserialize(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(Integer.valueOf(keysSize));
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserialize(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key);
        }
        return compositeKey;
    }

    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
    }

    public byte getId() {
        return 14;
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        throw new UnsupportedOperationException("CSV storage format is out of dated and is not supported.");
    }

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        OCompositeKey compositeKey = new OCompositeKey();
        OMemoryInputStream inputStream = new OMemoryInputStream(iStream);
        int keysSize = inputStream.getAsInteger();
        for (int i = 0; i < keysSize; ++i) {
            byte[] keyBytes = inputStream.getAsByteArray();
            String keyString = OBinaryProtocol.bytes2string(keyBytes);
            int typeSeparatorPos = keyString.indexOf(44);
            OType type = OType.valueOf(keyString.substring(0, typeSeparatorPos));
            compositeKey.addKey(ORecordSerializerStringAbstract.simpleValueFromStream(keyString.substring(typeSeparatorPos + 1), type));
        }
        return compositeKey;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
    }

    public void serializeNative(OCompositeKey compositeKey, byte[] stream, int startPosition) {
        List keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(keysSize), stream, startPosition += 4);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (Object key : keys) {
            OType type = OType.getTypeByClass(key.getClass());
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(type);
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serializeNative(key, stream, ++startPosition);
            startPosition += binarySerializer.getObjectSize(key);
        }
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(startPosition - oldStartPosition), stream, oldStartPosition);
    }

    public OCompositeKey deserializeNative(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(Integer.valueOf(keysSize));
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeNative(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key);
        }
        return compositeKey;
    }

    public void serializeInDirectMemory(OCompositeKey compositeKey, ODirectMemory memory, long pointer) {
        List keys = compositeKey.getKeys();
        int keysSize = keys.size();
        long oldStartPointer = pointer;
        memory.setInt(pointer += 4L, keysSize);
        pointer += 4L;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (Object key : keys) {
            OType type = OType.getTypeByClass(key.getClass());
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(type);
            memory.setByte(pointer, binarySerializer.getId());
            binarySerializer.serializeInDirectMemory(key, memory, ++pointer);
            pointer += (long)binarySerializer.getObjectSize(key);
        }
        memory.setInt(oldStartPointer, (int)(pointer - oldStartPointer));
    }

    public OCompositeKey deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = memory.getInt(pointer += 4L);
        pointer += 4L;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = memory.getByte(pointer);
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeFromDirectMemory(memory, ++pointer);
            compositeKey.addKey(key);
            pointer += (long)binarySerializer.getObjectSize(key);
        }
        return compositeKey;
    }

    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return memory.getInt(pointer);
    }

    public boolean isFixedLength() {
        return false;
    }

    public int getFixedLength() {
        return 0;
    }
}

