/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.compression;

import com.orientechnologies.orient.core.serialization.compression.OCompression;
import com.orientechnologies.orient.core.serialization.compression.impl.OGZIPCompression;
import com.orientechnologies.orient.core.serialization.compression.impl.ONothingCompression;
import com.orientechnologies.orient.core.serialization.compression.impl.OSnappyCompression;
import java.util.HashMap;
import java.util.Map;

public class OCompressionFactory {
    public static final OCompressionFactory INSTANCE = new OCompressionFactory();
    private final Map<String, OCompression> compressions = new HashMap<String, OCompression>();

    public OCompressionFactory() {
        this.register(OGZIPCompression.INSTANCE);
        this.register(OSnappyCompression.INSTANCE);
        this.register(ONothingCompression.INSTANCE);
    }

    public OCompression getCompression(String name) {
        OCompression compression = this.compressions.get(name);
        if (compression == null) {
            throw new IllegalArgumentException("Compression with name  " + name + " is absent.");
        }
        return compression;
    }

    public void register(OCompression compression) {
        if (this.compressions.containsKey(compression.name())) {
            throw new IllegalArgumentException("Compression with name " + compression.name() + " was already registered.");
        }
        this.compressions.put(compression.name(), compression);
    }
}

