/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import java.io.IOException;
import java.io.InputStream;

public class OMemoryInputStream
extends InputStream {
    private byte[] buffer;
    private int position = 0;

    public OMemoryInputStream() {
    }

    public OMemoryInputStream(byte[] iBuffer) {
        this.setSource(iBuffer);
    }

    public byte[] getAsByteArrayFixed(int iSize) throws IOException {
        if (this.position >= this.buffer.length) {
            return null;
        }
        byte[] portion = OArrays.copyOfRange((byte[])this.buffer, (int)this.position, (int)(this.position + iSize));
        this.position += iSize;
        return portion;
    }

    public int getAsByteArrayOffset() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        int begin = this.position;
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4 + size;
        return begin;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        int newLen = this.position + len >= this.buffer.length ? this.buffer.length - this.position : len;
        if (off + newLen >= b.length) {
            newLen = b.length - off;
        }
        if (newLen <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.position, b, off, newLen);
        this.position += newLen;
        return newLen;
    }

    public byte[] getAsByteArray(int iOffset) throws IOException {
        if (this.buffer == null || iOffset >= this.buffer.length) {
            return null;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, iOffset);
        if (size == 0) {
            return null;
        }
        return OArrays.copyOfRange((byte[])this.buffer, (int)(iOffset += 4), (int)(iOffset + size));
    }

    public byte[] getAsByteArray() throws IOException {
        if (this.position >= this.buffer.length) {
            return null;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        byte[] portion = OArrays.copyOfRange((byte[])this.buffer, (int)this.position, (int)(this.position + size));
        this.position += size;
        return portion;
    }

    public boolean getAsBoolean() throws IOException {
        return this.buffer[this.position++] == 1;
    }

    public char getAsChar() throws IOException {
        char value = OBinaryProtocol.bytes2char(this.buffer, this.position);
        this.position += 2;
        return value;
    }

    public byte getAsByte() throws IOException {
        return this.buffer[this.position++];
    }

    public long getAsLong() throws IOException {
        long value = OBinaryProtocol.bytes2long(this.buffer, this.position);
        this.position += 8;
        return value;
    }

    public int getAsInteger() throws IOException {
        int value = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        return value;
    }

    public short getAsShort() throws IOException {
        short value = OBinaryProtocol.bytes2short(this.buffer, this.position);
        this.position += 2;
        return value;
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    public byte peek() {
        return this.buffer[this.position];
    }

    public void setSource(byte[] iBuffer) {
        this.buffer = iBuffer;
        this.position = 0;
    }

    public OMemoryInputStream jump(int iOffset) {
        this.position += iOffset;
        return this;
    }

    public byte[] move(int iOffset, int iCopyToOffset) {
        byte[] copy = new byte[this.buffer.length - iOffset + iCopyToOffset];
        System.arraycopy(this.buffer, iOffset, copy, iCopyToOffset, copy.length);
        return copy;
    }

    public byte[] copy() {
        if (this.buffer == null) {
            return null;
        }
        int size = this.position > 0 ? this.position : this.buffer.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.buffer, 0, copy, 0, size);
        return copy;
    }

    public int getVariableSize() throws IOException {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        int size = OBinaryProtocol.bytes2int(this.buffer, this.position);
        this.position += 4;
        return size;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public int getPosition() {
        return this.position;
    }
}

