/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.profiler;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import java.io.File;
import java.util.List;

public class OJVMProfiler
extends OProfiler
implements OMemoryWatchDog.Listener {
    private final int metricProcessors = Runtime.getRuntime().availableProcessors();

    public OJVMProfiler() {
        File[] roots;
        this.registerHookValue(this.getSystemMetric("config.cpus"), "Number of CPUs", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OJVMProfiler.this.metricProcessors;
            }
        });
        this.registerHookValue(this.getSystemMetric("config.os.name"), "Operative System name", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return System.getProperty("os.name");
            }
        });
        this.registerHookValue(this.getSystemMetric("config.os.version"), "Operative System version", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return System.getProperty("os.version");
            }
        });
        this.registerHookValue(this.getSystemMetric("config.os.arch"), "Operative System architecture", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return System.getProperty("os.arch");
            }
        });
        this.registerHookValue(this.getSystemMetric("config.java.vendor"), "Java vendor", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return System.getProperty("java.vendor");
            }
        });
        this.registerHookValue(this.getSystemMetric("config.java.version"), "Java version", OProfiler.METRIC_TYPE.TEXT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return System.getProperty("java.version");
            }
        });
        this.registerHookValue(this.getProcessMetric("runtime.availableMemory"), "Available memory for the process", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.registerHookValue(this.getProcessMetric("runtime.maxMemory"), "Maximum memory usable for the process", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return Runtime.getRuntime().maxMemory();
            }
        });
        this.registerHookValue(this.getProcessMetric("runtime.totalMemory"), "Total memory used by the process", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        File[] fileArray = roots = File.listRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            final File root = fileArray[n2];
            String volumeName = root.getAbsolutePath();
            int pos = volumeName.indexOf(":\\");
            if (pos > -1) {
                volumeName = volumeName.substring(0, pos);
            }
            String metricPrefix = "system.disk." + volumeName;
            this.registerHookValue(String.valueOf(metricPrefix) + ".totalSpace", "Total used disk space", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

                public Object getValue() {
                    return root.getTotalSpace();
                }
            });
            this.registerHookValue(String.valueOf(metricPrefix) + ".freeSpace", "Total free disk space", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

                public Object getValue() {
                    return root.getFreeSpace();
                }
            });
            this.registerHookValue(String.valueOf(metricPrefix) + ".usableSpace", "Total usable disk space", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

                public Object getValue() {
                    return root.getUsableSpace();
                }
            });
            ++n2;
        }
    }

    public String getSystemMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("system.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    public String getProcessMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("process.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    public String getDatabaseMetric(String iDatabaseName, String iMetricName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("db.");
        buffer.append(iDatabaseName);
        buffer.append('.');
        buffer.append(iMetricName);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memoryUsageLow(long iFreeMemory, long iFreeMemoryPercentage) {
        List list = this.snapshots;
        synchronized (list) {
            this.snapshots.clear();
        }
        list = this.summaries;
        synchronized (list) {
            this.summaries.clear();
        }
    }
}

