/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.OProcessException;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OFunctionBlock
extends OAbstractBlock {
    public static final String NAME = "function";

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        OFunction f;
        Object[] args;
        String function = this.getRequiredFieldOfClass(iContext, iConfig, NAME, String.class);
        Collection configuredArgs = this.getFieldOfClass(iContext, iConfig, "args", Collection.class);
        if (configuredArgs != null) {
            args = new Object[configuredArgs.size()];
            int argIdx = 0;
            for (Object arg : configuredArgs) {
                Object[] value = this.resolveValue(iContext, arg, true);
                if (value instanceof List) {
                    value = ((List)value).toArray();
                }
                args[argIdx++] = value;
            }
        } else {
            args = null;
        }
        if ((f = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getFunctionLibrary().getFunction(function)) != null) {
            this.debug(iContext, "Calling database function: " + function + "(" + Arrays.toString(args) + ")...", new Object[0]);
            return f.executeInContext(iContext, args);
        }
        int lastDot = function.lastIndexOf(46);
        if (lastDot > -1) {
            String clsName = function.substring(0, lastDot);
            String methodName = function.substring(lastDot + 1);
            Class<?> cls = null;
            try {
                cls = Class.forName(clsName);
                Class[] argTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argTypes[i] = args[i] == null ? null : args[i].getClass();
                }
                Method m = cls.getMethod(methodName, argTypes);
                this.debug(iContext, "Calling Java function: " + m + "(" + Arrays.toString(args).replace("%", "%%") + ")...", new Object[0]);
                return m.invoke(null, args);
            }
            catch (NoSuchMethodException e) {
                for (Method m : cls.getMethods()) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != args.length) continue;
                    try {
                        this.debug(iContext, "Calling Java function: " + m + "(" + Arrays.toString(args) + ")...", new Object[0]);
                        return m.invoke(null, args);
                    }
                    catch (IllegalArgumentException e1) {
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        throw new OProcessException("Error on call function '" + function + "'", e);
                    }
                }
                this.debug(iContext, "Method not found: " + clsName + "." + methodName + "(" + Arrays.toString(args) + ")", new Object[0]);
                for (Method m : cls.getMethods()) {
                    StringBuilder candidates = new StringBuilder();
                    if (m.getName().equals(methodName)) {
                        candidates.append("-" + m + "\n");
                    }
                    if (candidates.length() > 0) {
                        this.debug(iContext, "Candidate methods were: \n" + candidates, new Object[0]);
                        continue;
                    }
                    this.debug(iContext, "No candidate methods were found", new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new OProcessException("Function '" + function + "' was not found because the class '" + clsName + "' was not found");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new OProcessException("Function '" + function + "' was not found");
    }

    @Override
    public String getName() {
        return NAME;
    }
}

