/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import java.util.List;

public class ODatabaseFunction
implements OSQLFunction {
    private final OFunction f;

    public ODatabaseFunction(OFunction f) {
        this.f = f;
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iFuncParams, OCommandContext iContext) {
        return this.f.executeInContext(iContext, iFuncParams);
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public boolean filterResult() {
        return false;
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public int getMinParams() {
        return 0;
    }

    @Override
    public int getMaxParams() {
        return this.f.getParameters().size();
    }

    @Override
    public String getSyntax() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.f.getName());
        buffer.append('(');
        List<String> params = this.f.getParameters();
        for (int p = 0; p < params.size(); ++p) {
            if (p > 0) {
                buffer.append(',');
            }
            buffer.append(params.get(p));
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public void setResult(Object iResult) {
    }

    @Override
    public void config(Object[] configuredParameters) {
    }

    @Override
    public boolean shouldMergeDistributedResult() {
        return false;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        return null;
    }
}

