/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ORecordIteratorClusters<REC extends ORecordInternal<?>>
extends OIdentifiableIterator<REC> {
    protected int[] clusterIds;
    protected int currentClusterIdx;
    protected ORecord<?> currentRecord;
    protected ORID beginRange;
    protected ORID endRange;

    public ORecordIteratorClusters(ODatabaseRecord iDatabase, ODatabaseRecord iLowLevelDatabase, int[] iClusterIds, boolean iUseCache, boolean iterateThroughTombstones) {
        super(iDatabase, iLowLevelDatabase, iUseCache, iterateThroughTombstones);
        this.clusterIds = iClusterIds;
        this.config();
    }

    protected ORecordIteratorClusters(ODatabaseRecord iDatabase, ODatabaseRecord iLowLevelDatabase, boolean iUseCache, boolean iterateThroughTombstones) {
        super(iDatabase, iLowLevelDatabase, iUseCache, iterateThroughTombstones);
    }

    public ORecordIteratorClusters<REC> setRange(ORID iBegin, ORID iEnd) {
        this.beginRange = iBegin;
        this.endRange = iEnd;
        if (this.currentRecord != null && this.outsideOfTheRange(this.currentRecord.getIdentity().getClusterPosition())) {
            this.currentRecord = null;
        }
        return this;
    }

    @Override
    public boolean hasPrevious() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.currentClusterIdx > -1) {
            while (this.prevPosition()) {
                this.currentRecord = this.readCurrentRecord(record, 0);
                if (this.currentRecord == null || !this.include(this.currentRecord)) continue;
                return true;
            }
            --this.currentClusterIdx;
            this.updateClusterRange();
        }
        if (this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0) {
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        this.checkDirection(true);
        if (Thread.interrupted()) {
            return false;
        }
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.currentClusterIdx < this.clusterIds.length) {
            while (this.nextPosition()) {
                OClusterPosition currentPosition = this.currentPosition();
                if (this.outsideOfTheRange(currentPosition)) continue;
                this.currentRecord = this.readCurrentRecord(record, 0);
                if (this.currentRecord == null || !this.include(this.currentRecord)) continue;
                return true;
            }
            ++this.currentClusterIdx;
            if (this.currentClusterIdx >= this.clusterIds.length) break;
            this.updateClusterRange();
        }
        if (this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0) {
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    private boolean outsideOfTheRange(OClusterPosition currentPosition) {
        if (this.beginRange != null && currentPosition.compareTo(this.beginRange.getClusterPosition()) < 0) {
            return true;
        }
        return this.endRange != null && currentPosition.compareTo(this.endRange.getClusterPosition()) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REC next() {
        ORecordInternal<?> record;
        this.checkDirection(true);
        if (this.currentRecord != null) {
            try {
                ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                return (REC)oRecordInternal;
            }
            finally {
                this.currentRecord = null;
            }
        }
        while (this.hasNext()) {
            if (this.currentRecord != null) {
                try {
                    ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                    return (REC)oRecordInternal;
                }
                finally {
                    this.currentRecord = null;
                }
            }
            record = this.getTransactionEntry();
            if (record == null) {
                record = this.readCurrentRecord(null, 1);
            }
            if (record == null || !this.include(record)) continue;
            return (REC)record;
        }
        record = this.getTransactionEntry();
        if (record != null) {
            return (REC)record;
        }
        throw new NoSuchElementException("Direction: forward, last position was: " + this.current + ", range: " + this.beginRange + "-" + this.endRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REC previous() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            try {
                ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                return (REC)oRecordInternal;
            }
            finally {
                this.currentRecord = null;
            }
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.hasPrevious()) {
            if (this.currentRecord != null) {
                try {
                    ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                    return (REC)oRecordInternal;
                }
                finally {
                    this.currentRecord = null;
                }
            }
            if (record == null) {
                record = this.readCurrentRecord(null, -1);
            }
            if (record == null || !this.include(record)) continue;
            return (REC)record;
        }
        record = this.getTransactionEntry();
        if (record != null) {
            return (REC)record;
        }
        return null;
    }

    protected boolean include(ORecord<?> iRecord) {
        return true;
    }

    @Override
    public ORecordIteratorClusters<REC> begin() {
        this.currentClusterIdx = 0;
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        this.resetCurrentPosition();
        this.nextPosition();
        ORecordInternal<?> record = this.getRecord();
        this.currentRecord = this.readCurrentRecord(record, 0);
        return this;
    }

    @Override
    public ORecordIteratorClusters<REC> last() {
        this.currentClusterIdx = this.clusterIds.length - 1;
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        this.current.clusterId = this.currentClusterIdx;
        this.resetCurrentPosition();
        this.prevPosition();
        ORecordInternal<?> record = this.getRecord();
        this.currentRecord = this.readCurrentRecord(record, 0);
        return this;
    }

    @Override
    public ORecordIteratorClusters<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        if (iLiveUpdated) {
            this.firstClusterEntry = OClusterPositionFactory.INSTANCE.valueOf(0L);
            this.lastClusterEntry = OClusterPositionFactory.INSTANCE.getMaxValue();
        } else {
            this.updateClusterRange();
        }
        return this;
    }

    protected void updateClusterRange() {
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        OClusterPosition[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        this.firstClusterEntry = range[0];
        this.lastClusterEntry = range[1];
        this.resetCurrentPosition();
    }

    protected void config() {
        if (this.clusterIds.length == 0) {
            return;
        }
        this.currentClusterIdx = 0;
        this.updateClusterRange();
        this.totalAvailableRecords = this.database.countClusterElements(this.clusterIds, this.isIterateThroughTombstones());
        this.txEntries = this.database.getTransaction().getNewRecordEntriesByClusterIds(this.clusterIds);
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                if (entry.getRecord().getIdentity().isTemporary() && entry.type != 2) {
                    ++this.totalAvailableRecords;
                    continue;
                }
                if (entry.type != 2) continue;
                --this.totalAvailableRecords;
            }
        }
        this.begin();
    }

    public String toString() {
        return String.format("ORecordIteratorCluster.clusters(%s).currentRecord(%s).range(%s-%s)", Arrays.toString(this.clusterIds), this.currentRecord, this.beginRange, this.endRange);
    }
}

