/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllLRUListEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.LRUEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.LRUList;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OBlockedPageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.CRC32;

public class O2QCache
implements ODiskCache {
    public static final long MAGIC_NUMBER = 4207608830L;
    public final int writeQueueLength;
    private int maxSize;
    private int K_IN;
    private int K_OUT;
    private final int pageSize;
    private LRUList am;
    private LRUList a1out;
    private LRUList a1in;
    private final ODirectMemory directMemory;
    private final Map<Long, OFileClassic> files;
    private final Map<FileLockKey, Long> evictedPages;
    private final Map<Long, Set<Long>> filePages;
    private final Map<Long, SortedMap<Long, OLogSequenceNumber>> dirtyPages;
    private final Object syncObject;
    private final OStorageLocalAbstract storageLocal;
    private final OWriteAheadLog writeAheadLog;
    private final boolean syncOnPageFlush;
    private long fileCounter = 1L;
    private int crcOffset;

    public O2QCache(long maxMemory, int writeQueueLength, ODirectMemory directMemory, OWriteAheadLog writeAheadLog, int pageSize, OStorageLocalAbstract storageLocal, boolean syncOnPageFlush) {
        this.writeQueueLength = writeQueueLength;
        this.writeAheadLog = writeAheadLog;
        this.directMemory = directMemory;
        this.pageSize = pageSize;
        this.storageLocal = storageLocal;
        this.syncOnPageFlush = syncOnPageFlush;
        this.files = new HashMap<Long, OFileClassic>();
        this.filePages = new HashMap<Long, Set<Long>>();
        this.dirtyPages = new HashMap<Long, SortedMap<Long, OLogSequenceNumber>>();
        this.evictedPages = new HashMap<FileLockKey, Long>();
        long tmpMaxSize = maxMemory / (long)pageSize;
        this.maxSize = tmpMaxSize >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)tmpMaxSize;
        this.K_IN = this.maxSize >> 2;
        this.K_OUT = this.maxSize >> 1;
        this.am = new LRUList();
        this.a1out = new LRUList();
        this.a1in = new LRUList();
        this.syncObject = new Object();
    }

    LRUList getAm() {
        return this.am;
    }

    LRUList getA1out() {
        return this.a1out;
    }

    LRUList getA1in() {
        return this.a1in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            long fileId = this.fileCounter++;
            OFileClassic fileClassic = new OFileClassic();
            String path = this.storageLocal.getVariableParser().resolveVariables(String.valueOf(this.storageLocal.getStoragePath()) + File.separator + fileName);
            fileClassic.init(path, this.storageLocal.getMode());
            if (fileClassic.exists()) {
                fileClassic.open();
            } else {
                fileClassic.create(-1);
            }
            this.files.put(fileId, fileClassic);
            this.filePages.put(fileId, new HashSet());
            this.dirtyPages.put(fileId, new TreeMap());
            return fileId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDirty(long fileId, long pageIndex) {
        Object object = this.syncObject;
        synchronized (object) {
            LRUEntry lruEntry = this.a1in.get(fileId, pageIndex);
            if (lruEntry != null) {
                this.doMarkDirty(fileId, pageIndex, lruEntry);
                return;
            }
            lruEntry = this.am.get(fileId, pageIndex);
            if (lruEntry == null) {
                throw new IllegalStateException("Requested page number " + pageIndex + " for file " + this.files.get(fileId).getName() + " is not in cache");
            }
            this.doMarkDirty(fileId, pageIndex, lruEntry);
        }
    }

    private void doMarkDirty(long fileId, long pageIndex, LRUEntry lruEntry) {
        if (lruEntry.isDirty) {
            return;
        }
        assert (pageIndex >= 0L);
        this.dirtyPages.get(fileId).put(pageIndex, lruEntry.loadedLSN);
        lruEntry.isDirty = true;
    }

    private OLogSequenceNumber getLogSequenceNumberFromPage(long dataPointer) {
        long position = OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, dataPointer + 8L + 8L);
        int segment = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, dataPointer + 8L + 4L);
        return new OLogSequenceNumber(segment, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long load(long fileId, long pageIndex) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            LRUEntry lruEntry = this.updateCache(fileId, pageIndex);
            ++lruEntry.usageCounter;
            return lruEntry.dataPointer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(long fileId, long pageIndex) {
        Object object = this.syncObject;
        synchronized (object) {
            LRUEntry lruEntry = this.get(fileId, pageIndex, false);
            if (lruEntry != null) {
                --lruEntry.usageCounter;
            } else {
                throw new IllegalStateException("record should be released is already free!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return this.files.get(fileId).getFilledUpTo() / (long)this.pageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                return;
            }
            SortedMap<Long, OLogSequenceNumber> dirtyPages = this.dirtyPages.get(fileId);
            Iterator<Long> iterator = dirtyPages.keySet().iterator();
            while (iterator.hasNext()) {
                Long pageIndex = iterator.next();
                LRUEntry lruEntry = this.get(fileId, pageIndex, false);
                if (lruEntry == null) {
                    Long dataPointer = this.evictedPages.remove(new FileLockKey(fileId, pageIndex));
                    if (dataPointer == null) continue;
                    this.flushData(fileId, pageIndex, dataPointer);
                    iterator.remove();
                    continue;
                }
                if (lruEntry.usageCounter == 0) {
                    this.flushData(fileId, lruEntry.pageIndex, lruEntry.dataPointer);
                    iterator.remove();
                    lruEntry.isDirty = false;
                    continue;
                }
                throw new OBlockedPageException("Unable to perform flush file because some pages is in use.");
            }
            fileClassic.synch();
        }
    }

    @Override
    public void closeFile(long fileId) throws IOException {
        this.closeFile(fileId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closeFile(long fileId, boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                return;
            }
            Set<Long> pageIndexes = this.filePages.get(fileId);
            Object[] sortedPageIndexes = new Long[pageIndexes.size()];
            sortedPageIndexes = pageIndexes.toArray(sortedPageIndexes);
            Arrays.sort(sortedPageIndexes);
            SortedMap<Long, OLogSequenceNumber> fileDirtyPages = this.dirtyPages.get(fileId);
            Object[] objectArray = sortedPageIndexes;
            int n = sortedPageIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                Object pageIndex = objectArray[n2];
                LRUEntry lruEntry = this.get(fileId, (Long)pageIndex, true);
                if (lruEntry != null) {
                    if (lruEntry.usageCounter != 0) throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + "can not be freed because it is used.");
                    lruEntry = this.remove(fileId, (Long)pageIndex);
                    fileDirtyPages.remove(pageIndex);
                    if (lruEntry.dataPointer != 0L) {
                        if (flush) {
                            this.flushData(fileId, (Long)pageIndex, lruEntry.dataPointer);
                        }
                        this.directMemory.free(lruEntry.dataPointer);
                    }
                } else {
                    Long dataPointer = this.evictedPages.remove(new FileLockKey(fileId, (Long)pageIndex));
                    if (dataPointer != null) {
                        if (flush) {
                            this.flushData(fileId, (Long)pageIndex, dataPointer);
                        }
                        fileDirtyPages.remove(pageIndex);
                    }
                }
                ++n2;
            }
            pageIndexes.clear();
            fileClassic.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.files.containsKey(fileId)) {
                return;
            }
            if (this.isOpen(fileId)) {
                this.truncateFile(fileId);
            }
            this.files.get(fileId).delete();
            this.files.remove(fileId);
            this.filePages.remove(fileId);
            this.dirtyPages.remove(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            Set<Long> pageEntries = this.filePages.get(fileId);
            for (Long pageIndex : pageEntries) {
                LRUEntry lruEntry = this.get(fileId, pageIndex, true);
                if (lruEntry != null) {
                    if (lruEntry.usageCounter != 0) continue;
                    lruEntry = this.remove(fileId, pageIndex);
                    if (lruEntry.dataPointer == 0L) continue;
                    this.directMemory.free(lruEntry.dataPointer);
                    continue;
                }
                Long dataPointer = this.evictedPages.remove(new FileLockKey(fileId, pageIndex));
                if (dataPointer == null) continue;
                this.directMemory.free(dataPointer.longValue());
            }
            SortedMap<Long, OLogSequenceNumber> fileDirtyPages = this.dirtyPages.get(fileId);
            for (long pageIndex : fileDirtyPages.keySet()) {
                Long dataPointer = this.evictedPages.remove(new FileLockKey(fileId, pageIndex));
                if (dataPointer == null) continue;
                this.directMemory.free(dataPointer.longValue());
            }
            pageEntries.clear();
            fileDirtyPages.clear();
            this.files.get(fileId).shrink(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.files.containsKey(fileId)) {
                return;
            }
            OFileClassic file = this.files.get(fileId);
            String osFileName = file.getName();
            if (osFileName.startsWith(oldFileName)) {
                File newFile = new File(String.valueOf(this.storageLocal.getStoragePath()) + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                boolean renamed = file.renameTo(newFile);
                while (!renamed) {
                    OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                    renamed = file.renameTo(newFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushBuffer() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            for (long fileId : this.files.keySet()) {
                this.flushFile(fileId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.flushBuffer();
            this.am.clear();
            this.a1in.clear();
            this.a1out.clear();
            for (Set<Long> set : this.filePages.values()) {
                set.clear();
            }
            for (SortedMap sortedMap : this.dirtyPages.values()) {
                sortedMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.clear();
            for (OFileClassic fileClassic : this.files.values()) {
                if (!fileClassic.isOpen()) continue;
                fileClassic.synch();
                fileClassic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasSoftlyClosed(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic;
            block4: {
                fileClassic = this.files.get(fileId);
                if (fileClassic != null) break block4;
                return false;
            }
            return fileClassic.wasSoftlyClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoftlyClosed(long fileId, boolean softlyClosed) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                fileClassic.setSoftlyClosed(softlyClosed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                return fileClassic.isOpen();
            }
        }
        return false;
    }

    private LRUEntry updateCache(long fileId, long pageIndex) throws IOException {
        LRUEntry lruEntry = this.am.get(fileId, pageIndex);
        if (lruEntry != null) {
            lruEntry = this.am.putToMRU(fileId, pageIndex, lruEntry.dataPointer, lruEntry.isDirty, lruEntry.loadedLSN);
            return lruEntry;
        }
        lruEntry = this.a1out.remove(fileId, pageIndex);
        if (lruEntry != null) {
            this.removeColdestPageIfNeeded();
            CacheResult cacheResult = this.cacheFileContent(fileId, pageIndex);
            lruEntry.dataPointer = cacheResult.dataPointer;
            lruEntry.isDirty = cacheResult.isDirty;
            OLogSequenceNumber lsn = cacheResult.isDirty ? (OLogSequenceNumber)this.dirtyPages.get(fileId).get(pageIndex) : this.getLogSequenceNumberFromPage(cacheResult.dataPointer);
            lruEntry = this.am.putToMRU(fileId, pageIndex, lruEntry.dataPointer, lruEntry.isDirty, lsn);
            return lruEntry;
        }
        lruEntry = this.a1in.get(fileId, pageIndex);
        if (lruEntry != null) {
            return lruEntry;
        }
        this.removeColdestPageIfNeeded();
        CacheResult cacheResult = this.cacheFileContent(fileId, pageIndex);
        OLogSequenceNumber lsn = cacheResult.isDirty ? (OLogSequenceNumber)this.dirtyPages.get(fileId).get(pageIndex) : this.getLogSequenceNumberFromPage(cacheResult.dataPointer);
        lruEntry = this.a1in.putToMRU(fileId, pageIndex, cacheResult.dataPointer, cacheResult.isDirty, lsn);
        this.filePages.get(fileId).add(pageIndex);
        return lruEntry;
    }

    private void removeColdestPageIfNeeded() throws IOException {
        if (this.am.size() + this.a1in.size() >= this.maxSize) {
            if (this.a1in.size() > this.K_IN) {
                LRUEntry removedFromAInEntry = this.a1in.removeLRU();
                if (removedFromAInEntry == null) {
                    this.increaseCacheSize();
                } else {
                    assert (removedFromAInEntry.usageCounter == 0);
                    this.evictFileContent(removedFromAInEntry.fileId, removedFromAInEntry.pageIndex, removedFromAInEntry.dataPointer, removedFromAInEntry.isDirty);
                    this.a1out.putToMRU(removedFromAInEntry.fileId, removedFromAInEntry.pageIndex, 0L, false, null);
                }
                if (this.a1out.size() > this.K_OUT) {
                    LRUEntry removedEntry = this.a1out.removeLRU();
                    assert (removedEntry.usageCounter == 0);
                    Set<Long> pageEntries = this.filePages.get(removedEntry.fileId);
                    pageEntries.remove(removedEntry.pageIndex);
                }
            } else {
                LRUEntry removedEntry = this.am.removeLRU();
                if (removedEntry == null) {
                    this.increaseCacheSize();
                } else {
                    assert (removedEntry.usageCounter == 0);
                    this.evictFileContent(removedEntry.fileId, removedEntry.pageIndex, removedEntry.dataPointer, removedEntry.isDirty);
                    Set<Long> pageEntries = this.filePages.get(removedEntry.fileId);
                    pageEntries.remove(removedEntry.pageIndex);
                }
            }
        }
    }

    private void increaseCacheSize() {
        String message = "All records in aIn queue in 2q cache are used!";
        OLogManager.instance().warn((Object)this, message, new Object[0]);
        if (!OGlobalConfiguration.SERVER_CACHE_2Q_INCREASE_ON_DEMAND.getValueAsBoolean()) {
            throw new OAllLRUListEntriesAreUsedException(message);
        }
        OLogManager.instance().warn((Object)this, "Cache size will be increased.", new Object[0]);
        this.maxSize = (int)Math.ceil((float)this.maxSize * (1.0f + OGlobalConfiguration.SERVER_CACHE_2Q_INCREASE_STEP.getValueAsFloat()));
        this.K_IN = this.maxSize >> 2;
        this.K_OUT = this.maxSize >> 1;
    }

    private CacheResult cacheFileContent(long fileId, long pageIndex) throws IOException {
        long dataPointer;
        FileLockKey key = new FileLockKey(fileId, pageIndex);
        if (this.evictedPages.containsKey(key)) {
            return new CacheResult(true, this.evictedPages.remove(key));
        }
        OFileClassic fileClassic = this.files.get(fileId);
        long startPosition = pageIndex * (long)this.pageSize;
        long endPosition = startPosition + (long)this.pageSize;
        byte[] content = new byte[this.pageSize];
        if (fileClassic.getFilledUpTo() >= endPosition) {
            fileClassic.read(startPosition, content, content.length);
            dataPointer = this.directMemory.allocate(content);
        } else {
            fileClassic.allocateSpace((int)(endPosition - fileClassic.getFilledUpTo()));
            dataPointer = this.directMemory.allocate(content);
        }
        return new CacheResult(false, dataPointer);
    }

    private void evictFileContent(long fileId, long pageIndex, long dataPointer, boolean isDirty) throws IOException {
        if (isDirty) {
            if (this.evictedPages.size() >= this.writeQueueLength) {
                this.flushEvictedPages();
            }
            this.evictedPages.put(new FileLockKey(fileId, pageIndex), dataPointer);
        } else {
            this.directMemory.free(dataPointer);
        }
    }

    private void flushData(long fileId, long pageIndex, long dataPointer) throws IOException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = this.getLogSequenceNumberFromPage(dataPointer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLSN();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = this.directMemory.get(dataPointer, this.pageSize);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(4207608830L), content, 0);
        int crc32 = this.calculatePageCrc(content);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(crc32), content, 8);
        OFileClassic fileClassic = this.files.get(fileId);
        fileClassic.write(pageIndex * (long)this.pageSize, content);
        if (this.syncOnPageFlush) {
            fileClassic.synch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        Object object = this.syncObject;
        synchronized (object) {
            for (long fileId : this.files.keySet()) {
                boolean fileIsCorrect;
                OFileClassic fileClassic = this.files.get(fileId);
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flushFile(fileId);
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFilledUpTo();
                    fileIsCorrect = true;
                    long pos = 0L;
                    while (pos < filledUpTo) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not much !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if ((storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8).intValue()) != (calculatedCRC32 = this.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener != null && System.currentTimeMillis() - time > 5000L) {
                            time = 5000L;
                            commandOutputListener.onMessage(String.valueOf(pos / (long)this.pageSize) + " pages were processed ...");
                        }
                        pos += (long)this.pageSize;
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file " + fileClassic.getName() + ". " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is successfully finished.");
            }
            return errors.toArray(new OPageDataVerificationError[errors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ODirtyPage> logDirtyPagesTable() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.writeAheadLog == null) {
                return Collections.emptySet();
            }
            HashSet<ODirtyPage> logDirtyPages = new HashSet<ODirtyPage>(this.dirtyPages.size());
            for (long fileId : this.dirtyPages.keySet()) {
                SortedMap<Long, OLogSequenceNumber> pages = this.dirtyPages.get(fileId);
                for (Map.Entry<Long, OLogSequenceNumber> pageEntry : pages.entrySet()) {
                    ODirtyPage logDirtyPage = new ODirtyPage(this.files.get(fileId).getName(), pageEntry.getKey(), pageEntry.getValue());
                    logDirtyPages.add(logDirtyPage);
                }
            }
            this.writeAheadLog.logDirtyPages(logDirtyPages);
            return logDirtyPages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceSyncStoredChanges() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            for (OFileClassic fileClassic : this.files.values()) {
                fileClassic.synch();
            }
        }
    }

    private void flushEvictedPages() throws IOException {
        Map.Entry[] sortedPages = this.evictedPages.entrySet().toArray(new Map.Entry[this.evictedPages.size()]);
        Arrays.sort(sortedPages, new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry entryOne, Map.Entry entryTwo) {
                FileLockKey fileLockKeyOne = (FileLockKey)entryOne.getKey();
                FileLockKey fileLockKeyTwo = (FileLockKey)entryTwo.getKey();
                return fileLockKeyOne.compareTo(fileLockKeyTwo);
            }
        });
        Map.Entry[] entryArray = sortedPages;
        int n = sortedPages.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry = entryArray[n2];
            long evictedDataPointer = (Long)entry.getValue();
            FileLockKey fileLockKey = (FileLockKey)entry.getKey();
            this.flushData(fileLockKey.fileId, fileLockKey.pageIndex, evictedDataPointer);
            this.dirtyPages.get(fileLockKey.fileId).remove(fileLockKey.pageIndex);
            this.directMemory.free(evictedDataPointer);
            ++n2;
        }
        this.evictedPages.clear();
    }

    int getMaxSize() {
        return this.maxSize;
    }

    private LRUEntry get(long fileId, long pageIndex, boolean useOutQueue) {
        LRUEntry lruEntry = this.am.get(fileId, pageIndex);
        if (lruEntry != null) {
            return lruEntry;
        }
        if (useOutQueue && (lruEntry = this.a1out.get(fileId, pageIndex)) != null) {
            return lruEntry;
        }
        lruEntry = this.a1in.get(fileId, pageIndex);
        return lruEntry;
    }

    private LRUEntry remove(long fileId, long pageIndex) {
        LRUEntry lruEntry = this.am.remove(fileId, pageIndex);
        if (lruEntry != null) {
            if (lruEntry.usageCounter > 1) {
                throw new IllegalStateException("Record cannot be removed because it is used!");
            }
            return lruEntry;
        }
        lruEntry = this.a1out.remove(fileId, pageIndex);
        if (lruEntry != null) {
            return lruEntry;
        }
        lruEntry = this.a1in.remove(fileId, pageIndex);
        if (lruEntry != null && lruEntry.usageCounter > 1) {
            throw new IllegalStateException("Record cannot be removed because it is used!");
        }
        return lruEntry;
    }

    private int calculatePageCrc(byte[] pageData) {
        int systemSize = 12;
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, systemSize, pageData.length - systemSize);
        return (int)crc32.getValue();
    }

    private static class CacheResult {
        private final boolean isDirty;
        private final long dataPointer;

        private CacheResult(boolean dirty, long dataPointer) {
            this.isDirty = dirty;
            this.dataPointer = dataPointer;
        }
    }

    private static final class FileLockKey
    implements Comparable<FileLockKey> {
        private final long fileId;
        private final long pageIndex;

        private FileLockKey(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileLockKey that = (FileLockKey)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        @Override
        public int compareTo(FileLockKey otherKey) {
            if (this.fileId > otherKey.fileId) {
                return 1;
            }
            if (this.fileId < otherKey.fileId) {
                return -1;
            }
            if (this.pageIndex > otherKey.pageIndex) {
                return 1;
            }
            if (this.pageIndex < otherKey.pageIndex) {
                return -1;
            }
            return 0;
        }
    }
}

