/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.hash.OMurmurHash3;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.LRUEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.util.Iterator;
import java.util.NoSuchElementException;

class LRUList
implements Iterable<LRUEntry> {
    private static final int SEED = 362498820;
    private LRUEntry head;
    private LRUEntry tail;
    private int nextThreshold;
    private int size;
    private LRUEntry[] entries = new LRUEntry[1024];

    public LRUList() {
        this.nextThreshold = (int)((double)this.entries.length * 0.75);
    }

    public LRUEntry get(long fileId, long pageIndex) {
        long hashCode = this.hashCode(fileId, pageIndex);
        int index = this.index(hashCode);
        LRUEntry lruEntry = this.entries[index];
        while (lruEntry != null && (lruEntry.hashCode != hashCode || lruEntry.pageIndex != pageIndex || lruEntry.fileId != fileId)) {
            lruEntry = lruEntry.next;
        }
        return lruEntry;
    }

    public LRUEntry remove(long fileId, long pageIndex) {
        long hashCode = this.hashCode(fileId, pageIndex);
        int index = this.index(hashCode);
        LRUEntry lruEntry = this.entries[index];
        LRUEntry prevEntry = null;
        while (lruEntry != null && (lruEntry.hashCode != hashCode || lruEntry.fileId != fileId || lruEntry.pageIndex != pageIndex)) {
            prevEntry = lruEntry;
            lruEntry = lruEntry.next;
        }
        if (lruEntry == null) {
            return null;
        }
        assert (this.tail == null || this.tail.before != this.tail);
        assert (this.tail == null || this.tail.after == null);
        this.removeFromLRUList(lruEntry);
        if (prevEntry == null) {
            this.entries[index] = lruEntry.next;
        } else {
            prevEntry.next = lruEntry.next;
        }
        assert (this.tail == null || this.tail.before != this.tail);
        assert (this.tail == null || this.tail.after == null);
        --this.size;
        return lruEntry;
    }

    private void removeFromLRUList(LRUEntry lruEntry) {
        LRUEntry before = lruEntry.before;
        LRUEntry after = lruEntry.after;
        if (before != null) {
            before.after = after;
        }
        if (after != null) {
            after.before = before;
        }
        if (lruEntry == this.head) {
            this.head = lruEntry.after;
        }
        if (lruEntry == this.tail) {
            this.tail = lruEntry.before;
        }
    }

    public LRUEntry putToMRU(long fileId, long pageIndex, long dataPointer, boolean isDirty, OLogSequenceNumber loadedLSN) {
        long hashCode = this.hashCode(fileId, pageIndex);
        int index = this.index(hashCode);
        LRUEntry lruEntry = this.entries[index];
        LRUEntry prevEntry = null;
        while (lruEntry != null && (lruEntry.hashCode != hashCode || lruEntry.fileId != fileId || lruEntry.pageIndex != pageIndex)) {
            prevEntry = lruEntry;
            lruEntry = lruEntry.next;
        }
        assert (this.tail == null || this.tail.before != this.tail);
        assert (this.tail == null || this.tail.after == null);
        if (lruEntry == null) {
            lruEntry = new LRUEntry();
            lruEntry.pageIndex = pageIndex;
            lruEntry.fileId = fileId;
            lruEntry.hashCode = hashCode;
            if (prevEntry == null) {
                this.entries[index] = lruEntry;
            } else {
                prevEntry.next = lruEntry;
            }
            ++this.size;
        }
        lruEntry.dataPointer = dataPointer;
        lruEntry.isDirty = isDirty;
        lruEntry.loadedLSN = loadedLSN;
        this.removeFromLRUList(lruEntry);
        if (this.head == null) {
            this.head = lruEntry;
            this.tail = lruEntry;
            lruEntry.before = null;
            lruEntry.after = null;
        } else {
            this.tail.after = lruEntry;
            lruEntry.before = this.tail;
            lruEntry.after = null;
            this.tail = lruEntry;
        }
        assert (this.tail.before != this.tail);
        assert (this.tail.after == null);
        if (this.size >= this.nextThreshold) {
            this.rehash();
        }
        return lruEntry;
    }

    public void clear() {
        this.entries = new LRUEntry[1024];
        this.nextThreshold = (int)((double)this.entries.length * 0.75);
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    private void rehash() {
        long len = this.entries.length << 1;
        if (len >= Integer.MAX_VALUE) {
            if (this.entries.length < Integer.MAX_VALUE) {
                len = Integer.MAX_VALUE;
            } else {
                return;
            }
        }
        LRUEntry[] oldLruEntries = this.entries;
        this.entries = new LRUEntry[(int)len];
        LRUEntry[] arr$ = oldLruEntries;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LRUEntry oldLruEntry;
            LRUEntry currentLRUEntry = oldLruEntry = arr$[i$];
            while (currentLRUEntry != null) {
                int index = this.index(currentLRUEntry.hashCode);
                LRUEntry nexEntry = currentLRUEntry.next;
                this.appendEntry(index, currentLRUEntry);
                currentLRUEntry = nexEntry;
            }
        }
        this.nextThreshold = (int)((double)this.entries.length * 0.75);
    }

    private void appendEntry(int index, LRUEntry entry) {
        LRUEntry lruEntry = this.entries[index];
        if (lruEntry == null) {
            this.entries[index] = entry;
        } else {
            while (lruEntry.next != null) {
                lruEntry = lruEntry.next;
            }
            lruEntry.next = entry;
        }
        entry.next = null;
    }

    public boolean contains(long fileId, long filePosition) {
        return this.get(fileId, filePosition) != null;
    }

    public int size() {
        return this.size;
    }

    public LRUEntry removeLRU() {
        LRUEntry entryToRemove = this.head;
        while (entryToRemove != null && entryToRemove.usageCounter != 0) {
            entryToRemove = entryToRemove.after;
        }
        if (entryToRemove != null) {
            return this.remove(entryToRemove.fileId, entryToRemove.pageIndex);
        }
        return null;
    }

    public LRUEntry getLRU() {
        return this.head;
    }

    @Override
    public Iterator<LRUEntry> iterator() {
        return new MRUEntryIterator();
    }

    private int index(long hashCode) {
        return (int)((long)(this.entries.length - 1) & hashCode);
    }

    private long hashCode(long fileId, long filePosition) {
        byte[] result = new byte[16];
        OLongSerializer.INSTANCE.serialize(Long.valueOf(fileId), result, 8);
        OLongSerializer.INSTANCE.serialize(Long.valueOf(filePosition), result, 8);
        return OMurmurHash3.murmurHash3_x64_64((byte[])result, (int)362498820);
    }

    private final class MRUEntryIterator
    implements Iterator<LRUEntry> {
        private LRUEntry current;

        private MRUEntryIterator() {
            this.current = LRUList.this.tail;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public LRUEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LRUEntry entry = this.current;
            this.current = entry.before;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

