/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;

class LRUEntry {
    long fileId;
    long pageIndex;
    OLogSequenceNumber loadedLSN;
    long dataPointer;
    boolean isDirty;
    long hashCode;
    int usageCounter = 0;
    LRUEntry next;
    LRUEntry after;
    LRUEntry before;

    LRUEntry() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LRUEntry lruEntry = (LRUEntry)o;
        if (this.dataPointer != lruEntry.dataPointer) {
            return false;
        }
        if (this.fileId != lruEntry.fileId) {
            return false;
        }
        if (this.isDirty != lruEntry.isDirty) {
            return false;
        }
        if (this.pageIndex != lruEntry.pageIndex) {
            return false;
        }
        return !(this.loadedLSN != null ? !this.loadedLSN.equals(lruEntry.loadedLSN) : lruEntry.loadedLSN != null);
    }

    public int hashCode() {
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        result = 31 * result + (this.loadedLSN != null ? this.loadedLSN.hashCode() : 0);
        result = 31 * result + (int)(this.dataPointer ^ this.dataPointer >>> 32);
        result = 31 * result + (this.isDirty ? 1 : 0);
        return result;
    }

    public String toString() {
        return "LRUEntry{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", loadedLSN=" + this.loadedLSN + ", dataPointer=" + this.dataPointer + ", isDirty=" + this.isDirty + ", hashCode=" + this.hashCode + ", usageCounter=" + this.usageCounter + '}';
    }
}

