/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.serialization.types.OBooleanSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.OHashTreeNodeMetadata;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import java.io.IOException;

public class OHashIndexTreeStateStore
extends OSingleFileSegment {
    private static final int RECORD_SIZE = 2052;

    public OHashIndexTreeStateStore(String iPath, String iType) throws IOException {
        super(iPath, iType);
    }

    public OHashIndexTreeStateStore(OStorageLocalAbstract iStorage, OStorageFileConfiguration iConfig) throws IOException {
        super(iStorage, iConfig);
    }

    public OHashIndexTreeStateStore(OStorageLocalAbstract iStorage, OStorageFileConfiguration iConfig, String iType) throws IOException {
        super(iStorage, iConfig, iType);
    }

    public void setHashTreeSize(long hashTreeSize) throws IOException {
        this.file.writeHeaderLong(0, hashTreeSize);
    }

    public long getHashTreeSize() throws IOException {
        return this.file.readHeaderLong(0);
    }

    public void setHashTreeTombstone(long hashTreeTombstone) throws IOException {
        this.file.writeHeaderLong(8, hashTreeTombstone);
    }

    public long getHashTreeTombstone() throws IOException {
        return this.file.readHeaderLong(8);
    }

    public void setBucketTombstonePointer(long bucketTombstonePointer) throws IOException {
        this.file.writeHeaderLong(16, bucketTombstonePointer);
    }

    public long getBucketTombstonePointer() throws IOException {
        return this.file.readHeaderLong(16);
    }

    public void storeTreeState(long[][] hashTree, OHashTreeNodeMetadata[] nodesMetadata) throws IOException {
        this.truncate();
        this.file.allocateSpace(hashTree.length * 2052);
        long filePosition = 0L;
        for (int i = 0; i < hashTree.length; ++i) {
            long[] node = hashTree[i];
            byte[] nodeContentBuffer = new byte[2052];
            int offset = 0;
            if (node != null) {
                OBooleanSerializer.INSTANCE.serializeNative(Boolean.valueOf(true), nodeContentBuffer, offset);
                ++offset;
                for (long position : node) {
                    OLongSerializer.INSTANCE.serializeNative(Long.valueOf(position), nodeContentBuffer, offset);
                    offset += 8;
                }
                OHashTreeNodeMetadata nodeMetadata = nodesMetadata[i];
                nodeContentBuffer[offset++] = (byte)nodeMetadata.getMaxLeftChildDepth();
                nodeContentBuffer[offset++] = (byte)nodeMetadata.getMaxRightChildDepth();
                nodeContentBuffer[offset] = (byte)nodeMetadata.getNodeLocalDepth();
            } else {
                OBooleanSerializer.INSTANCE.serializeNative(Boolean.valueOf(false), nodeContentBuffer, offset);
            }
            this.file.write(filePosition, nodeContentBuffer);
            filePosition += (long)nodeContentBuffer.length;
        }
    }

    public TreeState loadTreeState(int hashTreeSize) throws IOException {
        OHashTreeNodeMetadata[] hashTreeNodeMetadata = new OHashTreeNodeMetadata[hashTreeSize];
        long[][] hashTree = new long[hashTreeSize][];
        long filePosition = 0L;
        for (int i = 0; i < hashTreeSize; ++i) {
            byte[] contentBuffer = new byte[2052];
            this.file.read(filePosition, contentBuffer, contentBuffer.length);
            int offset = 0;
            boolean notNullNode = OBooleanSerializer.INSTANCE.deserializeNative(contentBuffer, offset);
            ++offset;
            if (notNullNode) {
                OHashTreeNodeMetadata nodeMetadata;
                long[] node = new long[256];
                for (int n = 0; n < node.length; ++n) {
                    node[n] = OLongSerializer.INSTANCE.deserializeNative(contentBuffer, offset);
                    offset += 8;
                }
                hashTree[i] = node;
                hashTreeNodeMetadata[i] = nodeMetadata = new OHashTreeNodeMetadata(contentBuffer[offset++], contentBuffer[offset++], contentBuffer[offset]);
            } else {
                hashTree[i] = null;
                hashTreeNodeMetadata[i] = null;
                hashTreeNodeMetadata[i] = null;
            }
            filePosition += 2052L;
        }
        return new TreeState(hashTree, hashTreeNodeMetadata);
    }

    public static class TreeState {
        private final long[][] hashTree;
        private final OHashTreeNodeMetadata[] hashTreeNodeMetadata;

        public TreeState(long[][] hashTree, OHashTreeNodeMetadata[] hashTreeNodeMetadata) {
            this.hashTree = hashTree;
            this.hashTreeNodeMetadata = hashTreeNodeMetadata;
        }

        public long[][] getHashTree() {
            return this.hashTree;
        }

        public OHashTreeNodeMetadata[] getHashTreeNodeMetadata() {
            return this.hashTreeNodeMetadata;
        }
    }
}

