/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OLocalHashTableIndexEngine;
import com.orientechnologies.orient.core.index.engine.OMemoryHashMapIndexEngine;
import com.orientechnologies.orient.core.index.engine.ORemoteIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OHashIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString());
        TYPES = Collections.unmodifiableSet(types);
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public OIndexInternal<?> createIndex(ODatabaseRecord database, String indexType) throws OConfigurationException {
        OMemoryHashMapIndexEngine<Set<OIdentifiable>> indexEngine;
        OStorage storage = database.getStorage();
        String storageType = storage.getType();
        if (storageType.equals("memory")) {
            indexEngine = new OMemoryHashMapIndexEngine();
        } else if (storageType.equals("local") || storageType.equals("plocal")) {
            indexEngine = new OLocalHashTableIndexEngine();
        } else if (storageType.equals("remote")) {
            indexEngine = new ORemoteIndexEngine();
        } else {
            throw new OIndexException("Unsupported storage type : " + storageType);
        }
        if (OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexUnique(indexType, (OIndexEngine<OIdentifiable>)indexEngine);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexNotUnique(indexType, (OIndexEngine<Set<OIdentifiable>>)indexEngine);
        }
        if (OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexFullText(indexType, (OIndexEngine<Set<OIdentifiable>>)indexEngine);
        }
        if (OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexDictionary(indexType, (OIndexEngine<OIdentifiable>)indexEngine);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }
}

