/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OMemoryHashMapIndexEngine<V>
implements OIndexEngine<V> {
    private final ConcurrentMap<Object, V> concurrentHashMap = new ConcurrentHashMap<Object, V>();
    private volatile ORID identity;

    @Override
    public void init() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void create(String indexName, OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        ODatabaseRecord database = this.getDatabase();
        ORecordBytes identityRecord = new ORecordBytes();
        database.save(identityRecord, clusterIndexName);
        this.identity = identityRecord.getIdentity();
    }

    @Override
    public void delete() {
    }

    @Override
    public void load(ORID indexRid, String indexName, boolean isAutomatic) {
    }

    @Override
    public boolean contains(Object key) {
        return this.concurrentHashMap.containsKey(key);
    }

    @Override
    public boolean remove(Object key) {
        return this.concurrentHashMap.remove(key) != null;
    }

    @Override
    public ORID getIdentity() {
        return this.identity;
    }

    @Override
    public void clear() {
        this.concurrentHashMap.clear();
    }

    @Override
    public Iterator<Map.Entry<Object, V>> iterator() {
        return this.concurrentHashMap.entrySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<Object, V>> inverseIterator() {
        throw new UnsupportedOperationException("inverseIterator");
    }

    @Override
    public Iterator<V> valuesIterator() {
        throw new UnsupportedOperationException("valuesIterator");
    }

    @Override
    public Iterator<V> inverseValuesIterator() {
        throw new UnsupportedOperationException("inverseValuesIterator");
    }

    @Override
    public Iterable<Object> keys() {
        return this.concurrentHashMap.keySet();
    }

    @Override
    public void unload() {
    }

    @Override
    public void startTransaction() {
    }

    @Override
    public void stopTransaction() {
    }

    @Override
    public void afterTxRollback() {
    }

    @Override
    public void afterTxCommit() {
    }

    @Override
    public void closeDb() {
    }

    @Override
    public void close() {
    }

    @Override
    public void beforeTxBegin() {
    }

    @Override
    public V get(Object key) {
        return this.concurrentHashMap.get(key);
    }

    @Override
    public void put(Object key, V value) {
        this.concurrentHashMap.put(key, value);
    }

    @Override
    public int removeValue(OIdentifiable valueToRemove, OIndexEngine.ValuesTransformer<V> transformer) {
        HashMap entriesToUpdate = new HashMap();
        for (Map.Entry entry : this.concurrentHashMap.entrySet()) {
            if (transformer != null) {
                Collection<OIdentifiable> rids = transformer.transformFromValue(entry.getValue());
                if (!rids.remove(valueToRemove)) continue;
                entriesToUpdate.put(entry.getKey(), transformer.transformToValue(rids));
                continue;
            }
            if (!entry.getValue().equals(valueToRemove)) continue;
            entriesToUpdate.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : entriesToUpdate.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                if (col.isEmpty()) {
                    this.concurrentHashMap.remove(entry.getKey());
                    continue;
                }
                this.concurrentHashMap.put(entry.getKey(), value);
                continue;
            }
            this.concurrentHashMap.remove(entry.getKey());
        }
        return entriesToUpdate.size();
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getValuesBetween");
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getValuesMajor");
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getValuesMinor");
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getEntriesMajor");
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getEntriesMinor");
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getEntriesBetween");
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        if (transformer == null) {
            return this.concurrentHashMap.size();
        }
        long counter = 0L;
        for (Object value : this.concurrentHashMap.values()) {
            counter += (long)transformer.transformFromValue(value).size();
        }
        return counter;
    }

    @Override
    public long count(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("count");
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

