/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OLocalHashTable;
import com.orientechnologies.orient.core.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class OLocalHashTableIndexEngine<V>
implements OIndexEngine<V> {
    public static final String METADATA_FILE_EXTENSION = ".him";
    public static final String TREE_FILE_EXTENSION = ".hit";
    public static final String BUCKET_FILE_EXTENSION = ".hib";
    private final OLocalHashTable<Object, V> hashTable;
    private final OMurmurHash3HashFunction<Object> hashFunction = new OMurmurHash3HashFunction();
    private volatile ORID identity;

    public OLocalHashTableIndexEngine() {
        this.hashTable = new OLocalHashTable(METADATA_FILE_EXTENSION, TREE_FILE_EXTENSION, BUCKET_FILE_EXTENSION, this.hashFunction);
    }

    @Override
    public void init() {
    }

    @Override
    public void create(String indexName, OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        Object keySerializer = indexDefinition != null ? (indexDefinition instanceof ORuntimeKeyIndexDefinition ? ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer() : (indexDefinition.getTypes().length > 1 ? OCompositeKeySerializer.INSTANCE : OBinarySerializerFactory.INSTANCE.getObjectSerializer(indexDefinition.getTypes()[0]))) : new OSimpleKeySerializer();
        ODatabaseRecord database = this.getDatabase();
        ORecordBytes identityRecord = new ORecordBytes();
        OStorageLocalAbstract storageLocalAbstract = (OStorageLocalAbstract)database.getStorage();
        database.save(identityRecord, clusterIndexName);
        this.identity = identityRecord.getIdentity();
        this.hashFunction.setValueSerializer((OBinarySerializer<Object>)keySerializer);
        this.hashTable.create(indexName, (OBinarySerializer<Object>)keySerializer, (OBinarySerializer<V>)((OBinarySerializer)valueSerializer), storageLocalAbstract);
    }

    @Override
    public void flush() {
        this.hashTable.flush();
    }

    @Override
    public void delete() {
        this.hashTable.delete();
    }

    @Override
    public void load(ORID indexRid, String indexName, boolean isAutomatic) {
        this.identity = indexRid;
        this.hashTable.load(indexName, (OStorageLocalAbstract)this.getDatabase().getStorage());
        this.hashFunction.setValueSerializer(this.hashTable.getKeySerializer());
    }

    @Override
    public boolean contains(Object key) {
        return this.hashTable.get(key) != null;
    }

    @Override
    public boolean remove(Object key) {
        return this.hashTable.remove(key) != null;
    }

    @Override
    public void clear() {
        this.hashTable.clear();
    }

    @Override
    public void unload() {
    }

    @Override
    public void closeDb() {
    }

    @Override
    public void close() {
        this.hashTable.close();
    }

    @Override
    public V get(Object key) {
        return this.hashTable.get(key);
    }

    @Override
    public void put(Object key, V value) {
        this.hashTable.put(key, value);
    }

    @Override
    public int removeValue(OIdentifiable valueToRemove, OIndexEngine.ValuesTransformer<V> transformer) {
        HashMap entriesToUpdate = new HashMap();
        OHashIndexBucket.Entry<Object, V> firstEntry = this.hashTable.firstEntry();
        if (firstEntry == null) {
            return 0;
        }
        OHashIndexBucket.Entry<Object, V>[] entries = this.hashTable.ceilingEntries(firstEntry.key);
        while (entries.length > 0) {
            OHashIndexBucket.Entry<Object, V>[] entryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry entry = entryArray[n2];
                if (transformer != null) {
                    Collection<OIdentifiable> rids = transformer.transformFromValue(((OHashIndexBucket.Entry)((Object)entry)).value);
                    if (rids.remove(valueToRemove)) {
                        entriesToUpdate.put(((OHashIndexBucket.Entry)((Object)entry)).key, transformer.transformToValue(rids));
                    }
                } else if (((OHashIndexBucket.Entry)((Object)entry)).value.equals(valueToRemove)) {
                    entriesToUpdate.put(((OHashIndexBucket.Entry)((Object)entry)).key, ((OHashIndexBucket.Entry)((Object)entry)).value);
                }
                ++n2;
            }
            entries = this.hashTable.higherEntries(entries[entries.length - 1].key);
        }
        for (Map.Entry entry : entriesToUpdate.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                if (col.isEmpty()) {
                    this.hashTable.remove(entry.getKey());
                    continue;
                }
                this.hashTable.put(entry.getKey(), value);
                continue;
            }
            this.hashTable.remove(entry.getKey());
        }
        return entriesToUpdate.size();
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        if (transformer == null) {
            return this.hashTable.size();
        }
        OHashIndexBucket.Entry<Object, V> firstEntry = this.hashTable.firstEntry();
        if (firstEntry == null) {
            return 0L;
        }
        OHashIndexBucket.Entry<Object, V>[] entries = this.hashTable.ceilingEntries(firstEntry.key);
        long counter = 0L;
        while (entries.length > 0) {
            OHashIndexBucket.Entry<Object, V>[] entryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                OHashIndexBucket.Entry<Object, V> entry = entryArray[n2];
                counter += (long)transformer.transformFromValue(entry.value).size();
                ++n2;
            }
            entries = this.hashTable.higherEntries(entries[entries.length - 1].key);
        }
        return counter;
    }

    @Override
    public ORID getIdentity() {
        return this.identity;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public Iterator<Map.Entry<Object, V>> iterator() {
        return new EntriesIterator();
    }

    @Override
    public Iterable<Object> keys() {
        return new KeysIterable();
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getValuesBetween");
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getValuesMajor");
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getValuesMinor");
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getEntriesMajor");
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getEntriesMinor");
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("getEntriesBetween");
    }

    @Override
    public long count(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, int maxValuesToFetch, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("count");
    }

    @Override
    public Iterator<V> valuesIterator() {
        throw new UnsupportedOperationException("valuesIterator");
    }

    @Override
    public Iterator<V> inverseValuesIterator() {
        throw new UnsupportedOperationException("inverseValuesIterator");
    }

    @Override
    public void startTransaction() {
    }

    @Override
    public void stopTransaction() {
    }

    @Override
    public void afterTxRollback() {
    }

    @Override
    public void afterTxCommit() {
    }

    @Override
    public void beforeTxBegin() {
    }

    @Override
    public Iterator<Map.Entry<Object, V>> inverseIterator() {
        throw new UnsupportedOperationException("inverseIterator");
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private final class EntriesIterator
    implements Iterator<Map.Entry<Object, V>> {
        private int nextEntriesIndex;
        private OHashIndexBucket.Entry<Object, V>[] entries;

        private EntriesIterator() {
            OHashIndexBucket.Entry firstEntry = OLocalHashTableIndexEngine.this.hashTable.firstEntry();
            this.entries = firstEntry == null ? new OHashIndexBucket.Entry[0] : OLocalHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
        }

        @Override
        public boolean hasNext() {
            return this.entries.length > 0;
        }

        @Override
        public Map.Entry<Object, V> next() {
            if (this.entries.length == 0) {
                throw new NoSuchElementException();
            }
            final OHashIndexBucket.Entry bucketEntry = this.entries[this.nextEntriesIndex];
            ++this.nextEntriesIndex;
            if (this.nextEntriesIndex >= this.entries.length) {
                this.entries = OLocalHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                this.nextEntriesIndex = 0;
            }
            return new Map.Entry<Object, V>(){

                @Override
                public Object getKey() {
                    return bucketEntry.key;
                }

                @Override
                public V getValue() {
                    return bucketEntry.value;
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private final class KeysIterable
    implements Iterable<Object> {
        private KeysIterable() {
        }

        @Override
        public Iterator<Object> iterator() {
            final EntriesIterator entriesIterator = new EntriesIterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return entriesIterator.hasNext();
                }

                @Override
                public Object next() {
                    return entriesIterator.next().getKey();
                }

                @Override
                public void remove() {
                    entriesIterator.remove();
                }
            };
        }
    }
}

