/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OPropertyListIndexDefinition
extends OAbstractIndexDefinitionMultiValue
implements OIndexDefinitionMultiValue {
    public OPropertyListIndexDefinition(String iClassName, String iField, OType iType) {
        super(iClassName, iField, iType);
    }

    public OPropertyListIndexDefinition() {
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        return this.createValue(iDocument.field(this.field));
    }

    @Override
    public Object createValue(List<?> params) {
        if (!(params.get(0) instanceof Collection)) {
            return null;
        }
        Collection multiValueCollection = (Collection)params.get(0);
        ArrayList<Object> values = new ArrayList<Object>(multiValueCollection.size());
        for (Object item : multiValueCollection) {
            values.add(this.createSingleValue(item));
        }
        return values;
    }

    @Override
    public Object createValue(Object ... params) {
        if (!(params[0] instanceof Collection)) {
            return null;
        }
        Collection multiValueCollection = (Collection)params[0];
        ArrayList<Object> values = new ArrayList<Object>(multiValueCollection.size());
        for (Object item : multiValueCollection) {
            values.add(this.createSingleValue(item));
        }
        return values;
    }

    @Override
    public Object createSingleValue(Object ... param) {
        return OType.convert(param[0], this.keyType.getDefaultJavaType());
    }

    @Override
    public void processChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<Object, Integer> keysToAdd, Map<Object, Integer> keysToRemove) {
        switch (changeEvent.getChangeType()) {
            case ADD: {
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                break;
            }
            case REMOVE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                break;
            }
            case UPDATE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)changeEvent.getChangeType()));
            }
        }
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType) {
        return this.createIndexDDLWithoutFieldType(indexName, indexType).toString();
    }
}

