/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OMVRBTreeIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OMVRBIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY.toString());
        TYPES = Collections.unmodifiableSet(types);
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public OIndexInternal<?> createIndex(ODatabaseRecord iDatabase, String indexType) throws OConfigurationException {
        if (OClass.INDEX_TYPE.UNIQUE.toString().equals(indexType)) {
            return new OIndexUnique(indexType, (OIndexEngine<OIdentifiable>)new OMVRBTreeIndexEngine<OIdentifiable>());
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType)) {
            return new OIndexNotUnique(indexType, (OIndexEngine<Set<OIdentifiable>>)new OMVRBTreeIndexEngine<Set<OIdentifiable>>());
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            return new OIndexFullText(indexType, (OIndexEngine<Set<OIdentifiable>>)new OMVRBTreeIndexEngine<Set<OIdentifiable>>());
        }
        if (OClass.INDEX_TYPE.DICTIONARY.toString().equals(indexType)) {
            return new OIndexDictionary(indexType, (OIndexEngine<OIdentifiable>)new OMVRBTreeIndexEngine<OIdentifiable>());
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }
}

